#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *GOOD-DN-LEVEL-EXPS* *GOOD-UP-LEVEL-EXPS* *META-FUNCTIONS*
		    *META-PREDICATES* *SINGLETON-PREDS*
		    *AT-LEAST-ONE-GENERATORSS*))


(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


(defun TF-trimable (exp)
    (and (not (eql t exp))
	 (or (member t exp)(member nil exp))))

(defun TF-trim (exp)
    (cond ((eql (car exp) 'and)
	   (cond ((member nil exp) nil)
		 ((member t exp)
		  (g-map (e in exp)
			(when (not (eql t e)))
			(save e)))
		 (t exp)))
	  ((eql (car exp) 'or)	
	   (cond ((member t exp) t)
		 ((member nil exp)	
		  (g-map (e in exp)
			(when e)
			(save e)))
		 (t exp)))))


(defun ao-collapsable (orig-exp)
    (cond ((eql orig-exp t) nil)
	  ((eql (car orig-exp) 'and)
	   (or (null (cddr orig-exp))
	       (assoc 'and (cdr orig-exp)))) ;  this is a hack, may be wrong!
	  ((eql (car orig-exp) 'or)
	   (or (null (cddr orig-exp))
	       (assoc 'or (cdr orig-exp))))))	         		

; assumes its collapsable!!
; have to do a TF-trim before invoking this!

(defun ao-collapse (orig-exp)
    (cond ((null (cdr orig-exp))
	   (cond ((eql (car orig-exp) 'and) t)
		 ((eql (car orig-exp) 'or) nil)))
	  ((null (cddr orig-exp))
	   (cadr orig-exp))
	  (t (g-loop (init exp orig-exp ret-val nil)
		     (next exp (cdr exp))
		     (while exp)
		     (do (cond ((eql (car orig-exp)(caar exp))
				(setq ret-val
				      (nconc (reverse (cdar exp)) ret-val)))
			       (t (push (car exp) ret-val))))
		     (result (cons (car orig-exp) (nreverse ret-val)))))))


		     
; takes (or a b (and a c)) ===> (or a b)


; takes (or (and a b c)(and a d e)) ==> (and a (or (and b c)(and d e)))
; this operation can actually create ordering problems, I think...

;  (or (and (p y)(q y))(and (p x)(q x)))
;  neither y nor x can be defined outside, unless they are singletons...
;  in which case if they are defined outside they should have been 
;  taken care of by the singleton stuff...

; common atomics may be in a subset of the sub-exps, but
; they are ordered accordingly

(defun dn-or-raise (exp path)
    (g-loop (init commons (find-common-atomics 'and (cdr exp) path)
		exps-with-common nil exps-without-common nil
		init-common nil)
	  (before-starting 
	      (cond ((null commons)(return exp))
		    (t (setq init-common (car commons)))))
	  (next exp (cdr exp))
	  (while exp)
	  (do (cond ((eql t (car exp)) (return t)) ; just in case
		    ((member (car commons) (car exp))
		     (push (del-common init-common
			       (car commons) (car exp))
			   exps-with-common)
		     (setq commons (cdr commons)))
		    (t (push (car exp) exps-without-common))))
	  (before-returning (progn (setq exps-with-common
					 (nreverse exps-with-common))
				   (setq exps-without-common
					 (nreverse exps-without-common))))
	  (result (cond ((null exps-without-common) ; none
			 (list 'and init-common
			       (cons 'or exps-with-common)))
			((null (cdr exps-without-common)) ; one
			 (list 'or (car exps-without-common)
			       (list 'and init-common
				     (cons 'or exps-with-common))))
			(t (fancy-ao-simplify
			    (list 'or (cons 'or exps-without-common)
				  (list 'and init-common
					(cons 'or exps-with-common)))))))))
; two or more ands

(defun or-raisable (exp)
    (and (not (atom exp))
	 (member-subexp 'and (cdr (member-subexp 'and exp)))))


(defun and-raisable (exp)
    (and (not (atom exp))
	 (member-subexp 'or (cdr (member-subexp  'or exp)))))


(defun dn-and-raise (exp path)
    (g-loop (init commons (find-common-atomics 'or (cdr exp) path)
		exps-with-common nil exps-without-common nil
		init-common nil)
	  (before-starting 
	      (cond ((null commons)(return exp))
		    (t (setq init-common (car commons)))))
	  (next exp (cdr exp))
	  (while exp)
	  (do (cond ((eql t (car exp))) ;  get rid of t's
		    ((member (car commons) (car exp))
		     (push (del-common init-common
				       (car commons) (car exp))
			   exps-with-common)
		     (setq commons (cdr commons)))
		    (t (push (car exp) exps-without-common))))
	  (before-returning (progn (setq exps-with-common
					 (nreverse exps-with-common))
				   (setq exps-without-common
					 (nreverse exps-without-common))))
	  (result (cond ((null exps-without-common) ; none
			 (list 'or init-common
			       (cons 'and exps-with-common)))
			((null (cdr exps-without-common)) ; one
			 (list 'and (car exps-without-common)
			       (list 'or init-common
				     (cons 'and exps-with-common))))
			(t (list 'and (cons 'and exps-without-common)
				 (list 'or init-common
				       (cons 'and exps-with-common))))))))

; outside atomic will be raised, inside-atomic
; is the matching atomic inside exp.

(defun del-common (out-atomic in-atomic exp)
    (prog (new-exp)
    (setq new-exp (subst-bindings (del-eq in-atomic exp)
		    (r-get-matching-vars in-atomic out-atomic nil)))
    (cond ((not (member (car new-exp) '(and or)))
	   (error "del-comon: somethings wrong"))
	  ((null (cdr new-exp))
	   (error "del-comon: somethings wrong2"))
	  ((eql 2 (length new-exp)) (return (cadr new-exp)))
	  (t (return new-exp)))))

; assumes that they match!


(defun r-get-matching-vars (l1 l2 bindings)
    (cond ((and (is-variable l1)
		(is-variable l2)
		(not (eql l1 l2)))
	   (cons (list l1 l2) bindings))
	  ((and (not (atom l1))
		(not (atom l2)))
	   (g-loop (while l1)
		 (do (setq bindings
			   (r-get-matching-vars (car l1) (car l2)
			       bindings)))
		 (next l1 (cdr l1) l2 (cdr l2))
		 (result bindings)))
	  ((not (eql l1 l2))
	   (error "something wrong in r-get-matching-vars"))
	  (t bindings)))
	  
		 




; e-type is 'and or 'or, the type of the sub expressions.
; finds common atomics whose
; uncommon variables are not defined outside.

; common atomics may be in a subset of exps

(defun find-common-atomics (e-type exps path)
    (g-loop (init commons nil exp nil)
	  (next exp (car exps)
		exps (cdr exps))
	  (while exps)	; no sense if run out of exps
	  (do (cond ((eql (car exp) e-type)
		     (g-loop (init subs (cdr exp))
			     (while subs)
			     (do (and (atomic-formula-p (car subs))
				      (setq commons
					    (r-get-commons
					     (car subs) exp e-type
					     exps path))))
			     (next subs (cdr subs))
			     (until commons)))))
	  (until commons)
	  (result commons)))

; looks through rest-exps to see if it can find
; some matches for atomic
; returns commons atomics, ordered 

(defun r-get-commons (atomic exp1 e-type rest-exps path)
    (g-loop (init commons nil common nil)
	  (while rest-exps)
	  (do (and (eql (caar rest-exps) e-type)
		   (setq common 
			 (find-matching-atomic atomic exp1
			     (cdar rest-exps) (car rest-exps)
			     path))
		   (push common commons)))
	  (next rest-exps (cdr rest-exps))
	  (result (and commons (cons atomic (nreverse commons))))))

; atomic is an atomic in exp1, atomics are the atomics in exp2
; if there's a matching atomic, it's returned else nil
; only reasonable to have one per exp

(defun find-matching-atomic (atomic exp1 atomics exp2 path)
    (cond ((null (assoc (car atomic) atomics)) nil)
	  ((is-matching-atomic atomic exp1
	       (assoc (car atomic) atomics) exp2 path))
	  (t (find-matching-atomic
	      atomic exp1
	      (cdr (member (assoc (car atomic) atomics) atomics))
	      exp2 path))))
	  
; must be same pred-type. assume known is a pred-type 
; ie. atomic1 can be a (known atomic).

(defun is-matching-atomic (atomic1 exp1 atomic2 exp2 path)
    (g-loop (init val1 nil val2 nil orig-atomic2 atomic2)
	  (while (and (setq val1 (pop atomic1))
		      (setq val2 (pop atomic2))))
	  (do (cond ((eql val1 val2))
		    ((and (is-variable val1)
			  (is-variable val2)
			  (not (defined-outside exp2 val2 path))
			  (not (defined-outside exp1 val1 path))))
		    ((and (listp val1)
			  (listp val2)
			  (is-matching-atomic val1 exp1 val2 exp2 path)))
		    (t (return nil))))
	  (result orig-atomic2)))
    






; recursion necessary to get rid of internal "ands" introduced
; replace-redundant-eqs

; used externally

(defun ao-simplify (exp)
  (if (TF-trimable exp) (setq exp (TF-trim exp)))
  (if (ao-collapsable exp) (setq exp (ao-collapse exp)))
  (if (has-duplicates-in-ao exp) (rm-duplicates-in-ao exp)
    exp))

(defun fancy-ao-simplify (exp)
  (if (TF-trimable exp) (setq exp (TF-trim exp)))
  (if (ao-collapsable exp) (setq exp (ao-collapse exp)))
  (if (has-duplicates-in-ao exp) (setq exp (rm-duplicates-in-ao exp)))
  (if (has-big-duplicates-in-ao exp) (setq exp (rm-big-duplicates-in-ao exp)))
  (if (has-combinable-foralls exp) (combine-foralls exp)
    exp))

(defun has-combinable-foralls (exp)
  (cond ((atom exp) nil)
	((not (eql (car exp) 'and)) nil)
	(t (setq exp (cdr exp))
	   (g-loop (init sub nil)
		   (while (setq sub (pop exp)))
		   (do (cond ((and (eql 'forall (car sub))
				   (atomic-formula-p (get-gen-exp sub))
				   (look-for-combinable-foralls
				    (get-vars-lst sub) (get-gen-exp sub) exp))
			      (return t))))))))

(defun look-for-combinable-foralls (vars gen exps)
  (if gen
      (progn
	(if (eql (car gen) 'known)
	    (if (atomic-formula-p (caddr gen)) (setq gen (caddr gen))))
	(g-loop (init ret-val nil sub nil sub-gen nil)
		(while (setq sub (pop exps)))
		(do (and (eql (car sub) 'forall)
			 (setq sub-gen (get-gen-exp sub))
			 (or (not (eql (car sub-gen) 'known))
			     (setq sub-gen (caddr sub-gen)))
			 (eql (car gen) (car sub-gen))
			 (g-loop (init gen1-vars (cdr gen)
				       gen2-vars (cdr sub-gen))
				 (while gen1-vars)
				 (do (cond ((eql (car gen1-vars)
						 (car gen2-vars)))
					   ((and (member (car gen1-vars) vars)
						 (member (car gen2-vars)
							 (get-vars-lst sub))))
					   ((return nil))))
				 (next gen1-vars (cdr gen1-vars)
				       gen2-vars (cdr gen2-vars))
				 (result t))
			 (push sub ret-val)))
		(result ret-val)))))

; only does one set at a time, but that should be enough

(defun combine-foralls (exp)
    (g-loop (init subs (cdr exp) sub nil others nil new-forall nil)
	  (while (setq sub (pop subs)))
	  (do (cond ((and (eql 'forall (car sub))
			  (atomic-formula-p (get-gen-exp sub))
			  (setq others
				(look-for-combinable-foralls 
				 (get-vars-lst sub)
				 (get-gen-exp sub) subs)))
		     (setq exp (g-map (e in exp)
				      (when (not (member e others)))
				      (save e)))
		     (setq others (g-map (o in others)
					 (save (subpair (get-vars-lst o)
							(get-vars-lst sub)
							(get-exp o)))))
		     (setq new-forall
			   (list 'forall
				 (get-vars-lst sub)
				 (get-gen-exp sub)
				 (fancy-ao-simplify (cons 'and (cons (get-exp sub) others)))))
		     (setq exp (subst new-forall sub exp))
		     (cond ((null (cddr exp))
			    (return (cadr exp)))
			   ((return exp))))))
	  (result (error "shouldnt get this far, combine-foralls"))))





(defun has-duplicates-in-ao (orig-exp)
    (and (not (eql orig-exp t))
	 (member (car orig-exp) '(and or))
	 (g-loop (while orig-exp)
	       (do (and (member (car orig-exp)
				(cdr orig-exp) :test #'equal)
			(return t)))
	       (next orig-exp (cdr orig-exp)))))

; Returns nil if not AO-collapsed, trimmed

(defun has-big-duplicates-in-ao (orig-exp)
    (and (not (eql orig-exp t))
	 (not (member t orig-exp))
	 (member (car orig-exp) '(and or))
	 (not (assoc (car orig-exp)(cdr orig-exp)))
	 (g-loop (init exp (cdr orig-exp) found nil)
	       (while (cdr exp))
	       (until (g-loop (init sub (car exp) others (cdr exp))
			    (while others)
			    (do (cond ((and (member (caar others) '(and or))
					    (member sub (car others)
						    :test #'equal))
				       (setq found t))
				      ((and (member (car sub) '(and or))
					    (member (car others) sub
						    :test #'equal))
				       (setq found t))
				      ; try both for the hell of it
				      ((equal sub (car others))
				       (setq found t))))
			    (until found)
			    (next others (cdr others))))
	       (next exp (cdr exp))
	       (result found))))


;  assume its an and-or

(defun rm-duplicates-in-ao (exp)
   (let ((new-exp (r-rm-duplicates-in-ao exp)))
       (cond ((null (cddr new-exp)) (cadr new-exp))
	     (t new-exp))))

(defun r-rm-duplicates-in-ao (exp)
  (cond ((null (cdr exp))
	 exp)
	((member (car exp) (cdr exp) :test #'equal)
	 (r-rm-duplicates-in-ao (cdr exp)))
	(t (cons (car exp)
		 (r-rm-duplicates-in-ao (cdr exp))))))


; ASSUMES has-duplicates-in-ao

; also takes (or  a (and a d e)) ==> a
;  NOW TAKEN CARE OF BY dn-is-counter

(defun rm-big-duplicates-in-ao (orig-exp)
    (g-loop (init exp orig-exp ret-val (list (pop exp)))
	  (while exp)
	  (do (g-loop (init sub (car exp) others (cdr orig-exp) found nil)
		    (do (cond ((and (not (member (caar others) '(and or)))
				    (member (car sub) '(and or))
				    (not (eql (car others) sub))
				    (member (car others) sub :test #'equal))
			       (setq found t))))
		    (next others (cdr others))
		    (until (null others))
		    (result (or found (push sub ret-val)))))
	  (next exp (cdr exp))
	  (result (cond ((cddr ret-val)
			 (nreverse ret-val))
			((cdr ret-val)
			 (car ret-val))
			(t (error "rm-duplicates-in-ao, wierdness"))))))
 




;  should put this in data-types!!

(defun meta-level-p (exp)
    (or (member (car exp) *META-FUNCTIONS*)
	(member (car exp) *META-FUNCTIONS*)))

(defun all-meta-preds-in-exp (exp)
    (cond ((eql exp t) t)
	  ((null exp) t)
	  ((member (car exp) '(known achievable provable))
	   (all-meta-preds-in-exp (caddr exp)))
	  ((or (eql (car exp) 'forall) 
	       (eql (car exp) 'exists))
	   (and (all-meta-preds-in-exp (get-gen-exp exp))
		(all-meta-preds-in-exp (get-exp exp))))
	  ((eql (car exp) '~)
	   (all-meta-preds-in-exp (cadr exp)))
	  ((or (eql (car exp) 'and)
	       (eql (car exp) 'or))
	   (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (or (all-meta-preds-in-exp (car exp))
			 (return nil)))
		 (result t)))
	  (t (meta-level-p exp))))

(defun atomic-simplify (exp)
    (cond ((eql exp t) t)
	  ((eql (car exp) 'not-equal)
	   (cond ((and (is-constant (cadr exp))
		       (is-constant (caddr exp)))
		  (not (equal (cadr exp) (caddr exp))))
		 ((equal (cadr exp) (caddr exp))
		  nil)
		 (exp)))
	  ((eql (car exp) 'is-equal)
	   (up-eq-simplify exp))
	  ((eql (car exp) 'matches) ; take out matches later...
	   (up-eq-simplify (cons 'is-equal (cdr exp))))
	  (t exp)))
    

(defun up-eq-simplify (exp)
   (cond ((equal (cadr exp) (caddr exp)) t) ; same variable
	 ((or (is-variable (cadr exp))
	      (is-variable (caddr exp))) exp)
         ((and (listp (cadr exp))
	       (listp (caddr exp)))
	  (let ((new-is-equals (find-unifiers (cadr exp) (caddr exp))))
	       (cond ((eql t new-is-equals) t)
		     ((null new-is-equals) nil)
		     ((cons 'and new-is-equals)))))))
	  


; returns list of new is-equals
;  nil if no match possible, t if its all constants and they match...

(defun find-unifiers (lit1 lit2)
    (cond ((negated-p lit1)
	   (find-unifiers (cadr lit1)(cadr lit2)))
	  (t 
	     (g-loop (init ret-val nil)
		   (while lit1)
		   (do (cond ((is-variable (car lit1))
			      (push (list 'is-equal (car lit1)(car lit2)) ret-val))
			     ((is-variable (car lit2))
			      (push (list 'is-equal (car lit2)(car lit1)) ret-val))
			     ((not (eql (car lit1)(car lit2)))
			      (return nil))))
		   (next lit1 (cdr lit1) lit2 (cdr lit2))
		   (result (or ret-val t))))))




(defun negated-simplify (exp)
    (let ((sub (cadr exp)))
	 (cond ((eql sub t) nil)
	       ((eql (car sub) 'not-equal)
	        (list 'is-equal (cadr sub) (caddr sub)))
	       ((eql (car sub) 'known)
		(cond ((and (atomic-formula-p (caddr sub))
			    (not (closed-predicate (caddr sub)))
			    (not (function-p (caddr sub))))
		       exp)
		      ((list 'known (cadr sub) 
			     (move-neg-inward (caddr sub))))))
	       (t exp))))



(defun move-neg-inward (exp)
    (cond ((eql (car exp) 'forall)
	   (list 'exists
		 (get-vars-lst exp)
		 (get-gen-exp exp)
		 (move-neg-inward (get-exp exp))))
	  ((eql (car exp) 'exists)
	   (list 'forall
		 (get-vars-lst exp)
		 (get-gen-exp exp)
		 (move-neg-inward (get-exp exp))))
	  ((eql (car exp) 'and)
	   (cons 'or
		 (g-map (sub in exp)
		       (save (move-neg-inward sub)))))
 	  ((eql (car exp) 'or)
	   (cons 'and
		 (g-map (sub in exp)
		       (save (move-neg-inward sub)))))
	  (t (negate exp))))
	  

(defun dn-negated-simplify (exp path)
    (cond ((eql (caadr exp) 'exists) exp)
	  ; should probably do below for positive atomics too
	  ((neg-implied-by-goal (cadr exp) path) 
	   t)
	  ((dn-redundancy-elimination exp path)
	   t)
	  ((dn-is-counter exp path)
	   nil)
	  (t exp)))



(defun known-simplify (exp)
    (cond ((not (eql (car exp) 'known)) exp)
	  ((eql (caddr exp) t) t)
	  ((eql (caddr exp) nil) nil)
	  ((is-variable (caddr exp)) exp)
	  ((atomic-formula-p (caddr exp))
	   (cond ((meta-level-p (caddr exp))
		  (caddr exp))
		 (exp)))
	  ((negated-p (caddr exp)) exp) ; should hand to negated simplify...
	  (t (move-known-inward (cadr exp) (caddr exp)))))

(defun move-known-inward (n inexp)
    (cond ((atom inexp) inexp)
	  ((member (car inexp) '(and or))
	   (cons (car inexp) 
		 (g-map (sub in (cdr inexp))
		       (save (move-known-inward n sub)))))
	  ((member (car inexp) '(forall exists))
	   (list (car inexp) (cadr inexp)
		 (move-known-inward n (get-gen-exp inexp))
		 (move-known-inward n (get-exp inexp))))
	  ((negated-p inexp) 	; should hand to negated simplify....
	   (list 'known n inexp))
	  ((meta-level-p inexp) inexp)
	  (t (list 'known n inexp))))

	       
	   
	   

			
; ASSUMES HAS-META-LEVEL-CONJUNCTS
; null in-conjs case should be handled by all-meta-preds-in-exp
(defun take-out-meta-level-conjuncts-from-known (exp)
    (g-loop (init conjs (cdaddr exp) out-conjs nil in-conjs nil in-exp nil)
	  (while conjs)
	  (do (if (meta-level-p (car conjs))
		  (push (car conjs) out-conjs)
		(push (car conjs) in-conjs)))
	  (next conjs (cdr conjs))
	  (result (progn (cond ((null in-conjs)
				(setq in-exp t)) 
			       ((null (cdr in-conjs))
				(setq in-exp
				      (list 'known (cadr exp)
					    (car in-conjs))))
			       (t (setq in-exp
					(list 'known (cadr exp)
					      (cons 'and in-conjs)))))
			 (cons 'and (cons in-exp out-conjs))))))



	   
(defun exists-simplify (exp)
    (cond ((not (eql (car exp) 'exists)) exp)
	  ((member (get-exp exp) '(t nil))
	   (cond ((null (cdddr exp)) ; ie, is it nothing, as opposed to (nil)
		  exp)
		 ((get-exp exp) (get-gen-exp exp))))
	  ((null (get-gen-exp exp))
	   nil)
	  ((eql (get-gen-exp exp) t)
	   (get-exp exp))
	  (t exp)))






; assumes ao-simplified

(defun rm-extra-gens (exp assoc-vars)
  (cond ((eql exp t) nil)
	((eql (car exp) 'forall) exp) ; don't know what to do
	((eql (car exp) 'exists)
	 (cond ((does-overlapq (cdr (get-gen-exp exp)) assoc-vars)
		(list 'exists
		      (get-vars-lst exp) 
		      (get-gen-exp exp)
		      (or (rm-extra-gens (get-exp exp) assoc-vars)
			  t)))
	       (t (rm-extra-gens (get-exp exp) assoc-vars))))
	((member (car exp) '(and or))
	 (setq exp (cons (car exp) 
			 (g-map (sub in (cdr exp))
				(filter (rm-extra-gens sub assoc-vars)))))
	 (if (cdr exp) exp t))
	((negated-p exp)
	 (let ((sub (rm-extra-gens (cadr exp) assoc-vars)))
	   (and sub (list '~ sub))))
	((eql (car exp) 'known)
	 (let ((sub (rm-extra-gens (caddr exp) assoc-vars)))
	   (cond ((or (null sub) 
		      (eql sub t)) 
		  nil)
		 ((list 'known (cadr exp) sub)))))
	((and (atomic-formula-p exp)
	      (does-overlapq (cdr exp) assoc-vars))
	 exp)))


(defun rm-singleton-gens (exp sgens)
  (cond ((eql exp t) nil)
	((member (car exp) '(forall exists))
	 (list (car exp)
	       (get-vars-lst exp) 
	       (or (rm-singleton-gens (get-gen-exp exp) sgens) t)
	       (or (rm-singleton-gens (get-exp exp) sgens)
		   t)))
	((member (car exp) '(and or))
	 (setq exp (cons (car exp) 
			 (g-map (sub in (cdr exp))
				(filter (rm-singleton-gens sub sgens)))))
	 (if (cdr exp) exp t))
	((negated-p exp)
	 (let ((sub (rm-singleton-gens (cadr exp) sgens)))
	   (and sub (list '~ sub))))
	((eql (car exp) 'known)
	 (let ((sub (rm-singleton-gens (caddr exp) sgens)))
	   (and sub (list 'known (cadr exp) sub))))
	((and (atomic-formula-p exp)
	      (member exp sgens :test #'equal)) 
	 nil)
	(t exp)))



(defun does-overlapq (l1 l2)
  (g-loop (while l1)
	  (do (if (member (car l1) l2) (return t)))
	  (next l1 (cdr l1))))


(defun get-constrained-associates (exp vars)
  (g-loop (init new nil)
	  (while (setq new (get-associates exp vars)))
	  (do (setq vars (nconc new vars)))
	  (result vars)))

(defun get-associates (exp assocs)
    (cond ((eql exp t) nil)
	  ((member (car exp) '(forall exists))
	   (cond ((does-overlapq (cdr (get-gen-exp exp)) assocs)
		  (nconc (ldiffq (get-variables (get-gen-exp exp)) assocs)
			 (get-associates (get-exp exp) assocs)))
		 (t (get-associates (get-exp exp) assocs))))
	  ((member (car exp) '(and or))
	   (g-map (sub in (cdr exp))
		 (splice (get-associates sub assocs))))
	  ((negated-p exp)
	   (get-associates (cadr exp) assocs))
	  ((eql (car exp) 'known)
	   (get-associates (caddr exp) assocs))
	  ((does-overlapq (cdr exp) assocs)
	   (ldiffq (get-variables exp) assocs))))

; GET-VARIABLES is only used in the function above. Should be taken out...

(defun get-variables (spec)
   (setq spec (cdr spec))
   (g-loop (init ret-val nil)
	   (while spec)
	   (do (and (is-variable (car spec))
		    (push (car spec) ret-val)))
	   (next spec (cdr spec))
	   (result ret-val)))

; want the generators that ONLY generate v.

(defun find-generators-for-v (v all-vars exp)
    (cond ((eql exp t) nil)
	  ((member (car exp) '(forall exists))
	   (append (find-generators-for-v v all-vars (get-gen-exp exp))
		   (find-generators-for-v v all-vars (get-exp exp))))
	  ((eql (car exp) 'or) nil) ; only bring up conjunctive gens
	  ((eql (car exp) 'and)
	   (g-map (sub in (cdr exp))
		 (splice (find-generators-for-v v all-vars sub))))
	  ((negated-p exp)
	   (find-generators-for-v v all-vars (cadr exp)))
	  ((eql (car exp) 'known)
	   (find-generators-for-v v all-vars (caddr exp)))
	  ((equal (list v) (intersectq (cdr exp) all-vars))
	   (list exp))))


(defun find-singleton-vars (exp vars)
    (cond ((eql exp t) nil)
	  ((member (car exp) '(forall exists))
	   (nconc (find-singleton-vars (get-gen-exp exp) vars)
		  (find-singleton-vars (get-exp exp) vars)))
	  ((eql (car exp) 'or) nil) ; only bring up conjunctive gens
	  ((eql (car exp) 'and)
	   (g-map (sub in (cdr exp))
		 (splice (find-singleton-vars sub vars))))
	  ((negated-p exp)
	   (find-singleton-vars (cadr exp) vars))
	  ((eql (car exp) 'known)
	   (find-singleton-vars (caddr exp) vars))
	  (t (let ((cand-vars (intersectq (cdr exp) vars)))
		 (and (eql 1 (length cand-vars))
		      (singleton-var (car cand-vars) exp)
		      cand-vars)))))


; *SINGLETON-PREDS* = ((SHAPE 2)...) since the 2nd arg is the singleton var

(defun singleton-var (v exp)
    (and (assoc (car exp) *SINGLETON-PREDS*)
	 (eql v (nth (cadr (assoc (car exp) *SINGLETON-PREDS*)) exp))))


;  assumes lower level simplifications have been done!
; potential bug with moving up conjs ...
; dont want to move up a variable out of its scope...if
; is-equal is used to define variable within the and.

(defun forall-simplify (orig-exp)
  (cond ((not (eql (car orig-exp) 'forall)) orig-exp)
	; is-equal generators
	((eql (get-exp orig-exp) t) t)
	((and (eql (car (get-gen-exp orig-exp)) 'is-equal)
	      (is-variable (car (get-vars-lst orig-exp)))
	      (null (cdr (get-vars-lst orig-exp))))
	 (subst (cond ((eql (cadr (get-gen-exp orig-exp)) 
			    (car (get-vars-lst orig-exp))) 
		       (caddr (get-gen-exp orig-exp)))
		      (t (cadr (get-gen-exp orig-exp))))
		(car (get-vars-lst orig-exp))
		orig-exp))
	(t (let ((exp (forall-gen-process orig-exp)))
	     (cond ((and (eql (car exp) 'forall) 
			 (eql (car (get-exp exp)) 'and)
			 (always-true (get-gen-exp exp) (get-vars-lst exp))
			 (get-independent-subexp
			  (get-exp exp) (cdr (get-exp exp))
			  (get-vars-lst exp)))
		    (move-up-conj-from-forall exp))
		   ((and (eql (car exp) 'forall) 
			 (eql (car (get-exp exp)) 'or)
					; dont need always true test
			 (get-independent-subexp
			  (get-exp exp) (cdr (get-exp exp))
			  (get-vars-lst exp)))
		    (move-up-disj-from-forall exp))
		   (t exp))))))

    
; I "think" this is alright even though we don't go all the way down....

(defun has-constraining-eq (sub ind-sub vars-lst)
    (and (listp sub)
	 (eql (car sub) 'is-equal)
	 (intersectq (cdr sub) vars-lst)
	 (r-memqs (cdr sub) ind-sub)
	 t))
		    


(defun r-memqs (es l)
    (cond ((atom l) (member l es))
	  ((g-loop (while l)
		 (do (and (r-memqs es (car l))
			  (return t)))
		 (next l (cdr l))))))

; nils's must be in varslist...
; t's cannot be in varslst

(defun always-true (gen-exp vars-lst)
  (if (eql 'known (car gen-exp)) (setq gen-exp (caddr gen-exp)))
  (if (assoc (car gen-exp) *AT-LEAST-ONE-GENERATORS*)
      (g-loop (init gens *AT-LEAST-ONE-GENERATORS*)
	      (while gens)
	      (do (and (eql (caar gens) (car gen-exp))
		       (g-loop (init v1s (cdar gens) v2s (cdr gen-exp))
			       (while v1s)
			       (do (cond ((or (and (not (car v1s))
						   (not (member (car v2s) vars-lst)))
					      (and (eq t (car v1s))
						   (member (car v2s) vars-lst)))
					  (return nil))))
			       (next v1s (cdr v1s) v2s (cdr v2s))
			       (result t))
		       (return t)))
	      (next gens (cdr gens)))))



(defun get-independent-subexp (inner-exp subexps vars)
    (g-loop (while subexps)
	  (do (and (not (r-memqs vars (car subexps)))		
		   (or (eql (car inner-exp) 'or)
		       (not (test-for-constraining-eqs (car subexps)
				(cdr inner-exp) vars)))
		   (return (car subexps))))
	  (next subexps (cdr subexps))))

; this is not guaranteed to work, since there can be chains of is-eqs.
; however, I don't think this should happen if the schemas are written
; right...

;  not the check for an atomic that defines vars. Can't do the
; proper check since I don't have the path, so be conservative.

; subs = the innner exp of the forall, assume its a conjunction

(defun test-for-constraining-eqs (ind-sub subs vars-lst)
    (g-loop (init sub nil)
	  (while (setq sub (pop subs)))
	  (do (cond ((equal ind-sub sub))
		    ((and (atomic-formula-p sub) ; check for defining vars
			  (r-memqs (g-map (v in (find-all-vars sub))
					 (when (not (member v vars-lst)))
					 (save v))
			      ind-sub))
		     (return t))
		    ((has-constraining-eq sub ind-sub vars-lst)
		     (return t))))))



(defun move-up-conj-from-forall (exp)
  (if (null (eql (car (get-exp exp)) 'and)) (error "bad-exp"))
  (g-loop (init independs nil subexps (cdr (get-exp exp)) 
		new-independ nil ret-subexps nil)
	  (while subexps)
	  (do (setq new-independ (get-independent-subexp
				  (get-exp exp) subexps (get-vars-lst exp)))
	      (if new-independ
		  (progn
		    (setq subexps (cdr (member new-independ subexps)))
		    (push new-independ independs))
		(setq subexps nil)))
	  (result (if (null independs) exp
		    (progn
		      (setq ret-subexps
			    (ldiffq (cdr (get-exp exp)) independs))
		      (if (null ret-subexps)
			  (if (cdr independs)
			      (cons 'and independs)
			    (car independs))
			(cons 'and
			      (cons (list 'forall (get-vars-lst exp)
					  (get-gen-exp exp)
					  (if (cdr ret-subexps)
					      (cons 'and ret-subexps)
					    (car ret-subexps)))
				    independs))))))))

(defun move-up-disj-from-forall (exp)
  (if (null (eql (car (get-exp exp)) 'or)) (error "bad-exp"))
  (g-loop (init independs nil subexps (cdr (get-exp exp))
		new-independ nil ret-subexps nil)
	  (while subexps)
	  (do (setq new-independ (get-independent-subexp
				  (get-exp exp) subexps (get-vars-lst exp)))
	      (if new-independ 
		  (progn
		    (setq subexps (cdr (member new-independ subexps)))
		    (push new-independ independs))
		(setq subexps nil)))
	  (result (if (null independs) exp
		    (progn
		      (setq ret-subexps
			    (ldiffq (cdr (get-exp exp)) independs))
		      (if (null ret-subexps)
			  (if (cdr independs)
			      (cons 'or independs)
			    (car independs))
			(cons 'or
			      (cons (list 'forall (get-vars-lst exp)
					  (get-gen-exp exp)
					  (if (cdr ret-subexps)
					      (cons 'or ret-subexps)
					    (car ret-subexps)))
				    independs))))))))





(defun forall-gen-process (orig-exp)
    (prog (gen-exp vars exp singleton-vars singleton-gens)
	  (setq gen-exp (get-gen-exp orig-exp))
	  (setq exp (get-exp orig-exp))
	  (cond ((or (eql gen-exp t)
		     (null (get-vars-lst orig-exp)))
		 (return exp)))
	  (setq singleton-vars 
		(find-singleton-vars gen-exp (get-vars-lst orig-exp)))
	  (setq singleton-gens 
		(g-map (v in singleton-vars)
		      (splice (find-generators-for-v v 
				  (get-vars-lst orig-exp) gen-exp))))
	  (and singleton-gens
	       (setq gen-exp (rm-singleton-gens gen-exp 
				 singleton-gens)))
	  (setq vars (g-map (v in (get-vars-lst orig-exp))
			   (when (and (not (member v singleton-vars))
				      (r-memq v gen-exp)
				      (r-memq v exp)))
			   (save v)))
	  (setq gen-exp  
		(if vars
		    (rm-extra-gens
		     gen-exp (get-constrained-associates gen-exp vars))))

; post hack added by me since apparently find-generators-for-v 
; strips off 'knowns. should make it do the right thing from start.

	  (if singleton-gens 
	      (setq singleton-gens
		    (g-map (g in singleton-gens)
			   (save (if (and (atomic-formula-p g)
					  (not (meta-level-p g)))
				     (list 'known (find-the-node orig-exp) g)
				   g)))))
			; have to bring out exps from exp, move knowns out
	  (cond ((and singleton-gens gen-exp)
		 (return `(and ,@singleton-gens (forall ,vars ,gen-exp ,exp))))
		((and (null singleton-gens) (null gen-exp))
		 (return exp))
		(singleton-gens
		 (return (fancy-ao-simplify `(and ,@singleton-gens ,exp))))
		(gen-exp
		 (return `(forall ,vars ,gen-exp ,exp))))))



 
; no longer use order-eqs

(defun dn-eq-simplify (orig-exp path)
    (g-loop (init sub nil conjs-left (cdr orig-exp) conjs-done nil)
	  (while (setq sub (pop conjs-left)))
	  (do (cond ((atom sub)
		     (and (null sub) (return nil)))
		    ((not (eql (car sub) 'is-equal))
		     (push sub conjs-done))
		    ((and (is-variable (cadr sub))
			  (not (defined-outside
				   orig-exp (cadr sub) path)))
		     (setq conjs-left (subst (caddr sub) (cadr sub) conjs-left))
		     (setq conjs-done (subst (caddr sub) (cadr sub) conjs-done)))
		    ((and (is-variable (caddr sub))
			  (not (defined-outside
				   orig-exp (caddr sub) path)))
		     (setq conjs-left (subst (cadr sub)(caddr sub) conjs-left))
		     (setq conjs-done (subst (cadr sub)(caddr sub) conjs-done)))
		    ((is-variable (cadr sub))
		     (setq conjs-left (subst (caddr sub) (cadr sub) conjs-left))
		     (setq conjs-done (subst (caddr sub) (cadr sub) conjs-done))
		     (push sub conjs-done))		     
		    ((is-variable (caddr sub))
		     (setq conjs-left (subst (cadr sub)(caddr sub) conjs-left))
		     (setq conjs-done (subst (cadr sub)(caddr sub) conjs-done))
		     (push sub conjs-done))
		    ((equal (cadr sub) (caddr sub)))
		    ((push sub conjs-done))))
	  (result (cond ((null conjs-done) t)
			((null (cdr conjs-done))
			 (car conjs-done))
			((cons 'and (nreverse conjs-done)))))))

; assume exp is a disjunction 

(defun or-dn-eq-simplify (orig-exp path)
    (g-loop (init eqs nil disjs (cdr orig-exp))
	  (while disjs)
	  (do (and (eql (caar disjs) 'is-equal)
		   (setq eqs (cdar disjs))
		   (cond ((and (is-variable (car eqs))
			       (not (defined-outside
					orig-exp (car eqs) path)))
			  (return t))
			 ((and (is-variable (cadr eqs))
			       (not (defined-outside
					orig-exp (cadr eqs) path)))
			  (return t)))))
	  (next disjs (cdr disjs))
	  (result orig-exp)))


(defun mentioned-outside-exp (v exp path)
    (g-loop (init big-exp nil found nil)
	  (while (setq big-exp (pop path)))
	  (do (g-loop (while big-exp)
		    (do (cond ((r-memq exp (car big-exp)))
			      ((r-memq v (car big-exp))
			       (setq found t))))
		    (until found)
		    (next big-exp (cdr big-exp))))
	  (until found)
	  (result found)))


(defun defined-by-atomic (v exp)
    (and (atomic-formula-p exp)
	 (cond ((eql (car exp) 'known)
		(cond ((eql (caddr exp) t) nil)
		      ((eql (car (caddr exp)) 'and)
		       (and (g-map (sub in (cdr (caddr exp)))
				  (filter (defined-by-atomic v sub)))
			    t))
		      ((atomic-formula-p (caddr exp))
		       (member v (caddr exp)))))
	       ((r-memq v exp))))) ; takes care of other meta-fns.
	   

;  returns t if v is defined outside exp
;  v is not counted as defined outside in:
;		     (and (or (  v)....)
;		          exp)
	    
(defun defined-outside (exp v path)
    (cond ((null path) nil)
	; hack for top-level check
	  ((and (null (cdr path))
		(eql (caar path) 'or)
		(eql (car (cadar path)) 'not))
	   (r-memq v (cadar path)))
	  ((and (eql (caar path) 'forall)
	        (member v (get-vars-lst (car path))))
	   t)
	  ((g-loop (init big-exp (car path))
		 (before-starting (or (eql (car big-exp) 'and)
				      (return nil)))
		 (next big-exp (cdr big-exp))		 
		 (while big-exp)
		 (do (and (defined-by-atomic v (car big-exp))
			  (return t)))))
	  ((defined-outside exp v (cdr path)))))



; 
(defun dn-forall-simplify (exp path)
    (let ((outside-defined-vars (g-map (v in (get-vars-lst exp))
				      (when (defined-outside exp v path))
				      (save v))))
	 (cond (outside-defined-vars
		   (forall-simplify 
		       (list 'forall
			     (del-memq-list outside-defined-vars 
				 (get-vars-lst exp))
			     (get-gen-exp exp)
			     (get-exp exp))))
	       (exp))))

(defun dn-exists-simplify (exp path)
    (cond ((negated-p (car path)) exp)
	  (t (list 'and (get-gen-exp exp) ; turn into and
		   (get-exp exp)))))


(defun dn-atomic-simplify (exp path)
    (cond ((eql (car exp) 'has-bound-vars)
	   (has-bound-vars-simplify exp path))
	  ((and (not (eql (car exp) 'known))
		(neg-implied-by-goal exp path))
	   nil)
	  ((assoc (car exp) *SINGLETON-PREDS*)
	   (dn-singleton-simplify exp path))
	  ((dn-redundancy-elimination exp path)
	   t)
	  ((dn-is-counter exp path)
	   nil)
	  (exp)))

; should change this so preds can have more than one
; singleton argument. The idea is that if the two
; formulas match in every argument but a singleton arg,
; then the singleton args must also be equal. EG.
; ON has more than one singleton arg.

(defun singleton-matches (s orig-cand)
    (g-loop (init splace (cadr (assoc (car s) *SINGLETON-PREDS*))
		current-place 0 cand orig-cand)
	  (next current-place (+ 1 current-place)
		s (cdr s) cand (cdr cand))
	  (while s)
	  (do (cond ((eql current-place splace))
		    ((equal (car s) (car cand)))
		    (t (return nil))))
	  (result orig-cand)))

;  Bug popped up in dn-singleton-simplify
;  when two singletons were in the same conjunction:
;  they both got taken out. So dont return singletons
;  that occur later than youself in same conjunction; 
;  ie. when you find yourself, quit.

(defun outside-singleton-mentions (singleton path)
    (cond ((null path) nil)
	  ((eql (caar path) 'and)
	   (g-loop (init super (car path) sub-exp nil ret-val nil
		       found-myself nil)
		 (while (setq sub-exp (pop super)))
		 (do (cond ((atom sub-exp))
			   ((eql sub-exp singleton) ; self
			    (setq found-myself t))
			   ((and (eql (car sub-exp)(car singleton))
				 (singleton-matches singleton sub-exp))
			    (push sub-exp ret-val))
			   ((eql 'known (car sub-exp))
			    (cond ((eql (caddr sub-exp) singleton)
				   (setq found-myself t))
				  ((and (eql (car (caddr sub-exp)) 
					    (car singleton))
					(singleton-matches singleton
					    (caddr sub-exp)))
				   (push (caddr sub-exp) ret-val))))))
		 (until found-myself)
		 (result (nconc ret-val (outside-singleton-mentions
					    singleton (cdr path))))))
	  ((outside-singleton-mentions singleton (cdr path)))))
		 
; takes singletons from outside and substitutes is-equals.

(defun dn-singleton-simplify (singleton path)    
    (let ((outside-singletons 
	      (outside-singleton-mentions singleton path)))
	 (cond ((null outside-singletons) singleton)
	       ((null (cdr outside-singletons))
		(get-eqs (car outside-singletons) singleton))
	       ((cons 'and
		      (g-map (s in outside-singletons)
			    (save (get-eqs s singleton))))))))

; cdr path when called redundency stuff since we get self conflicts
; for this reason, also get rid of upper known in 4th clause

(defun dn-is-counter (lit path)
    (cond ((and (eql (car lit) 'known)
		(or (negated-p (caddr lit))
		    (closed-predicate (caddr lit))
		    (function-p (caddr lit))))
	   (dn-redundancy-elimination 
	       (list 'known (cadr lit) (negate (caddr lit)))
	       (cdr path)))
	  ((eql (car lit) 'is-equal)
	   (dn-redundancy-elimination 
	       (cons 'not-equal (cdr lit)) (cdr path)))
	  ((eql (car lit) 'not-equal)
	   (dn-redundancy-elimination (cons 'is-equal (cdr lit)) (cdr path)))
	  ((eql 'known (caar path))
	   (dn-redundancy-elimination (negate lit) (cddr path)))
	  ((dn-redundancy-elimination (negate lit) (cdr path)))))


		      



; runs through the path and finds out if a lit is 
; already present in an AND higher up, or negated higher up
; in an OR. OR stuff works fine. Was worried that
; simplifying (OR A (AND (not A) B)) would prevent
; full simplfication if not A drops out, but not so.
;  (if B drops out after (not A), whole thing goes to TRUE.

; note: commented out stuff the remove the lit himself from
; the last entry in the path. Instead, we to an eq test
; in is-redundant-lit, which should work...

; NOTE, CHANGES SHOULD ALSO BE DONE in PL-TP.

(defun dn-redundancy-elimination (lit path)
     (g-loop (init level nil orig-path path)
	  (while (setq level (pop path)))
	  (do (and (is-redundant-lit lit level orig-path)
		   (return t)))))



(defun is-redundant-lit (lit level orig-path)
    (cond ((eql (car level) 'and)
	   (and (member lit level :test #'equal)
		; these do "not same guy" test
		(or (not (eql level (car orig-path)))
		    (not (eql lit (car (member lit level :test #'equal)))))))
	  ((eql (car level) 'forall)
	   (cond ((atomic-formula-p (get-gen-exp level))
		  (and (equal lit (get-gen-exp level))
		       (not (eql lit
				 (get-gen-exp level))))) ; equals but not eq
		 ((is-redundant-lit lit (get-gen-exp level) orig-path))))
	  ((eql (car level) 'or)
	   (cond ((eql (car lit) 'known)
		  (cond ((and (negated-p (caddr lit))
			      (or (closed-predicate (cadr (caddr lit)))
				  (function-p (cadr (caddr lit)))))
			 (check-if-known (cadr (caddr lit)) level))
			((or (closed-predicate (caddr lit))
			     (function-p  (caddr lit)))
			 (check-if-known (negate (caddr lit)) level))
			((member (negate lit) level :test #'equal))))
		 ((eql (car lit) 'not-equal)
		  (and (member-subexp 'is-equal level)
		       (or (member (cons 'is-equal (cdr lit)) level
				   :test #'equal)
			   (member (list 'is-equal (caddr lit) (cadr lit))
				   level :test #'equal))))
		 (t (member (negate lit) level
			    :test #'equal))))))

; assume lit is an atomic formula that is not a meta-fn

(defun check-if-known (lit exp)
    (g-loop (init sub nil)
	  (while (setq sub (pop exp)))
	  (do (and (listp sub)
		   (eql 'known (car sub))
		   (equal lit (caddr sub))
		   (return t)))))



	   
; returns all references to vars -- 

(defun r-gather-eles (es bvar-exp l ret-val)
    (cond ((atom l) 
	   (cond ((null l) ret-val)
		 ((and (member l es) 
		       (not (member l ret-val)))
		  (cons l ret-val))
		 (ret-val)))
	  ((eql bvar-exp l) ret-val)
	  ((g-loop (while l)
		 (do (setq ret-val
			   (r-gather-eles es bvar-exp (car l) ret-val)))
		 (next l (cdr l))
		 (result ret-val)))))



; get rid of all bvars that are not mentioned by exp. Assumes that
; we have done an up-simplify first.
; (has-bound-vars ...)

(defun has-bound-vars-simplify (exp path)
    (g-loop (init bvars (elt exp 4) new-bvars nil
		used-bvars (r-gather-eles bvars exp
			      (car (last path)) nil)
		tmp-bvars bvars found nil b nil)
	  (while tmp-bvars) 
	  (do (setq b (pop tmp-bvars))
	      (cond ((null b) (push b new-bvars))
		    ((member b used-bvars)
		     (setq found t)
		     (push b new-bvars))
		    (t (push nil new-bvars))))
	  (before-returning (setq new-bvars 
				  (nreverse new-bvars)))
	  (result (cond ((not found) t)
			((equal new-bvars bvars)
			 exp)
			(t (subst new-bvars bvars exp))))))
	       
				   



; replaces above

(defun neg-implied-by-goal (exp path)
    (cond ((and (eql 'and (caar path))
		(find-subexp 'on-goal-stack (car path))
		(equal exp (caddr (find-subexp 'on-goal-stack (car path)))))
	   t)
	  ((cddr path) 
	   (neg-implied-by-goal exp (cdr path)))
	  ((and (null (cddr path))
		(eql 'or (caar (cdr path)))
		(eql 'and (caar path)))
	   (or (equal exp (caddr (or (find-subexp 'current-goal (car path))
				     (find-subexp 'primary-candidate-goal (car path)))))
	       (let ((goal-tc-var (caddr (cadr (cadr (cadr path))))))
		    (g-loop (init subs (cdar path))
			  (while subs)
			  (do (and (listp (car subs))
				   (eql 'is-equal (caar subs))
				   (eql goal-tc-var (cadar subs))
				   (equal exp
					  (caddar subs))
				   (return t)))
			  (next subs (cdr subs))))))))
			   
			    



	   


; -----------------

; Ao simplify
; forall simplify
; eq-simplify
; simplify-lits --> put in level-simplify
; re-simplify ao-s
; re-simplify foralls?

(defun simplify (exp)
    (setq *GOOD-UP-LEVEL-EXPS* nil)
    (setq *GOOD-DN-LEVEL-EXPS* nil)
    (g-loop
          (init old-exp (r-up-simplify exp) new-exp nil)
;	  (before-starting (progn (format t "~%after up:~%") (pprint old-exp)))
	  (do 
	      (setq new-exp (r-dn-simplify old-exp nil))
;	      (format t "~%after dn:~%")
;	      (pprint new-exp)
	      (cond ((equal new-exp old-exp) ;  no change
		     (return new-exp))
		    (t (setq old-exp new-exp)
		       (setq new-exp (r-up-simplify old-exp))
;		       (format t "~%after up:~%")
;		       (pprint new-exp)
		       (cond ((equal new-exp old-exp)
			      (return new-exp))
			     ((setq old-exp new-exp))))))))
    

    
; similar to simplify, but now we're simplifying an
; expression that is within a larger exp.

(defun inner-simplify (exp path)
    (setq *GOOD-UP-LEVEL-EXPS* nil)
    (setq *GOOD-DN-LEVEL-EXPS* nil)
    (g-loop (init old-exp (r-up-simplify exp) new-exp nil)
;	  (before-starting (progn (format t "~%after up:~%") (pp old-exp)))
	  (do (setq new-exp (r-dn-simplify old-exp path))
;	      (format t "~%after dn:~%")
;     	      (pp new-exp)
   	      (cond ((equal new-exp old-exp) ;  no change
		     (return new-exp))
		    (t (setq old-exp new-exp)
		       (setq new-exp (r-up-simplify old-exp))
;		      (format t "~%after up:~%")
;	       	      (pp new-exp)
		       (cond ((equal new-exp old-exp)
			      (return new-exp))
			     ((setq old-exp new-exp))))))))

; only used when making new control rules...

(defun outer-simplify (exp)
    (prog (goal-form)
	  (cond ((eql (car exp) 'and) 
		 (setq exp (fancy-ao-simplify exp))		
		 (setq exp (dn-eq-simplify exp nil))))
	  (g-loop (init tmp-exp (cdr exp) ret-val (list (car exp)))
		(while tmp-exp)
		(do (cond ((and (eql 'is-equal (caar tmp-exp))
				(equal (cadar tmp-exp)
				       (caddar tmp-exp))))
			  ((push (car tmp-exp) ret-val))))
		(next tmp-exp (cdr tmp-exp))
		(result (setq exp (nreverse ret-val))))
	  (setq goal-form (or (find-subexp 'current-goal exp)
			      (find-subexp 'primary-candidate-goal exp)))
	  (cond ((and goal-form (recur-member (negate (caddr goal-form)) exp))
		 (setq exp (simplify exp))))
	  (return exp)))




	  
(defun r-up-simplify (exp)
    (cond ((null exp) nil)
	  ((atom exp) exp)
	  ((member exp *GOOD-UP-LEVEL-EXPS*) exp)
	  ((eql (car exp) 'known)
	   (up-simplify-level 
	       (list 'known (cadr exp) 
		     (r-up-simplify (caddr exp)))))
	  ((atomic-formula-p exp) 
	   (up-simplify-level exp))
	  ((member (car exp) '(and or))
	   (up-simplify-level (cons (car exp) 
				    (g-map (sub-exp in (cdr exp))
					  (save (r-up-simplify sub-exp))))))
	  ((member (car exp) '(forall exists))
	   (up-simplify-level (list (car exp) (get-vars-lst exp)
				    (r-up-simplify (get-gen-exp exp))
				    (cond ((eql (length exp) 3) t)
					  ((r-up-simplify (get-exp exp)))))))
	  
	  ((negated-p exp) 	; dont put negated short-exists through
	   ; exists-simplify...
	   (let ((sub (cadr exp)))
		(cond ((eql 'exists (car sub))
		       (up-simplify-level
			   (list '~
				 (cond ((eql (length sub) 3)
					(list (car sub) (get-vars-lst sub)
					      (r-up-simplify (get-gen-exp sub))
					      (r-up-simplify (get-exp sub)))
					(list (car sub) (get-vars-lst sub)
					      (r-up-simplify (get-gen-exp
								 sub))))))))
		      (t (up-simplify-level 
			     (list '~ (r-up-simplify (cadr exp))))))))
	  (t (error "bad-exp"))))



(defun up-simplify-level (exp)
  (let ((level-result 
	 (cond ((atom exp) exp)
	       ((member (car exp) '(and or))
		(fancy-ao-simplify exp))
	       ((eql (car exp) 'known)
		(known-simplify exp))
	       ((atomic-formula-p exp)
		(atomic-simplify exp))
	       ((negated-p exp) 
		(negated-simplify exp))
	       ((eql (car exp) 'forall) 
		(forall-simplify exp))
	       ((eql (car exp) 'exists) 
		(exists-simplify exp)))))
    (if (null (atom level-result))
	(push level-result *GOOD-UP-LEVEL-EXPS*))
    level-result))

; first guy on the path should always be your parent...

; if I ever move good level stuff in, rewrite same as r-up-simplify

(defun r-dn-simplify (exp path)
  (if (atom exp)
      exp
    (let ((new-exp (dn-simplify-level exp path)))
      (cond ((atom new-exp) new-exp)
	    ((and (atomic-formula-p new-exp) 
		  (not (eql (car new-exp) 'known)))
	     new-exp)
	    ((negated-p new-exp) new-exp)
	    (t (setq path (cons new-exp path))
	       (cond ((eql (car new-exp) 'known)
		      (list 'known (cadr new-exp) 
			    (r-dn-simplify (caddr new-exp) path)))
		     ((member (car new-exp) '(and or))
		      (cons (car new-exp) 
			    (g-map (sub in (cdr new-exp))
				   (save (r-dn-simplify sub path)))))
		     ((member (car new-exp) '(forall exists))
		      (list (car new-exp) (get-vars-lst new-exp)
			    (r-dn-simplify (get-gen-exp new-exp) path)
			    (r-dn-simplify (get-exp new-exp) path )))
		     ((error "bad-exp"))))))))


; I'm more conservative with good-dn-level-level-exps
; cause we don't know if the path has changed.
; so mainly I try to avoid expensive work on and/ors


(defun dn-simplify-level (exp path)
  (cond ((eql exp t) t)
	((member (car exp) '(or and))
	 (if (member exp *GOOD-DN-LEVEL-EXPS*)
	     exp
	   (let ((level-result (dn-ao-simplify exp path)))
	     (push level-result *GOOD-DN-LEVEL-EXPS*)
	     level-result)))
; separate out knowns from atomics ?
	((atomic-formula-p exp)
	 (dn-atomic-simplify exp path))
	((negated-p exp)
	 (dn-negated-simplify exp path))
	((eql (car exp) 'forall) 
	 (dn-forall-simplify exp path))
	((eql (car exp) 'exists)
	 (dn-exists-simplify exp path))
	(t exp)))


(defun dn-ao-simplify (exp path)
  (if (eql (car exp) 'or)
      (setq exp (rm-disj-semi-dups (cdr exp) path)))
  (cond ((eql (car exp) 'and)
	 (if (assoc 'is-equal (cdr exp))
	     (setq exp (dn-eq-simplify exp path)))
	 (if (and-raisable exp)
	     (dn-and-raise exp path)
	   exp))
	((eql (car exp) 'or)
	 (if (assoc 'is-equal (cdr exp))
	     (setq exp (or-dn-eq-simplify exp path)))
	; efficiency-hack, do this first
	 (if (listp exp)
	      (setq exp
		    (g-map (sub in exp)
			   (save (cond ((atom sub) sub)
				       ((and (eql (car sub) 'and)
					     (assoc 'is-equal (cdr sub)))
					(remove-obvious-eqs 
					 (dn-eq-simplify sub (cons exp path))))
				       (t sub))))))
	 (if (or-raisable exp)
	     (dn-or-raise exp path)
	   exp))
	(t (error "bad-exp"))))

; have to use equal cause path gets munged some on way down.

(defun only-mentioned-in-exp (v exp big-exp)
  (cond ((equal exp big-exp) t)
	((atom big-exp) 
	 (not (eql v big-exp)))
	((g-loop (while big-exp)
		 (do (if (null (only-mentioned-in-exp v exp (pop big-exp)))
			 (return nil)))
		 (result t)))))




(defun rm-disj-semi-dups (exps path)
  (g-loop (init exp nil dups nil orig-exps exps)
	  (while (setq exp (pop exps)))
	  (do (and (or (atomic-formula-p exp)
		       (eql 'forall (car exp)))
		   (is-disj-semi-dup exp exps path)
		   (push exp dups)))
	  (result (cons 'or (del-memq-list dups orig-exps)))))

(defun is-disj-semi-dup (exp exps path)
  (g-loop (while exps)
	  (do (if (test-disj-semi-dup exp (pop exps) path)
		  (return t)))))

(defun test-disj-semi-dup (e1 e2 path)
  (let ((bs (r-test-disj-semi-dup e1 e2 nil)))
    (if (not (eql bs 'no))
	(g-loop (init big-exp (car (last path)))
		(while bs)
		(do (if (not
			 (and (only-mentioned-in-exp (caar bs) e1 big-exp)
			      (only-mentioned-in-exp (cadar bs) e2 big-exp)))
			(return nil)))
		(next bs (cdr bs))
		(result t)))))




(defun r-test-disj-semi-dup (e1 e2 bs)
  (cond ((atom e1) 
	 (cond ((not (atom e2)) 'no)
	       ((eql e1 e2) bs)
	       ((and (is-variable e1)
		     (is-variable e2))
		(cons (list e1 e2) bs))
	       (t 'no)))
	((atom e2) 'no)
	((g-loop (while e1)
		 (do (setq bs (r-test-disj-semi-dup (car e1) (car e2) bs))
		     (if (eql bs 'no) (return 'no)))
		 (next e1 (cdr e1) e2 (cdr e2))
		 (result bs)))))






(defun remove-obvious-eqs (and-exp)
  (cond ((atom and-exp) and-exp)
	((not (eql (car and-exp) 'and)) and-exp)
	((g-loop (init ret-val (list (pop and-exp)) sub nil)
		 (while (setq sub (pop and-exp)))
		 (do (cond ((atom sub) (push sub ret-val))
			   ((and (eql (car sub) 'is-equal)
				 (equal (cadr sub) (caddr sub))))
			   (t (push sub ret-val))))
		 (result (cond ((cddr ret-val)  (nreverse ret-val)) ; (..a and)
			       ((cdr ret-val) (car ret-val))
			       (t t)))))))

			
