#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *EVALUABLE-DOMAIN-FNS* *EVALUABLE-META-FNS*
		    *META-PREDICATES* *META-FUNCTIONS*))

(eval-when (compile) 
	   (load-path *PLANNER-PATH* "g-loop")
	   (load-path *PLANNER-PATH* "g-map")
	   (load-path *PLANNER-PATH* "data-types")
	   (load-path *EBL-PATH*     "ebl-data-types"))


;  dvars stands for defined vars. 

; decision -- we'll assume that you can't count on dvars from subexps if
; they're not atomic (or knowns !)
; so, in:  (and (or (equal x 4)
;		    (equal x 5))
;		(p x))
;   cant count on x being defined when you hit (p x). This isn't exactly
;   how the matcher works, cause it will be defined, but if we count
;   on it being defined, we'll have to distinguish between this and:
;	   (and (or (equal y 4)
;		    (equal x 5))
;		(p x))

;  top-level-fn

(defun reorder-exp-for-match (exp dvars)
  (cond ((eq exp t) t)
	((null dvars)
	 (exp-reorder exp (list 'fake-dvar)))
	(t (exp-reorder exp dvars))))

(defun exp-reorderable (exp)
  (cond ((eq (car exp) 'and) t)
	((eq (car exp) 'or)
	 (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (cond ((exp-reorderable (car exp))
			    (return t))))))
	((eq (car exp) 'forall) ;  dont bother with gen-exp
	 (exp-reorderable (get-exp exp)))
	((eq (car exp) 'exists)
	 (or (exp-reorderable (get-gen-exp exp))
	     (exp-reorderable (get-exp exp))))
	((eq (car exp) 'known)
	 (exp-reorderable (caddr exp)))
	(t nil)))



(defun exp-reorder (exp dvars)
  (cond ((atomic-formula-p exp)
	 (if (eq (car exp) 'known)
	     (list 'known (cadr exp) (exp-reorder (caddr exp) dvars))
	   exp))
	((eq (car exp) 'and)
	 (and-reorder (cdr exp) dvars))
	((and (eq (car exp) 'or)
	      (exp-reorderable exp))
	 (cons 'or (g-map (sub in (cdr exp))
			  (save (exp-reorder sub dvars)))))
	((and (eq (car exp) 'forall)
	      (exp-reorderable (get-exp exp)))
	 (list 'forall (get-vars-lst exp)
	       (get-gen-exp exp) ; don't bother, should come from preconds?
	       (exp-reorder (get-exp exp) (append (get-vars-lst exp) 
						  dvars))))
	((and (eq (car exp) 'exists)
	      (exp-reorderable exp))
	 (list 'exists (get-vars-lst exp)
	       (exp-reorder (get-gen-exp exp) dvars)
	       (exp-reorder (get-exp exp) (append (get-vars-lst exp) 
						  dvars))))
	((and (negated-p exp)
	      (exp-reorderable (cadr exp)))
	 (list '~ (exp-reorder (cadr exp) dvars)))
	(t exp)))

	  
	   
(defun and-reorder (exps dvars)
  (g-loop (init ret-val nil next-sub-and-dvars nil)
	  (while exps)
	  (do (setq next-sub-and-dvars (find-ready-subexp exps dvars))
	      (setq exps (del-eq (car next-sub-and-dvars) exps))
	      (push (exp-reorder (car next-sub-and-dvars) dvars) ret-val)
	      (setq dvars (cadr next-sub-and-dvars)))
	  (result (cons 'and (nreverse ret-val)))))
    

; mightwant to have a new set of ready-meta-predicates, such as
; current-goal, adjunct goal, etc, that we can move up....

(defun find-ready-subexp (orig-exps dvars)
  (or	; first get atomic guys that do not expand 
   (g-loop (init sub nil exps orig-exps new-dvars nil)
	   (while (setq sub (pop exps)))
	   (do (cond ((and (is-atomic-known sub)
			   (setq new-dvars
				 (no-expansion-atomic sub dvars)))
		      (return (list sub new-dvars)))
		     ((and (not (eq (car sub) 'known))
			   (atomic-formula-p sub)
			   (setq new-dvars 
				 (no-expansion-atomic sub dvars)))
		      (return (list sub new-dvars))))))
    ;next get ready atomic-forms
   (g-loop (init sub nil exps orig-exps new-dvars nil)  
	   (while (setq sub (pop exps)))
	   (do (cond ((eq (car sub) 'known)
		      (and (is-atomic-known sub)
			   (setq new-dvars
				 (atomic-get-dvars sub dvars))
			   (return (list sub new-dvars))))
		     ((atomic-formula-p sub)
		      (and (setq new-dvars
				 (atomic-get-dvars sub dvars))
			   (return (list sub new-dvars)))))))
					;get defined knowns
   (g-loop (init sub nil exps orig-exps new-dvars nil)  
	   (while (setq sub (pop exps)))
	   (do (cond ((and (eq (car sub) 'known)
			   (setq new-dvars
				 (exp-get-dvars (caddr sub) dvars)))
		      (return (list sub new-dvars))))))
		;  might want to do more, like move foralls to back, etc.
   (list (car orig-exps) dvars)))




; assume exp is atomic or an atomic known.
; returns dvars if exp does not expand match factor
; more than one.

(defun no-expansion-atomic (exp dvars)
  (cond ((eq (car exp) 'known)
	 (no-expansion-atomic (caddr exp) dvars))
	((eq (car exp) 'is-equal)
	 (cond ((contains-no-new-dvars (cadr exp) dvars) 
		(unionq (find-all-vars (caddr exp)) dvars))
	       ((contains-no-new-dvars (caddr exp) dvars)
		(unionq (find-all-vars (cadr exp)) dvars))))
	((member (car exp) '(primary-candidate-goal current-goal))
	 (and (member (cadr exp) dvars)
	      (unionq (find-all-vars (caddr exp)) dvars)))
	((assoc (car exp) *SINGLETON-PREDS*) ; assume all domain preds
	 (g-loop (init tmp-exp (cdr exp) var nil singleton-var nil)
		 (while (setq var (pop tmp-exp)))
		 (do (cond ((not (is-variable var)))
			   ((member var dvars))
			   ((and (not singleton-var)
				 (singleton-var var exp))
			    (setq singleton-var var)) ; so dont try again
			   ((return))))
		 (result (cons singleton-var dvars))))
	((contains-no-new-dvars exp dvars)
	 dvars)))


(defun contains-no-new-dvars (exp dvars)
  (cond ((atom exp)
	 (or (not (is-variable exp))
	     (member exp dvars)))
	((g-loop (while exp)
		 (do (if (not (contains-no-new-dvars (car exp) dvars))
			 (return)))
		 (next exp (cdr exp))
		 (result t)))))





; returns nil or dvars, so dvars better be non-nil

(defun exp-get-dvars (exp dvars)
  (cond ((eq (car exp) 'and)
	 (and-get-dvars (cdr exp) dvars))
	((atomic-formula-p exp) 
	 (atomic-get-dvars exp dvars))
	  ;  none ofthe rest add dvars
	((eq (car exp) 'or) 	
	 (or-get-dvars (cdr exp) dvars))
	((member (car exp) '(exists forall))
	 (let ((gen-dvars (exp-get-dvars (get-gen-exp exp) dvars)))
	   (and gen-dvars 	; got to be careful, d-vars gets nconced!
		(cond ((null (get-exp exp)) t)
		      (t (exp-get-dvars (get-exp exp) gen-dvars)))
		dvars)))
	((negated-p exp)
	 (cond ((all-vars-defined exp dvars) dvars)
	       (t nil)))
	(t (error "EXP-GET-DVARS: unknown exp type"))))


(defun and-get-dvars (exps dvars)	 
  (g-loop (init sub-dvars nil)
	  (while exps)
	  (do (setq sub-dvars (exp-get-dvars (pop exps) dvars))
	      (cond ((null sub-dvars)(return))
		    (t (setq dvars sub-dvars))))
	  (result dvars)))


(defun or-get-dvars (exps dvars)	 
  (g-loop (while exps)
	  (do (or (exp-get-dvars (pop exps) dvars)
		  (return)))
	  (result dvars)))

; should do knowns, etc

(defun atomic-get-dvars (lit vars)
  (cond ((is-atomic-known lit)
	 (atomic-get-dvars (caddr lit) vars))
	((member (car lit) *META-FUNCTIONS*)
	 (unionq (find-all-vars (cdr lit)) vars))
	((member (car lit) *META-FUNCTIONS*)
	   ; should collapse *EVALUABLE-META-FNS* with *EVALUABLE-SIGS*
	 (cond ((member (car lit) '(known provable achievable)) ; hmm
		(exp-get-dvars (caddr lit) vars))
	       ((ev-check lit vars *EVALUABLE-META-FNS*)
		(unionq (find-all-vars (cdr lit)) vars))))
	((function-p lit)
	 (and (ev-check lit vars *EVALUABLE-DOMAIN-FNS*)
	      (unionq (cdr lit) vars)))
	  ; must be a domain pred
	((unionq (cdr lit) vars))))


(defun is-atomic-known (exp)
  (if (eq (car exp) 'known)
      (atomic-formula-p (caddr exp))))


;  basically, same as evaluable check in dec2.l

(defun ev-check (exp dvars ev-lst)
  (let ((sig (assoc (car exp) ev-lst)))
    (if sig
	(or (g-loop (init sig-flags (cdr sig)
			  exp-vars (cdr exp))
		    (while sig-flags)
		    (do (or (null (car sig-flags))
			    (and (is-variable (car exp-vars))
				 (member (car exp-vars) dvars))
			    (and (listp (car exp-vars))
				 (all-vars-defined (car exp-vars) dvars))
			    (not (is-variable (car exp-vars)))
			    (return)))
		    (next sig-flags (cdr sig-flags)
			  exp-vars (cdr exp-vars))
		    (result t))
	    (ev-check exp dvars (cdr (member sig ev-lst)))))))


(defun all-vars-defined (l dvars)
  (g-loop (init vars (find-all-vars l))
	  (while vars)
          (do (or (member (car vars) dvars)
		  (return)))
	  (next vars (cdr vars))
	  (result t)))
