#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(eval-when (compile) 
	   (load-path *PLANNER-PATH* "g-loop")
	   (load-path *PLANNER-PATH* "g-map")
	   (load-path *PLANNER-PATH* "data-types")
	   (load-path *EBL-PATH*     "ebl-data-types"))

(proclaim '(special *STOP-ON-WARNING*))


(defun show-me (atm)
  (cond ((typep atm 'node)
         (print-node-struct atm)
         (pprint (nconv (symbol-plist (node-name atm)))))
	(t (pprint (nconv (symbol-plist atm))))))

; used for printing mixed node and list structures, see SHOW-ME above

(defun nconv (l)
  (cond ((null l) nil)
	((typep l 'node) (node-name l))
	((typep l 'state) (state-name l))
	((listp l)(cons (nconv (car l))(nconv (cdr l))))
	(t l)))

(defun warning-stop ()
  (format t "~%WARNING: EBL potential bug detected")
  (cond ((null *STOP-ON-WARNING*)
	 (format t "~%Value of *STOP-ON-WARNING* is null")
	 (format t "~%Discarding result, continuing..."))
	(t (format t "~%Value of *STOP-ON-WARNING* is non-null ~%")
           (cond ((y-or-n-p "Continue with run?")
	          (format t "Discarding result, continuing..."))
		 (t (break))))))

; changed during cl conversion to generate a 0-based index for use
; with ELT.

(defun which-elem (e l)
  (g-loop (init where 0)
	  (while l)
	  (until (equal e (car l)))
	  (next where (+ 1 where)
		l (cdr l))
	  (result (cond ((null l) (error "WHICH-ELEM: cant find"))
			(where)))))

(defun member-subexp (atm exp)
    (member-if #'(lambda (x) (and (listp x) (eq atm (car x))))
	exp))

(defun find-subexp (atm exp)
    (find-if #'(lambda (x) (and (listp x) (eq atm (car x))))
	exp))
    

; assumes e is eq to some formula in l

(defun get-path (e l) ;  e must be an expression, but not t
  (r-get-path e l nil))

(defun r-get-path (e l up-path)
  (cond ((eq e l) up-path)
	((atom l) nil)
	((eq (car l) 'known)
	 (r-get-path e (caddr l) (cons l up-path)))
	((atomic-formula-p l) nil) ; change if e can be atom
	(t (g-loop (init new-path (cons l up-path) sub-result nil)
		   (while l)
		   (do (setq sub-result (r-get-path e (car l) new-path)))
		   (until sub-result)
		   (next l (cdr l))
		   (result sub-result)))))

; gets single atomic formulas with pred-type
; used when you know there will be only one 

(defun get-form-from-exp (pred-nm exp)
  (let ((forms (get-forms-from-exp pred-nm exp)))
    (cond ((eq (length forms) 1) (car forms))
	  (t (error "GET-FORM-FROM-EXP:")))))



; gets all atomic formulas with pred-type
(defun get-forms-from-exp (pred-nm exp)
  (cond ((eq t exp) nil)
	((null exp) nil)
	((atomic-formula-p exp)
	 (cond ((eq pred-nm (car exp)) (list exp))
	       ((member (car exp) '(known achievable provable))
		(get-forms-from-exp pred-nm (caddr exp)))
	       (t nil)))
	((member (car exp) '(forall exists))
	 (nconc (get-forms-from-exp pred-nm (get-gen-exp exp))
		(get-forms-from-exp pred-nm (get-exp exp))))
	((negated-p exp)
	 (get-forms-from-exp pred-nm (cadr exp)))
	((member (car exp) '(and or))
	 (g-map (sub in (cdr exp))
		(splice (get-forms-from-exp pred-nm sub))))))


(defun ldiffq (l1 l2)
  (if (null l2)
      l1
    (rec-ldiffq l1 l2)))

(defun rec-ldiffq (l1 l2)
  (cond ((null l1) nil)
	((member (car l1) l2) (rec-ldiffq (cdr l1) l2))
	(t (cons (car l1) (rec-ldiffq (cdr l1) l2)))))	  

(defun unionq (l1 l2)
  (cond ((null l1) l2)
	((member (car l1) l2) 
	 (unionq (cdr l1) l2))
	(t (cons (car l1) (unionq (cdr l1) l2)))))

; possible problems if duplicates

(defun same-membersq (l1 l2)
  (if (eq (length l1)(length l2))
      (g-loop (while l1)
	      (do (cond ((not (member (car l1) l2))
			 (return))))
	      (next l1 (cdr l1))
	      (result t))))

(defun recur-member (a l)
  (cond ((atom l) nil)
	((member a l :test #'equal) t)
	(t (g-loop (while l)
		   (do (if (recur-member a (car l))
			   (return t)))
		   (next l (cdr l))
		   (result nil)))))


(defun make-pairs (l1 l2)
  (mapcar #'(lambda (x y) (list x y)) l1 l2))
