#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

; Contains Proof schemas (i.e. axioms) for learning from failure. 

(setq *F-SCHEMAS* '(

(def-node-fails-from-scr-rejection
  (fails <s>)
  (node-rejection-rule-fired <s>))

(def-already-achieved1
  (fails <s>)
  (exists (<g>)(already-ach-lit <g>)
	  (and (primary-candidate-goal <s> <g>)
	       (was-added <s> <g>))))

(def-already-achieved2
  (fails <s>)
  (exists (<g>)(already-ach-lit <g>)
	  (and (on-goal-stack <s> <g>)
	       (known <s> <g>))))
	       

(def-state-loop
  (fails <s>)
  (previous-state-diff <s> nil))

(def-goal-stack-loop
    (fails <s>)
    (exists (<goal>) (is-goal-literal <g>)
	    (and (candidate-goal <s> <g>)
		 (on-goal-stack <s> <g>))))

		
;  to get rid of all these "literal" things, but them in tc-spec rule
; template

(def-reset-fails 
    (fails <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	 (let (<op>)(old-legal-operator <op>)
	      (and (alt-on-deck <s> <goal> <op>)
		   (op-fails <s> <goal> <op>)))))


(def-fails
    (fails <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	 (and (primary-candidate-goal <s> <goal>)
;    	      (not-top-level-node <s>) -- now checked by primary-candidate-goal
	      (goal-failure <s> <goal>))))

; should make a general "is-goal" predicate and get-rid-of below...
; assumes goal selection only at top-level-node.

(def-fails-after-goal-selection
    (fails <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	    (and (is-top-level-goal <s> <goal>)
		 (goal-selected-by-scr <s> <goal>)
		 (goal-failure <s> <goal>))))

; not used for top-level goals

(def-fails-after-goal-rejection
    (fails <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	    (and (primary-candidate-goal <s> <goal>)
		 (goal-rejected-by-scr <s> <goal>))))



(def-top-level-fails
    (fails <s>)
    (let (<goal-set>) (set-of-goal-formulii <goal-set>)
           (forall (<goal>) (in-set <g> <goal-set>)
	       (and (is-top-level-goal <s> <g>)
	            (goal-failure <s> <g>)))))

(def-goal-fails
   (goal-fails <s> <g>)
   (exists (<goal>) (is-goal-literal <g>)  
        (goal-failure <s> <g>)))


(def-goal-fails-due-to-goal-rejection
    (goal-failure <s> <g>)
    (top-level-goal-rejected-by-scr <s> <g>))

; CURRENTLY ASSUMES ONLY ONE SELECTED!! 

(def-goal-fails-after-op-selection
  (goal-failure <s> <g>)
  (exists (<op>) (legal-operator <op>)
     (and (op-selected-by-scr <s> <g> <op>)
          (op-fails <s> <g> <op>))))
  
(def-all-ops-failed
  (goal-failure <s> <g>)
  (forall (<op>) (is-op <op>)
   (op-fails <s> <g> <op>)))
	       

(def-op-fails-from-scr-rejection
    (op-fails <s> <g> <op>)
    (op-rejection-rule-fired <s> <g> <op>))


; used when reset has no bvars, so we can take shortcut

(def-cached-op-failed
    (op-fails <s> <g> <op>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>)(legal-operator <op>)
        (let (<s2>) (fails <s2>)
          (implies-op-fails <s> <g> <op> <s2>)))))
	  
;  put in op fails, make sure reset is right.
;(a deleted b)
;(b deleted a)
;(reset-op .....<sdfsdfdf> with bound-vars)

 (def-reset-op-fails-bro-deletion
    (op-fails <s> <goal> <op>)
    (exists (<goal>) (is-goal-literal <goal>)
      (exists (<op>)(legal-operator <op>)
         (let (<deleted-goal1>) (get-deleted-goal1 <deleted-goal1> <s> <op>)
            (let (<deleted-goal2>) (get-deleted-goal2 <deleted-goal2> <s> <op>)
              (let (<bvars>) (get-necessary-bvars <bvars> <op>
				 <deleted-goal1> <deleted-goal2>)
		 (and (has-bound-vars <s> <goal> <op> <bvars>)
		      (was-deleted-by <s> <deleted-goal1> <op> <bvars>)
		      (was-deleted-by <s> <deleted-goal2> <op> <bvars>))))))))
		 
; bvars is like a signature indicating which vars are bound

(def-reset-op-fails
    (op-fails <s> <g> <op>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>)(legal-operator <op>)
	(let (<bvars>) (get-reset-alt <s> <op> <bvars>)
	  (and (has-bound-vars <s> <g> <op> <bvars>)
               (forall (<add>) (get-used-add <add> <op>) ; ignores deletes...  
                 (add-fails <s> <g> <add> <op>)))))))


(def-op-fails
    (op-fails <s> <g> <op>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>)(legal-operator <op>)
	  (forall (<add>) (in-add-list <add> <op>) ; ignores deletes...  
	     (add-fails <s> <g> <add> <op>)))))



(def-not-relevent-failure
  (add-fails <s> <goal> <add> <op>)
  (not-relevent <add> <goal> nil))

; had to add has-rhs-constants since relevent-bindings was
; including the var-constant binding when the add had a constant.
; Thus, the <goal> was instantiated throught, screwing up
; things like regressing on-goal-stack.

(def-unsuccessful
    (add-fails <s> <goal> <add> <op>)
    (and (has-rhs-constants <goal> <add>)
	 (let (<r-bindings>)
	      (relevent-bindings <r-bindings> <op> <add> <goal>)
	      (let (<orig-preconds>) (get-lpreconds <orig-preconds> <op>)
		   (let (<dvars>) (ps-make-dvars <dvars> <add> nil)
			(exp-failure
			 <orig-preconds> <r-bindings> <op> <add> <goal> <dvars> <s>))))))

; key thing is you got to make sure lookups on lit-failures
; only give you the children corresponding to rbindings

; makes use of def-lit-failure-not-same-bindings schema.

(def-bindings-fail
    (bindings-fail <s> <g> <op> <bindings>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>) (legal-operator <op>)
       (let (<b>) (ps-get-op-bindings <op> <b>)
         (let (<add>) (ps-get-add-for-op <op> <add>)
	  (let (<dvars>) (ps-make-dvars <dvars> <b> nil)
	   (let (<orig-preconds>) (get-lpreconds <orig-preconds> <op>)
	    (and (is-equal <b> <bindings>)
	         (exp-failure <orig-preconds> nil <op> <add> <g> <dvars> <s>))))))
      )))
				  
 ; vars list doesn't contain bound vars.

(def-exp-or-application-failure
   (exp-failure <exp> <b> <op> <add> <g> <dvars> <s>)
   (or (application-fails <add> <op> <b> <dvars> <g> <s>)
       (exp-failure <exp> <b> <op> <add> <g> t <s>)))

; must come after exp-or-application-failure
; dont bother, lets deal with short exists directly
;(def-exp-t-failure				 		
; (exp-failure <exp> <b> <op> <add> <g> <dvars> <s>)
;    (and (eq t <exp)
;	 nil))

(def-exp-failure
 (exp-failure <exp> <b> <op> <add> <g> <dvars> <s>)
 (let (<exp-type>)  (is-car <exp-type> <exp>)
    (or	(bindings-rejected <s> <exp> <g> <op> <add> <b> <dvars>)
	(and (ps-is-equal <exp-type> forall) ; should use caps, but can't!
	     (let (<vars-lst>)  (ps-get-vars-lst <vars-lst> <b> <exp>)
	      (let (<gen-exp>) (ps-get-gen-exp <gen-exp> <exp>)
	       (let (<sub-exp>) (ps-get-exp <sub-exp> <exp>)
  	        (forall-failure <vars-lst> <gen-exp> <sub-exp> 
		    <b> <op> <add> <g> <dvars> <s>)))))
       (and (ps-is-equal <exp-type> exists)
	    (let (<vars-lst>)  (ps-get-vars-lst <vars-lst> <b> <exp>)
	      (let (<gen-exp>) (ps-get-gen-exp <gen-exp> <exp>)
	       (let (<sub-exp>) (ps-get-exp <sub-exp> <exp>)
                 (exists-failure <vars-lst> <gen-exp> <sub-exp> <b> 
		            <op> <add> <g> <dvars> <s>)))))
       (and (ps-is-equal <exp-type> and)
	    (let (<subexps>) (is-cdr <subexps> <exp>)
             (and-failure <subexps> <b> <op> <add> <g> <dvars> <s>)))
       (and (ps-is-equal <exp-type> or)
	    (let (<subexps>) (is-cdr <subexps> <exp>)
             (or-failure <subexps> <b> <op> <add> <g> <dvars> <s>)))
       (and (is-negated <exp>)
	    (let (<rest>) (is-cadr <rest> <exp>)
		 (and (~ (is-predicate <rest>)) ; negated exists unimplmented
    		      (too-soon))))
       (and (or (is-predicate <exp-type>)
		(is-negated <exp>))
	    (lit-subgoal-failure <exp> <b> <op> <add> <g> <s>)))))

; if it wasnt applied cause of reject, no subexp failed...

(def-exp-failure-last-possibility
  (exp-failure <exp> <b> <op> <add> <g> <dvars> <s>)
  (bindings-rejected <s> <exp> <g> <op> <add> <b> <dvars>))

; general-note: get rid of subst bindings by just using is-equals in beginning.

(def-lit-failure-not-same-bindings
  (lit-subgoal-failure <exp> <b> <op> <add> <g> <s>)
  nil)


(def-lit-inference-failure
(lit-subgoal-failure <exp> <b> <op> <add> <g> <s>)
 (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
   (and (is-open-world-exp <iexp>)
	   		;  have to change, look at all r-clones
        (exists (<s2>) (fails <s2>)
          (generate-subgoal-state <s2> <iexp> <g> <b> <s>)))))
 
(def-lit-static-failure
  (lit-subgoal-failure <exp> <b> <op> <add> <g>  <s>)
  (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
        (~ (known <s> <iexp>))))

; dont need to say that condition is not known, since
; conjunct later fails...

(def-later-reset-subgoal-failure 
(lit-subgoal-failure <exp> <b> <op> <add> <g>  <s>)
 (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
    (exists (<s2>) (fails <s2>)
	; (and  (is-reset-failure <s2>)) should put in, but unnecessary
              (generate-subgoal-state <s2> <iexp> <g> <b> <s>))))

(def-lit-subgoal-failure 
(lit-subgoal-failure <exp> <b> <op> <add> <g>  <s>)
 (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
   (and (~ (known <s> <iexp>))
	   		;  have to change, look at all r-clones
        (exists (<s2>) (fails <s2>)
          (generate-subgoal-state <s2> <iexp> <g> <b> <s>)))))


(def-forall-failure
 (forall-failure <vars-lst> <gen-exp> <sub-exp> <b> <op> <add> <g> <dvars> <s>)
  (let (<igen-exp>)(ps-subst-bindings <igen-exp> <gen-exp> <b>)
   (and (known <s> <igen-exp>)
        (exp-failure <sub-exp> <b> <op> <add> <g> <dvars> <s>))))

; took out        (let (<neg-exp>) (is-negation <neg-exp> <sub-exp>))

; already defined dvars -- maybe we should just go with the first clause???,
;  otherwise we're getting multiple reasons for failure...

(def-exists-and-failure
 (exists-failure <vars-lst> <gen-exp> <sub-exp> <b> <op> <add> <g> <dvars> <s>)
 (or (exp-failure <gen-exp> <b> <op> <add> <g> <dvars> <s>)
     (exp-failure <sub-exp> <b> <op> <add> <g> <dvars> <s>)))

; (let (<exps>) (ps-list <exps> <gen-exp> <sub-exp>)
;   (and-failure <exps> <b> <op> <add> <g> <dvars> <s>))

(def-exists-failure
 (exists-failure <vars-lst> <gen-exp> <sub-exp> <b> <op> <add> <g> <dvars> <s>)
 (or (exp-failure <gen-exp> <b> <op> <add> <g> <dvars> <s>)
     (let (<igen-exp>)(ps-subst-bindings <igen-exp> <gen-exp> <b>)
      (let (<new-dvars>) (ps-make-dvars <new-dvars> <vars-lst> <dvars>)
        (forall <vars-lst> (known <s> <igen-exp>)
            (exp-failure <sub-exp> <b> <op> <add> <g> <new-dvars> <s>))))))
  

(def-and-failure
 (and-failure <exps> <b> <op> <add> <g> <dvars> <s>)
 (and (~ (is-null <exps>))
      (let (<subexp>) (is-car <subexp> <exps>)
        (or (exp-failure <subexp> <b> <op> <add> <g> <dvars> <s>)
            (let (<rest>) (is-cdr <rest> <exps>)
              (and-failure <rest> <b> <op> <add> <g> <dvars> <s>))))))

(def-null-or-failure
 (or-failure <exps> <b> <op> <add> <g> <dvars> <s>)
  (is-null <exps>))

(def-or-failure
 (or-failure <exps> <b> <op> <add> <g> <dvars> <s>)
  (let (<subexp>) (is-car <subexp> <exps>)
    (and (exp-failure <subexp> <b> <op> <add> <g> <dvars> <s>)
           (let (<rest>) (is-cdr <rest> <exps>)
             (or-failure <rest> <b> <op> <add> <g> <dvars> <s>)))))


(def-application-fails
 (application-fails <add> <op> <r-bindings> <dvars> <g> <s>)
 (exists (<s2>)  (fails <s2>)
          (apply-op-to-generate-new-state <s2> <op> <add> <r-bindings> <g> <s>)))



(def-not-relevent
 (not-relevent <lit1> <lit2> <bindings>)
 (let (<arg1>)  (is-car <arg1> <lit1>)  
  (and (too-soon)
  (let (<arg2>)  (is-car <arg2> <lit2>)
   (let (<rest1>)  (is-cdr <rest1> <lit1>)
    (let (<rest2>)  (is-cdr <rest2> <lit2>)
         (or (and (ps-is-constant <arg1>)
		  (ps-not-equal <arg1> <arg2>))
	     (and (is-var <arg1>)
	          (let (<val>) (get-binding <val> <arg1> <bindings>)
		     (ps-not-equal <val> <arg2>)))
	     (let (<new-bindings>) 
		   (add-new-bindings <new-bindings> <bindings> <arg1> <arg2>)
	       (not-relevent <rest1> <rest2> <new-bindings>)))))))))

; The following two schemas have been proceduralized and put in cmpl.lisp

;(def-schema
; (not-relevent <lit1> <lit2> <bindings>)
; (let (<arg1>)  (is-car <arg1> <lit1>)  
;  (let (<arg2>)  (is-car <arg2> <lit2>)
;         (or (and (ps-is-constant <arg1>)
;		  (ps-not-equal <arg1> <arg2>))
;	     (and (is-var <arg1>)
;	          (let (<val>) (get-binding <val> <arg1> <bindings>)
;		     (not-equal <val> <arg2>))))))


;(def-schema
; (not-relevent <lit1> <lit2> <bindings>)
; (let (<rest1>) (is-cdr <rest1> <lit1>)
;  (let (<rest2>)  (is-cdr <rest2> <lit2>)
;   (let (<new-bindings>) 
;	(add-new-bindings <new-bindings> 
;			   <bindings> <arg1> <arg2>)
;    (not-relevent <rest1> <rest2> <new-bindings>))))))



(def-done-atomic-match
 (atomic-match <bindings> <lit1> <lit2>) 
 (and (is-null <lit1>)
      (is-null <lit2>)
      (is-null <bindings>)))

(def-atomic-match
 (atomic-match <bindings> <lit1> <lit2>) 
    (and (~ (is-null <lit1>))
     (let (<arg1>) (is-car <arg1> <lit1>)
      (let (<arg2>) (is-car <arg2> <lit2>)
       (let (<rest1>) (is-cdr <rest1> <lit1>)
	(let (<rest2>) (is-cdr <rest2> <lit2>)
         (let (<sub-bindings>) 
	      (atomic-match <sub-bindings> <rest1> <rest2>)
	  (or (and (ps-is-constant <arg1>)
                   (ps-is-equal <arg1> <arg2>)
		   (ps-is-equal <bindings> <sub-bindings>))
              (and (is-var <arg1>)
		   (let (<pair>) (ps-make-pair <pair> <arg1> <arg2>)
		    (ps-consistent-bindings 
			     <bindings> <pair> <sub-bindings>)))))))))))

(def-relevent-bindings
 (relevent-bindings <bindings> <op> <add> <goal>)
 (or (and (~ (is-negated <goal>)) 
          (atomic-match <bindings> <add> <goal>))
     (and (is-negated <goal>)
          (let (<atomic-goal>) (strip-negation <atomic-goal> <goal>)
	   (exists (<del>)  (in-delete-list <del> <op>)
	    (and nil 		; for now!
                 (atomic-match <bindings> <del> <atomic-goal>)))))))

		  ))
