#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


(proclaim '(special *TEST-PROBS* *AUX-COMMANDS* *PROB-NM* *MACRO-LEARNING*
		    *LEARNED-RULES-IN-SYS* *SAVED-RULES* *LEARNED-RULES*
 		    *NEW-LEARNED-RULES* *EXPAND-ALL*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))



(defun run-all ()
  (g-loop (while *TEST-PROBS*)
	  (do (load-next)
	      (if (boundp '*PROB-NM) (format t "~%PROBLEM: ~a" *PROB-NM*))
	      (run))))


(defun invoke-learning ()
  (cond (*MACRO-LEARNING* 
	 (format t "Mac-sequence:")
	 (print-mac-sequence 10 (node-solution (eval 'N1)))))
  (utility-validation)
  (show-times)
  (if (not *MACRO-LEARNING*) (ex-aux-commands))
  (if *EXPAND-ALL* (expand-all))
  (cond (*MACRO-LEARNING*
	 (and (first-succ-node) ; there was a success
	      (o2 n2)))
	(t (o2 n2)))
  (backup-times) ; dont count stuff used during restart
  (cond (*MACRO-LEARNING* (load-new-macs))
	(t (load-new-scrs)))
  (reset-obs))



; could just glom them onto one big list and write
; it out whole. Might make reading it back better.	
; notice that reading and writing each reverse order,
; so we get the result that rules are eventually in same order.

(defun write-rules (file-nm)
  (with-open-file (prt file-nm :direction :output :if-exists :append
		       :if-does-not-exist :create)
    (g-loop (init *SAVED-RULES* nil tmp-rules *LEARNED-RULES-IN-SYS* nm nil 
		new-nm nil count 0)
	  (before-starting
	   (princ "(setq *SAVED-RULES* (quote " prt))
	  (while (setq nm (pop tmp-rules)))
	  (do (setq count (+ 1 count))
  	      (setq new-nm (intern (concatenate
				    'string "sr" (prin1-to-string count))))
	      (push `(,new-nm
		      (lhs ,(get nm 'lhs))
		      (rhs ,(get nm 'rhs))
		      (unique-sig ,(get nm 'unique-sig))
		      (problem ,(get nm 'problem))
		      (training-ex ,(nodes-to-names (get nm 'training-ex)))
		      (was-learned t)
		      (lhs-for-ebs ,(get nm 'lhs-for-ebs))
		      (est-cost ,(get nm 'est-cost))
		      (est-savings ,(get nm 'est-savings))
		      (cum-savings ,(get nm 'cum-savings))
		      (match-time ,(get nm 'match-time))
		      (priority 0))
		    *SAVED-RULES*))
	  (before-returning 
	      (progn (pprint *SAVED-RULES* prt)
		     (princ "))" prt)))
	  (result t))))


(defun nodes-to-names (exp)
  (cond ((null exp) nil)
	((atom exp) (if (typep exp 'node) (node-name exp) exp))
	(t (mapcar #'nodes-to-names exp))))


    
  
(defun read-rules (file-nm)
  (if (not (load file-nm :if-does-not-exist nil))
      (format t "~%File ~a not found" file-nm)
    (cond ((intersectq *LEARNED-RULES* (mapcar #'car *SAVED-RULES*))
	   (format t "~%No go, some stored rules already in *LEARNED-RULES*~%")
	   nil)
	  ((g-loop (init rule-body nil nm nil count 0)
		   (while (setq rule-body (pop *SAVED-RULES*)))
		   (do (setq nm (pop rule-body))
		       (g-map (at-val in rule-body)
			      (do (setf (get nm (car at-val))
					(cadr at-val))))
		       (push nm *LEARNED-RULES-IN-SYS*)
		       (push nm *LEARNED-RULES*)
		       (dynamically-add-scr nm)
		       (setq count (+ 1 count)))
		   (before-returning
		    (format t "~%Added ~a stored rules~%" count))
		   (result t))))))
  
(defun forget-rules (&rest args)
  (cond ((null args)
	 (format t "~2%  Arguments must be supplied.")
	 (format t "~%    ALL - Removes all rules")
	 (format t "~%    ### - Removes last ### of rules")
	 (format t "~%    Rule-name(s) - Will remove instance(s) of")
	 (format t "rule-name(s)"))
	((and (eql (car args) 'ALL) (= (length args) 1))
	 (forget-all-rules)
	 (format t "~%  All rules forgotten"))
	((and (numberp (car args)) (= (length args) 1))
	 (forget-last-rules (car args))
	 (format t "~%  Last ~d rule~:P forgotten" (car args)))
	(t (forget-these-rules args))))


(defun forget-all-rules ()
  (g-loop (init r nil)
	  (while (setq r (pop *LEARNED-RULES-IN-SYS*)))
	  (do (remove-scr r)))
  (dolist (r *LEARNED-RULES*) (setf (symbol-plist r) nil))
  (setq *LEARNED-RULES* nil)
  (setq *NEW-LEARNED-RULES* nil)
  (setq *NUM-RUNS* 0)
  (reset-rule-unique-vars)
  t)


(defun forget-last-rules (k)
  (g-loop (init r nil n 0)
	  (while (setq r (pop *LEARNED-RULES-IN-SYS*)))
	  (do (remove-scr r)
	      (setq n (+ 1 n)))
	  (until (eq n k))))

(defun forget-these-rules (rs)
  (g-loop (init r nil n 0)
	  (while (setq r (pop rs)))
	  (do (remove-scr r)
	      (setq *LEARNED-RULES-IN-SYS*
		    (del-eq r *LEARNED-RULES-IN-SYS*)))))

(defun remove-scr (rule-nm)
  (let	((rule-lst-nm (rule-type-to-rule-lst (get rule-nm 'rule-type)))
	 rule)
    (setq rule (assoc rule-nm (eval rule-lst-nm)))
    (cond ((null rule)
	   (format t "~%Rule ~A doesn't exist in system: not removed" rule-nm))
	  (t (set rule-lst-nm
		  (del-eq rule (eval rule-lst-nm)))
	     (format t "~%Rule ~a removed from system" rule-nm)))))


; returns NAME of rule-lst

(defun rule-type-to-rule-lst (rule-type)
  (cadr (assoc rule-type '((node-select *SCR-NODE-SELECT-RULES*)
			   (goal-select *SCR-GOAL-SELECT-RULES*)
			   (op-select *SCR-OP-SELECT-RULES*)
			   (bindings-select *SCR-BINDINGS-SELECT-RULES*)
			   (node-reject *SCR-NODE-REJECT-RULES*)
			   (goal-reject *SCR-GOAL-REJECT-RULES*)
			   (op-reject *SCR-OP-REJECT-RULES*)
			   (bindings-reject *SCR-BINDINGS-REJECT-RULES*)
			   (node-pref *SCR-NODE-PREFERENCE-RULES*)
			   (goal-pref *SCR-GOAL-PREFERENCE-RULES*)
			   (op-pref *SCR-OP-PREFERENCE-RULES*)
			   (bindings-pref *SCR-BINDINGS-PREFERENCE-RULES*)))))


(defun dynamically-add-scr (nm)
  (let ((rule-type 
	 (cond ((eq (car (get nm 'rhs)) 'select)
		(cond ((eq (cadr (get nm 'rhs)) 'node) 'node-select)
		      ((eq (cadr (get nm 'rhs)) 'goal) 'goal-select)
		      ((eq (cadr (get nm 'rhs)) 'operator) 'op-select)
		      ((eq (cadr (get nm 'rhs)) 'bindings) 'bindings-select)
		      ((error "bad rule type" nm))))
	       ((eq (car (get nm 'rhs)) 'reject)
		(cond ((eq (cadr (get nm 'rhs)) 'node) 'node-reject)
		      ((eq (cadr (get nm 'rhs)) 'goal) 'goal-reject)
		      ((eq (cadr (get nm 'rhs)) 'operator) 'op-reject)
		      ((eq (cadr (get nm 'rhs)) 'bindings) 'bindings-reject)
		      ((error "bad rule type" nm))))
	       ((eq (car (get nm 'rhs)) 'prefer)
		(cond ((eq (cadr (get nm 'rhs)) 'node) 'node-pref)
		      ((eq (cadr (get nm 'rhs)) 'goal) 'goal-pref)
		      ((eq (cadr (get nm 'rhs)) 'operator) 'op-pref)
		      ((eq (cadr (get nm 'rhs)) 'bindings) 'bindings-pref)
		      ((error "bad rule type" nm)))))))
    (normalize-scr-for-ebs nm)
    (load-new-scntrl-rule 
     `(,nm (lhs ,(get nm 'lhs)) (rhs ,(get nm 'rhs)))
     rule-type)))



(defun show-rules ()
  (dolist (nm *LEARNED-RULES-IN-SYS*)
	  (cond ((get nm 'was-learned)
		 (format t "~2%Rule: ~A" nm)
                 (pprint (list 'lhs (get nm 'lhs)))
		 (pprint (list 'rhs (get nm 'rhs)))))))

; for debugging 

(defun print-gi-labels (node)
    (dolist (nn (postorder node))
	(format t "~%~a ~a" nn (node-gi-label nn))
	(cond ((node-protection-violation nn)
	       (format t "  Protection violation: ~a"
		       (node-protection-violation nn))))
	(cond ((node-prerequisite-violation nn)
	       (format t "  Prerequisite violation: ~a"
		       (node-prerequisite-violation nn))))))



(defun ex-aux-commands ()
   (and (boundp '*AUX-COMMANDS*)
	(boundp '*PROB-NM*)
	(assoc *PROB-NM* *AUX-COMMANDS*)
	(g-loop (init c nil cs (cdr (assoc *PROB-NM* *AUX-COMMANDS*)))
	      (while (setq c (pop cs)))
	      (do (eval c)))))




