
;
;
; General Functions
;

(defun strip-negation (literal)
  (cond ((eq '~ (car literal))(cadr literal))
	(t literal)))

(defun print-array (array dim)
  (do ((col 0 (1+ col)))
      ((= col dim))
    (print-column array col)))

(defun print-row (iarray row)
  (do ((col 0 (1+ col)))
      ((= col (array-dimension iarray 0)))
    (format t "~%x=~d y=~d ~a" col row (aref iarray col row))))

(defun print-column (iarray col)
  (do ((row 0 (1+ row)))
      ((= row (array-dimension iarray 1)))
    (format t "~%x=~d y=~d ~a" col row (aref iarray col row))))


(defun swap-column (iarray col1 col2)
	(do ((y 0 (1+ y)))
	    ((> y (1- (array-dimension iarray 1))))
	    (let ((temp (aref iarray col1 y)))
		 (setf (aref iarray col1 y)(aref iarray col2 y))
		 (setf (aref iarray col2 y) temp))))

(defun swap-row (iarray row1 row2)
	(do ((x 0 (1+ x)))
	    ((> x (1- (array-dimension iarray 0))))
	    (let ((temp (aref iarray x row1)))
		 (setf (aref iarray x row1)(aref iarray x row2))
		 (setf (aref iarray x row2) temp))))
;;;
;;;
;;;
;;; Groups are combined by combining the corresponding rows and columns
;;; of the array representing the partial order.
;;;
(defun combine-interacting-groups (group1-index group2-index group-graph)
  ; Don't constrain a group to be abstracted before itself!
  (setf (aref group-graph group2-index group1-index) nil)
  (setf (aref group-graph group1-index group2-index) nil)
  (combine-rows group-graph group1-index group2-index)
  (combine-columns group-graph group1-index group2-index))

(defun combine-columns (iarray col1 col2)
  (cond ((eql col1 col2))
	(t (let ((x-dim (array-dimension iarray 0))
		 (y-dim (array-dimension iarray 1)))
	     (do ((y 0 (1+ y)))
		 ((= y y-dim))
	       (setf (aref iarray col1 y)
		     (append (aref iarray col1 y)(aref iarray col2 y))))
	     (do ((x col2 (1+ x)))
		 ((= x (1- x-dim)))
	       (do ((y 0 (1+ y)))
		   ((= y y-dim))
		 (setf (aref iarray x y)(aref iarray (1+ x) y))))
	     (adjust-array iarray (list (1- x-dim) y-dim))))))
	

(defun combine-rows (iarray row1 row2)
  (cond ((eql row1 row2))
	(t (let ((x-dim (array-dimension iarray 0))
		 (y-dim (array-dimension iarray 1)))
	     (do ((x 0 (1+ x)))
		 ((= x x-dim))
	       (setf (aref iarray x row1)
		     (append (aref iarray x row1)(aref iarray x row2))))
	     (do ((y row2 (1+ y)))
		 ((= y (1- y-dim)))
	       (do ((x 0 (1+ x)))
		   ((= x x-dim))
		 (setf (aref iarray x y)(aref iarray x (1+ y)))))
	     (adjust-array iarray (list x-dim (1- y-dim)))))))

(defun combine-elements (iarray element1 element2)
  (cond ((eql element1 element2))
	(t (let ((dim (array-dimension iarray 0)))
	     (setf (aref iarray element1)
		   (append (aref iarray element1)(aref iarray element2)))
	     (do ((y element2 (1+ y)))
		 ((= y (1- dim)))
		 (setf (aref iarray y)(aref iarray (1+ y))))
	     (adjust-array iarray (list (1- dim)))))))

(defun delete-group (group-index group-graph)
  (delete-row group-graph group-index)
  (delete-column group-graph group-index))

(defun delete-column (iarray col)
  (let ((x-dim (array-dimension iarray 0))
	(y-dim (array-dimension iarray 1)))
    (do ((x col (1+ x)))
	((= x (1- x-dim)))
      (do ((y 0 (1+ y)))
	  ((= y y-dim))
	(setf (aref iarray x y)(aref iarray (1+ x) y))))
    (adjust-array iarray (list (1- x-dim) y-dim))))


(defun delete-row (iarray row)
  (let ((x-dim (array-dimension iarray 0))
	(y-dim (array-dimension iarray 1)))
    (do ((y row (1+ y)))
	((= y (1- y-dim)))
      (do ((x 0 (1+ x)))
	  ((= x x-dim))
	(setf (aref iarray x y)(aref iarray x (1+ y)))))
    (adjust-array iarray (list x-dim (1- y-dim)))))


(defun find-groups (connections row)
  (cond ((= row (array-dimension connections 1)) nil)
	(t (cons (aref connections 0 row)
		 (find-groups connections (1+ row))))))


(defun copy-array (array)
  (let ((new-array (make-array (array-dimensions array)
			       :initial-element nil
			       :adjustable (adjustable-array-p array)))
	(y-dim (array-dimension array 0))
	(x-dim (array-dimension array 1)))
    (do ((x 0 (1+ x)))
	((= x x-dim) new-array)
      (do ((y 0 (1+ y)))
	  ((= y y-dim))
	(setf (aref new-array y x)(aref array y x))))))
