;;; Room map for standard strips domain.

(setq *X-DIM* 12)
(setq *Y-DIM* 10)
(setq *Z-DIM* 0)

(setq *ROOMS* (list	(list 	(make-location :room 'room.ril :x 9 :y 0 :z 0)
				(make-location :room 'room.ril :x 11 :y 3 :z 0))
			(list 	(make-location :room 'room.clk :x 4 :y 0 :z 0)
				(make-location :room 'room.clk :x 8 :y 3 :z 0))
			(list 	(make-location :room 'room.pdp :x 2 :y 0 :z 0)
				(make-location :room 'room.pdp :x 3 :y 3 :z 0))
			(list 	(make-location :room 'room.uni :x 0 :y 4 :z 0)
				(make-location :room 'room.uni :x 1 :y 9 :z 0))
			(list 	(make-location :room 'room.mys :x 2 :y 4 :z 0)
				(make-location :room 'room.mys :x 5 :y 9 :z 0))
			(list 	(make-location :room 'room.hal :x 9 :y 4 :z 0)
				(make-location :room 'room.hal :x 11 :y 9 :z 0))
			(list 	(make-location :room 'room.ram :x 6 :y 4 :z 0)
				(make-location :room 'room.ram :x 8 :y 9 :z 0))
	      ))

(setq *ROBOT-POS* (list
			(make-location :room 'room.ril :x 9 :y 3 :z 0)
			(make-location :room 'room.hal :x 9 :y 9 :z 0)
			(make-location :room 'room.ram :x 6 :y 9 :z 0)
			(make-location :room 'room.clk :x 4 :y 3 :z 0)
			(make-location :room 'room.mys :x 2 :y 9 :z 0)
			(make-location :room 'room.pdp :x 2 :y 3 :z 0)
			(make-location :room 'room.uni :x 0 :y 9 :z 0)
		  )
)

(setq *DOORS* 
	(list 
	   (make-door	:name 'door.clkril
			:loc1 (make-location :room 'room.ril :x 9 :y 1  :z 0)
			:loc2 (make-location :room 'room.clk :x 8 :y 1 :z 0))
	   (make-door	:name 'door.mysclk
			:loc1 (make-location :room 'room.mys :x 5 :y 4 :z 0)
			:loc2 (make-location :room 'room.clk :x 5 :y 3 :z 0))
	   (make-door	:name 'door.pdpclk
			:loc1 (make-location :room 'room.clk :x 4 :y 1 :z 0)
			:loc2 (make-location :room 'room.pdp :x 3 :y 1 :z 0))
	   (make-door	:name 'door.myspdp
			:loc1 (make-location :room 'room.pdp :x 2 :y 3 :z 0)
			:loc2 (make-location :room 'room.mys :x 2 :y 4 :z 0))
	   (make-door	:name 'door.unimys
			:loc1 (make-location :room 'room.uni :x 1 :y 7 :z 0)
			:loc2 (make-location :room 'room.mys :x 2 :y 7 :z 0))
	   (make-door	:name 'door.mysram 
			:loc1 (make-location :room 'room.mys :x 5 :y 7 :z 0)
			:loc2 (make-location :room 'room.ram :x 6 :y 7 :z 0))
	   (make-door	:name 'door.ramclk
			:loc1 (make-location :room 'room.ram :x 7 :y 4 :z 0)
			:loc2 (make-location :room 'room.clk :x 7 :y 3 :z 0))
	   (make-door	:name 'door.ramhal
			:loc1 (make-location :room 'room.ram :x 8 :y 6 :z 0)
			:loc2 (make-location :room 'room.hal :x 9 :y 6 :z 0))
	)
)
(setq *ROOM-MAP* (make-array (list *X-DIM* *Y-DIM*) :initial-element nil))

(initialize-room-map *ROOMS*)
