;(in-package 'strips) 

(defun loc-in-room (x y room)
    (cond ((or (is-variable x)
	       (is-variable y))
	   'no-match-attempted)
	  ((is-variable room)
	   `(((,room ,(convert-loc-to-room x y)))))
	  ((atom room)(eq room (convert-loc-to-room x y)))
	  (t (error "Room is not a variable or an atom"))))

(defun convert-loc-to-room (x y)
  (cond ((and (<= y 5)
	      (>= y 1))
	 (cond ((and (<= x 4)
		     (>= x 3))
		'rpdp)
	       ((and (<= x 9)
		     (>= x 5))
		'rclk)
	       ((and (<= x 12)
		     (>= x 10))
		'rril)
	       (t (error "Invalid x room coordinate"))))
	((and (<= y 10)
	      (>= y 6))
	 (cond ((and (<= x 2)
		     (>= x 1))
		'runi)
	       ((and (<= x 6)
		     (>= x 3))
		'rmys)
	       ((and (<= x 9)
		     (>= x 7))
		'rram)
	       ((and (<= x 12)
		     (>= x 10))
		'rhal)
	       (t (error "Invalid x room coordinate"))))
	(t (error "Invalid y room coordinate"))))


(defun distance (room1 room2 distance)
    (cond ((or (is-variable room1)
	       (is-variable room2))
	   'no-match-attempted)
	  ((is-variable distance)
	   `(((,distance ,(compute-distance room1 room2)))))
	  (t (= distance (compute-distance room1 room2)))))

(defun compute-distance (room1 room2)
  (cond ((eq room1 'runi)
	 (cond ((eq room2 'runi) 0)
	       ((eq room2 'rmys) 1)
	       ((eq room2 'rram) 2)
	       ((eq room2 'rhal) 3)
	       ((eq room2 'rpdp) 2)
	       ((eq room2 'rclk) 2)
	       ((eq room2 'rril) 3)))
	((eq room1 'rmys)
	 (cond ((eq room2 'rmys) 0)
	       ((eq room2 'runi) 1)
	       ((eq room2 'rram) 1)
	       ((eq room2 'rhal) 2)
	       ((eq room2 'rpdp) 1)
	       ((eq room2 'rclk) 1)
	       ((eq room2 'rril) 2)))
	((eq room1 'rram)
	 (cond ((eq room2 'rram) 0)
	       ((eq room2 'rmys) 1)
	       ((eq room2 'runi) 2)
	       ((eq room2 'rhal) 1)
	       ((eq room2 'rpdp) 2)
	       ((eq room2 'rclk) 1)
	       ((eq room2 'rril) 2)))
	((eq room1 'rhal)
	 (cond ((eq room2 'rhal) 0)
	       ((eq room2 'rmys) 2)
	       ((eq room2 'rram) 1)
	       ((eq room2 'runi) 3)
	       ((eq room2 'rpdp) 3)
	       ((eq room2 'rclk) 2)
	       ((eq room2 'rril) 3)))
	((eq room1 'rpdp)
	 (cond ((eq room2 'rpdp) 0)
	       ((eq room2 'rmys) 1)
	       ((eq room2 'rram) 2)
	       ((eq room2 'rhal) 3)
	       ((eq room2 'runi) 2)
	       ((eq room2 'rclk) 1)
	       ((eq room2 'rril) 2)))
	((eq room1 'rclk)
	 (cond ((eq room2 'rclk) 0)
	       ((eq room2 'rmys) 1)
	       ((eq room2 'rram) 2)
	       ((eq room2 'rhal) 2)
	       ((eq room2 'rpdp) 1)
	       ((eq room2 'runi) 2)
	       ((eq room2 'rril) 1)))
	((eq room1 'rril)
	 (cond ((eq room2 'rril) 0)
	       ((eq room2 'rmys) 2)
	       ((eq room2 'rram) 2)
	       ((eq room2 'rhal) 3)
	       ((eq room2 'rpdp) 2)
	       ((eq room2 'rclk) 1)
	       ((eq room2 'runi) 3)))))


; LESS-THAN 

(defun less-than (a b)
    (cond ((is-variable a) 'no-match-attempted)
	  ((is-variable b) 'no-match-attempted)
	  (t (< a b))))

