	
(setq *OPERATORS* '(

(GOTO-BOX
 (params (<box> <room>))
 (preconds (and
	    (is-type <box> box) ;(6)
	    (in-room <box> <room>) ;(5)
	    (in-room robot <room>) ;(3)
	    ))
 (effects ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
	   (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
	   (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
	   (add (next-to robot <box>)))
	  ))

(GOTO-DOOR
 (params (<door> <room.x>))
 (preconds (and
	    (is-type <door> door) ;(6)
	    (connects <door> <room.x> <room.y>) ;(6)
	    (in-room robot <room.x>) ;(3)
	    ))
 (effects 
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (add (next-to robot <door>)))))
    
(GOTO-LOC
 (params (<loc.x> <loc.y> <room.x>))
 (preconds (and
	    (loc-in-room <loc.x> <loc.y> <room.x>) ;(6)
	    (in-room robot <room.x>) ;(3)
	    ))
 (effects 
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (add (at robot <loc.x> <loc.y>)))))
          
(PUSH-BOX
 (params (<box.x> <box.y>))
 (preconds (and
	    (is-type <box.y> box) ;(6)
	    (pushable <box.x>) ;(6)
	    (in-room <box.y> <room.x>) ;(5)
	    (in-room <box.x> <room.x>) ;(5)
	    (in-room robot <room.x>) ;(3)
	    (next-to robot <box.x>) ;(2)
	    ))
 (effects
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (if (at <box.x> <loc.3> <loc.4>)(del (at <box.x> <loc.3> <loc.4>)))
     (if (next-to <box.x> <box.2>)(del (next-to <box.x> <box.2>)))
     (if (next-to <box.x> <door.2>)(del (next-to <box.x> <door.2>)))
     (if (next-to <box.3> <box.x>)(del (next-to <box.3> <box.x>)))
     (add (next-to <box.y> <box.x>))     
     (add (next-to <box.x> <box.y>))
     (add (next-to robot <box.x>)))))

(PUSH-TO-DOOR
 (params (<box> <door> <room.x>))
 (preconds (and
	    (connects <door> <room.x> <room.y>) ;(6)
	    (pushable <box>) ;(6)
	    (is-type <door> door) ;(6)
	    (in-room <box> <room.x>) ;(5)
	    (in-room robot <room.x>) ;(3)
	    (next-to robot <box>) ;(2)
	    ))
 (effects     
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (if (at <box> <loc.3> <loc.4>)(del (at <box> <loc.3> <loc.4>)))
     (if (next-to <box> <box.2>)(del (next-to <box> <box.2>)))
     (if (next-to <box> <door.2>)(del (next-to <box> <door.2>)))
     (if (next-to <box.3> <box>)(del (next-to <box.3> <box>)))
     (add (next-to <box> <door>))
     (add (next-to robot <box>)))))


(PUSH-TO-LOC
 (params (<box> <loc.x> <loc.y>))
 (preconds (and
	    (pushable <box>) ;(6)
	    (loc-in-room <loc.x> <loc.y> <room.x>) ;(6)
	    (in-room <box> <room.x>) ;(5)
	    (in-room robot <room.x>) ;(3)
	    (next-to robot <box>) ;(2)
	    ))
 (effects
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (if (at <box> <loc.3> <loc.4>)(del (at <box> <loc.3> <loc.4>)))
     (if (next-to <box> <box.2>)(del (next-to <box> <box.2>)))
     (if (next-to <box> <door.2>)(del (next-to <box> <door.2>)))
     (if (next-to <box.3> <box>)(del (next-to <box.3> <box>)))
     (add (at <box> <loc.x> <loc.y>))
     (add (next-to robot <box>)))))

(GO-THRU-DOOR
 (params (<door> <room.y> <room.x>))
 (preconds (and
	    (connects <door> <room.y> <room.x>) ;(6)
	    (is-type <door> door) ;(6)
	    (is-type <room.x> room) ;(6)
	    (in-room robot <room.y>) ;(3)
;	    (next-to robot <door>) ;(2) ; Not in the original formalization.
	    (statis <door> open) ;(1)
	    ))
 (effects    
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (if (in-room robot <room.y>)(del (in-room robot <room.y>)))
     (add (in-room robot <room.x>)))))

(PUSH-THRU-DOOR
 (params (<box> <door> <room.y> <room.x>))
 (preconds (and
	    (connects <door> <room.y> <room.x>) ;(6)
	    (pushable <box>) ;(6)
	    (is-type <door> door) ;(6)
	    (is-type <room.x> room) ;(6)
	    (in-room <box> <room.y>) ;(5)
	    (next-to <box> <door>) ;(4)
	    (in-room robot <room.y>) ;(3)
	    (next-to robot <box>) ;(2)
	    (statis <door> open) ;(1)
	    ))
 (effects
    ((if (at robot <loc.1> <loc.2>)(del (at robot <loc.1> <loc.2>)))
     (if (next-to robot <box.1>)(del (next-to robot <box.1>)))
     (if (next-to robot <door.1>)(del (next-to robot <door.1>)))
     (if (at <box> <loc.3> <loc.4>)(del (at <box> <loc.3> <loc.4>)))
     (if (next-to <box> <box.2>)(del (next-to <box> <box.2>)))
     (if (next-to <box> <door.2>)(del (next-to <box> <door.2>)))
     (if (next-to <box.3> <box>)(del (next-to <box.3> <box>)))
     (if (in-room robot <room.y>)(del (in-room robot <room.y>)))
     (if (in-room <box> <room.y>)(del (in-room <box> <room.y>)))
     (add (in-room robot <room.x>))
     (add (in-room <box> <room.x>))
     (add (next-to robot <box>)))))

(OPEN-DOOR 
 (params (<door>))
 (preconds (and
	    (is-type <door> door) ;(6)
	    (next-to robot <door>) ;(2)
	    (statis <door> closed) ;(1)
	    ))
 (effects 
    ((if (statis <door> closed)(del (statis <door> closed)))
     (add (statis <door> open)))))

(CLOSE-DOOR
 (params (<door>))
 (preconds (and
	    (is-type <door> door) ;(6)
	    (next-to robot <door>) ;(2)
	    (statis <door> open) ;(1)
	    ))
 (effects 
    ((if (statis <door> open)(del (statis <door> open)))
     (add (statis <door> closed)))))
    	  
          
		 ))

(setq *INFERENCE-RULES* '(

;(CONNECTS
; (params (<door> <room.y> <room.x>))
; (preconds (or (connect <door> <room.y> <room.x>)
;	       (connect <door> <room.x> <room.y>)))
; (effects ((add (connects <door> <room.y> <room.x>)))))

))
