;;
;; Changes from Steve's version of the schedworld
;;
;;
;; 1) Made two polish operators in order to eliminate the disjuction.
;; 
;; 2) Make explicit the constraint that operators can't be performed
;; on an object once it is joined.  This was implicitly encoded by
;; deleting the object once it was joined.
;;
;; 
(setq *OPERATORS* '(

(POLISH-1
  (params (<obj-pc> <time-pc> <time-prev-pc>))
  (preconds
    (and
      (is-object <obj-pc>) 
      (~ (joined <obj-pc> <obj-pc2> <or-pc>))
      (~ (joined <obj-pc2> <obj-pc> <or-pc>))
      (clampable <obj-pc> POLISHER)
      (last-scheduled <obj-pc> <time-prev-pc>) 
      (later <time-pc> <time-prev-pc>)
      (idle POLISHER <time-pc>)
      ))
  (effects (
    (del (surface-condition <obj-pc> <surface-*7-pc>))
    (add (surface-condition <obj-pc> POLISHED))
    (del (last-scheduled <obj-pc> <time-prev-pc>))
    (add (last-scheduled <obj-pc> <time-pc>))
    (add (scheduled <obj-pc> POLISHER <time-pc>)))))

(POLISH-2
  (params (<obj-pr> <time-pr> <time-prev-pr>))
  (preconds
    (and
      (is-object <obj-pr>) 
      (~ (joined <obj-pr> <obj-pr2> <or-pr>))
      (~ (joined <obj-pr2> <obj-pr> <or-pr>))
      (shape <obj-pr> RECTANGULAR)
      (last-scheduled <obj-pr> <time-prev-pr>) 
      (later <time-pr> <time-prev-pr>)
      (idle POLISHER <time-pr>)
      ))
  (effects (
    (del (surface-condition <obj-pr> <surface-*7-pr>))
    (add (surface-condition <obj-pr> POLISHED))
    (del (last-scheduled <obj-pr> <time-prev-pr>))
    (add (last-scheduled <obj-pr> <time-pr>))
    (add (scheduled <obj-pr> POLISHER <time-pr>)))))


(GRIND
  (params (<obj-g> <time-g> <time-prev-g>))
  (preconds
    (and
      (is-object <obj-g>)
      (~ (joined <obj-g> <obj-g2> <or-g>))
      (~ (joined <obj-g2> <obj-g> <or-g>))
      (last-scheduled <obj-g> <time-prev-g>)
      (later <time-g> <time-prev-g>)
      (idle GRINDER <time-g>)))
  (effects (
     (del (surface-condition <obj-g> <surface-*1-g>))
     (add (surface-condition <obj-g> SMOOTH))
     (del (painted <obj-g> <color-*2-g>))
     (del (last-scheduled <obj-g> <time-prev-g>))
     (add (last-scheduled <obj-g> <time-g>))
     (add (scheduled <obj-g> GRINDER <time-g>)))))


(ROLL
  (params (<obj-r> <time-r> <time-prev-r>))
  (preconds
    (and
      (is-object <obj-r>)
      (~ (joined <obj-r> <obj-r2> <or-r>))
      (~ (joined <obj-r2> <obj-r> <or-r>))
      (last-scheduled <obj-r> <time-prev-r>)
      (later <time-r> <time-prev-r>)
      (idle ROLLER <time-r>)
      (shape <obj-r> <shape-old-r>)))
  (effects (
     (del (shape <obj-r> <shape-old-r>))
     (del (temperature <obj-r> <temp-old-r>))
     (del (has-hole <obj-r> <width-*3-r> <orientation-*4-r>>))    
     (del (surface-condition <obj-r> <surface-*1-r>))
     (del (painted <obj-r> <color-*2-r>))
     (del (last-scheduled <obj-r> <time-prev-r>))
     (add (temperature <obj-r> HOT))
     (add (shape <obj-r> CYLINDRICAL))
     (add (last-scheduled <obj-r> <time-r>))
     (add (scheduled <obj-r> ROLLER <time-r>)))))


(LATHE  
  (params (<obj-l> <time-l> <shape-l> <time-prev-l>))
  (preconds
    (and
      (is-object <obj-l>)
      (~ (joined <obj-l> <obj-l2> <or-l>))
      (~ (joined <obj-l2> <obj-l> <or-l>))
      (last-scheduled <obj-l> <time-prev-l>)
      (later <time-l> <time-prev-l>)
      (idle LATHE <time-l>)
      (shape <obj-l> <shape-l>)))
  (effects (
     (del (shape <obj-l> <shape-l>))
     (del (surface-condition <obj-l> <surface-*3-l>))
     (del (painted <obj-l> <color-*4-l>))
     (del (last-scheduled <obj-l> <time-prev-l>))
     (add (surface-condition <obj-l> ROUGH))
     (add (shape <obj-l> CYLINDRICAL)) ; <---take this out for failure
     (add (last-scheduled <obj-l> <time-l>))
     (add (scheduled <obj-l> LATHE <time-l>)))))

(PUNCH
  (params (<obj-u> <time-u> <width-hole-u> <orientation-u> <time-prev-u>))
  (preconds
    (and
      (is-object <obj-u>)
      (~ (joined <obj-u> <obj-u2> <or-u>))
      (~ (joined <obj-u2> <obj-u> <or-u>))
      (is-punchable <obj-u> <width-hole-u> <orientation-u>)
      (clampable <obj-u> PUNCH)
      (last-scheduled <obj-u> <time-prev-u>)
      (later <time-u> <time-prev-u>)
      (idle PUNCH <time-u>)
    ))
  (effects (
    (del (surface-condition <obj-u> <surface-*33-u>))
    (del (last-scheduled <obj-u> <time-prev-u>))
    (add (surface-condition <obj-u> ROUGH))
    (add (has-hole <obj-u> <width-hole-u> <orientation-u>))
    (add (last-scheduled <obj-u> <time-u>))
    (add (scheduled <obj-u> PUNCH <time-u>)))))


(DRILL-PRESS
  (params (<obj-d> <time-d> <width-hole-d> <orientation-d> <time-prev-d>))
  (preconds
    (and
      (is-object <obj-d>)
      (~ (joined <obj-d> <obj-d2> <or-d>))
      (~ (joined <obj-d2> <obj-d> <or-d>))
      (is-drillable <obj-d> <orientation-d>)
;      (~ (surface-condition <obj-d> POLISHED))
      (last-scheduled <obj-d> <time-prev-d>)
      (later <time-d> <time-prev-d>)
      (idle DRILL-PRESS <time-d>)
      (have-bit <width-hole-d>)
    ))
  (effects (
    (del (last-scheduled <obj-d> <time-prev-d>))
    (add (has-hole <obj-d> <width-hole-d> <orientation-d>))
    (add (last-scheduled <obj-d> <time-d>))
    (add (scheduled <obj-d> DRILL-PRESS <time-d>)))))



(BOLT
  (params (<obj-1-b> <obj-2-b> <time-b> <obj-new-b> <time-prev1-b> <time-prev2-b> <orientation-b> <width-b> <bolt-b>))
  (preconds 
      (and
        (is-object <obj-1-b>)
	(is-object <obj-2-b>)
	(~ (joined <obj-1-b> <obj-1-b2> <or-b>))
	(~ (joined <obj-1-b2> <obj-1-b> <or-b>))
	(~ (joined <obj-2-b> <obj-2-b2> <or-b>))
	(~ (joined <obj-2-b2> <obj-2-b> <or-b>))
	(can-be-bolted <obj-1-b> <obj-2-b> <orientation-b>)
	(is-bolt <bolt-b>)
        (is-width <width-b> <bolt-b>)
	(has-hole <obj-1-b> <width-b> <orientation-b>)
	(has-hole <obj-2-b> <width-b> <orientation-b>)
        (last-scheduled <obj-1-b> <time-prev1-b>)
	(last-scheduled <obj-2-b> <time-prev2-b>)
        (later <time-b> <time-prev1-b>)
	(later <time-b> <time-prev2-b>)
        (idle BOLTING-MACHINE <time-b>)
        (composite-object <obj-new-b> <orientation-b> <obj-1-b> <obj-2-b>)))
  (effects (
     (del (last-scheduled <obj-1-b> <time-prev1-b>))
     (del (last-scheduled <obj-2-b> <time-prev2-b>))
     (add (last-scheduled <obj-new-b> <time-b>))
     (add (is-object <obj-new-b>))
     (del (is-object <obj-1-b>))
     (del (is-object <obj-2-b>))
     (add (joined <obj-1-b> <obj-2-b> <orientation-b>))
     (add (scheduled <obj-new-b> BOLTING-MACHINE <time-b>)))))


(WELD
  (params (<obj-1-w> <obj-2-w> <time-w> <obj-new-w> <time-prev1-w> <time-prev2-w> <orientation-w>))
  (preconds 
      (and
        (is-object <obj-1-w>)
	(is-object <obj-2-w>)
	(~ (joined <obj-1-w> <obj-1-w2> <or-w>))
	(~ (joined <obj-1-w2> <obj-1-w> <or-w>))
	(~ (joined <obj-2-w> <obj-2-w2> <or-w>))
	(~ (joined <obj-2-w2> <obj-2-w> <or-w>))
	(can-be-welded <obj-1-w> <obj-2-w> <orientation-w>)
        (last-scheduled <obj-1-w> <time-prev1-w>)
	(last-scheduled <obj-2-w> <time-prev2-w>)
        (later <time-w> <time-prev1-w>)
	(later <time-w> <time-prev2-w>)
        (idle WELDER <time-w>)
        (composite-object <obj-new-w> <orientation-w> <obj-1-w> <obj-2-w>)))
  (effects (
     (del (last-scheduled <obj-1-w> <time-prev1-w>))
     (del (last-scheduled <obj-2-w> <time-prev2-w>))
     (add (last-scheduled <obj-new-w> <time-w>))
     (del (temperature <obj-new-w> <temp-old*>))
     (add (temperature <obj-new-w> HOT))
     (add (is-object <obj-new-w>))
     (del (is-object <obj-1-w>))
     (del (is-object <obj-2-w>))
     (add (joined <obj-1-w> <obj-2-w> <orientation-w>))
     (add (scheduled <obj-new-w> WELDER <time-w>)))))


(SPRAY-PAINT
  (params (<obj-s> <time-s> <color-s> <time-prev-s>))
  (preconds
    (and
      (sprayable <color-s>)
      (is-object <obj-s>)
      (~ (joined <obj-s> <obj-s2> <or-s>))
      (~ (joined <obj-s2> <obj-s> <or-s>))
      (shape <obj-s> <shape-s-s>)
      (regular-shape <shape-s-s>)
      (clampable <obj-s> SPRAY-PAINTER)
      (last-scheduled <obj-s> <time-prev-s>)
      (later <time-s> <time-prev-s>)
      (idle SPRAY-PAINTER <time-s>)
      ))
  (effects (
    (add (painted <obj-s> <color-s>))
    (del (surface-condition <obj-s> <surface-*2-s>))
    (del (last-scheduled <obj-s> <time-prev-s>))
    (add (last-scheduled <obj-s> <time-s>))
    (add (scheduled <obj-s> SPRAY-PAINTER <time-s>)))))

(IMMERSION-PAINT
  (params (<obj-i> <time-i> <color-i> <time-prev-i>))
  (preconds
    (and
      (is-object <obj-i>)
      (~ (joined <obj-i> <obj-i2> <or-i>))
      (~ (joined <obj-i2> <obj-i> <or-i>))
      (have-paint-for-immersion <color-i>)
      (last-scheduled <obj-i> <time-prev-i>)
      (later <time-i> <time-prev-i>)
      (idle IMMERSION-PAINTER <time-i>)
      ))
  (effects (
    (add (painted <obj-i> <color-i>))
    (del (last-scheduled <obj-i> <time-prev-i>))
    (add (last-scheduled <obj-i> <time-i>))
    (add (scheduled <obj-i> IMMERSION-PAINTER <time-i>)))))
      




))


(setq *INFERENCE-RULES* '(


(IS-CLAMPABLE
  (params (<obj-1> <machine>))
  (preconds
    (and 
      (has-clamp <machine>)
      (temperature <obj-1> COLD)))
  (effects ((add (clampable <obj-1> <machine>)))))


  
(INFER-IDLE
  (params (<machine-1>  <time-t>))
  (preconds
     (forall (<obj-2> <machine-2>)
	     (scheduled <obj-2> <machine-2> <time-t>)
	     (not-equal <machine-2> <machine-1>)))
  (effects (
    (add (idle <machine-1> <time-t>)))))


))
