; Need to clean this up.  Clean distinction between keys, boxes and doors.
; Putdown-box also works for keys -- bad.

; oops - noticed by -- domain allows pushing an
; object through the door while your holding another.
; Screws up putdown...


;
; Modifications for abstraction creation:
; (NOTE: None of these modifications changes the semantics of the operators)
; 1) Added (del (next-to robot <object.o1>)) to preconditions of
;    PICKUP-OBJ.  This was implicit before, but addition of types
;    requires this to be done explicitly to create abstractions.
; 2) Replaced dr-to-rm with connects in every operator
; 3) Problem in operators that have holding in their preconditions.
;    Holding may be achieved first, then the goal of getting the held
;    object in the appropriate room comes along.  This may require
;    going through a locked door, which requires you are hold a key.
;    Thus, the robot will putdown the key it just picked up to achieve
;    hold and produce a state loop.  This will make some solvable
;    problems on unsolvable.  The solution is simply to move holding
;    after the inroom for the thing being held.  Also, added carriable
;    precondition to these since cariable is tested in pickup and
;    moving holding later means this gets tested later. 
;    Same thing happens with arm-empty predicate and door-open.  Moved
;    arm-empty after door-open.

(setq *OPERATORS* '(

    
(PICKUP-BOX
 (params (<box.o1>))
 (preconds
    (and (arm-empty) 
	 (next-to robot <box.o1>)
	 (carriable <box.o1>)))
 (effects ((del (arm-empty))
	   (del (next-to <box.o1> <box.*30>))
	   (del (next-to <box.o1> <door.*30>))
	   (del (next-to <box.*31> <box.o1>))
	   (del (next-to robot <box.o1>)) 
	   (add (holding <box.o1>)))))
    
(PICKUP-KEY
 (params (<key.o1>))
 (preconds
    (and (arm-empty) 
	 (next-to robot <key.o1>)
	 (carriable <key.o1>)))
 (effects ((del (arm-empty))
	   (del (next-to robot <key.o1>)) 
	   (add (holding <key.o1>)))))


(PUTDOWN-BOX
 (params (<box.o2>))
 (preconds (and (holding <box.o2>)
		(is-box <box.o2>)))
 (effects 
    ((del (holding <box.*35>))
     (add (next-to robot <box.o2>))
     (add (arm-empty)))))

(PUTDOWN-KEY
 (params (<key.o2>))
 (preconds (and (holding <key.o2>)
		(is-key <door.o2> <key.o2>)))
 (effects 
    ((del (holding <key.*35>))
     (add (next-to robot <key.o2>))
     (add (arm-empty)))))

(PUTDOWN-BOX-NEXT-TO
 (params (<box.o3> <box.other-ob> <room.o3-rm>))
 (preconds 
      (and (is-object <box.other-ob>)
	   (inroom <box.other-ob> <room.o3-rm>)
	   (inroom <box.o3> <room.o3-rm>)
	   (holding <box.o3>)
	   (next-to robot <box.other-ob>)))
 (effects 
    ((del (holding <box.o3>))
     (add (next-to <box.o3> <box.other-ob>))
     (add (next-to robot <box.o3>)) 
     (add (next-to <box.other-ob> <box.o3>))
     (add (arm-empty)))))



(PUSH-BOX-TO-DR
 (params (<box.b1> <door.d1> <room.r1>))
 (preconds
     (and (is-door <door.d1>)
	  (connects <door.d1> <room.r2> <room.r1>) ;added for abstraction
;	  (dr-to-rm <door.d1> <room.r1>)
	  (inroom <box.b1> <room.r1>)
	  (next-to robot <box.b1>)
	  (pushable <box.b1>)))
 (effects     
    ((del (next-to <box.b1> <box.*5>))
     (del (next-to <box.b1> <door.*5>))
     (del (next-to <box.*13> <box.b1>))
     (del (next-to robot <box.*3>))
     (add (next-to robot <box.b1>))
     (add (next-to <box.b1> <door.d1>)))))

(PUSH-BOX-THRU-DR
 (params (<box.b-x> <door.d-x> <room.r-x> <room.r-y>))
 (preconds 
     (and   
	  (is-room <room.r-x>)
	  (connects <door.d-x> <room.r-x> <room.r-y>) ; moved from below
;	  (dr-to-rm <door.d-x> <room.r-x>)
	  (is-door <door.d-x>)
	  (dr-open <door.d-x>)
	  (next-to <box.b-x> <door.d-x>)
	  (next-to robot <box.b-x>)
	  (pushable <box.b-x>)
;	  (connects <door.d-x> <room.r-x> <room.r-y>)
	  (inroom <box.b-x> <room.r-y>) 
	  ))
 (effects
  (
     (del (next-to robot <box.*1>)) 
     (del (next-to <box.b-x> <box.*12>)) 
     (del (next-to <box.b-x> <door.*12>)) 
     (del (next-to <box.*7> <box.b-x>))   
     (del (inroom robot <room.*21>))
     (del (inroom <box.b-x> <room.*22>))
     (add (inroom robot <room.r-x>))
     (add (inroom <box.b-x> <room.r-x>))
     (add (next-to robot <box.b-x>)))))

(GO-THRU-DR
 (params (<door.ddx> <room.rrx> <room.rry>))
 (preconds 
     (and (is-room <room.rrx>)
	  (connects <door.ddx> <room.rrx> <room.rry>) ; moved from below
;	  (dr-to-rm <door.ddx> <room.rrx>)
  	  (is-door <door.ddx>)
	  (dr-open <door.ddx>)
	  (arm-empty)
	  (next-to robot <door.ddx>)
;	  (connects <door.ddx> <room.rrx> <room.rry>)
	  (inroom robot <room.rry>)))
 (effects    
    (
     (del (next-to robot <door.*19>)) 
     (del (inroom robot <room.*20>))
     (add (inroom robot <room.rrx>)))))

(CARRY-BOX-THRU-DR
 (params (<box.b-zz> <door.d-zz> <room.r-zz> <room.r-ww>))
 (preconds 
     (and   
	  (is-room <room.r-zz>)
	  (connects <door.d-zz> <room.r-zz> <room.r-ww>) ; moved from below
;	  (dr-to-rm <door.d-zz> <room.r-zz>)
	  (is-door <door.d-zz>)
	  (dr-open <door.d-zz>)
	  (is-object <box.b-zz>)
;	  (connects <door.d-zz> <room.r-zz> <room.r-ww>)
	  (inroom <box.b-zz> <room.r-ww>)
	  (carriable <box.b-zz>)
	  (holding <box.b-zz>)
	  (inroom robot <room.r-ww>)
	  (next-to robot <door.d-zz>)))
 (effects
    (
     (del (next-to robot <door.*48>))  
     (del (inroom robot <room.*41>))
     (del (inroom <box.b-zz> <room.*42>))
     (add (inroom robot <room.r-zz>))
     (add (inroom <box.b-zz> <room.r-zz>)))))


(CARRY-KEY-THRU-DR
 (params (<key.b-zz> <door.d-zz> <room.r-zz> <room.r-ww>))
 (preconds 
     (and   
	  (is-room <room.r-zz>)
	  (connects <door.d-zz> <room.r-zz> <room.r-ww>) ; moved from below
;	  (dr-to-rm <door.d-zz> <room.r-zz>)
	  (is-door <door.d-zz>)
	  (dr-open <door.d-zz>)
	  (is-object <key.b-zz>)
;	  (connects <door.d-zz> <room.r-zz> <room.r-ww>)
	  (inroom <key.b-zz> <room.r-ww>)
	  (carriable <key.b-zz>)
	  (holding <key.b-zz>)
	  (inroom robot <room.r-ww>)
	  (next-to robot <door.d-zz>)))
 (effects
    (
     (del (next-to robot <door.*48>))  
     (del (inroom robot <room.*41>))
     (del (inroom <key.b-zz> <room.*42>))
     (add (inroom robot <room.r-zz>))
     (add (inroom <key.b-zz> <room.r-zz>)))))


(GOTO-DR
 (params (<door.dx> <room.rx>))
 (preconds 
     (and (is-door <door.dx>)
	  (connects <door.dx> <room.ry> <room.rx>) ; added for abstraction
;	  (dr-to-rm <door.dx> <room.rx>)
	  (inroom robot <room.rx>)))
 (effects 
    ((del (next-to robot <box.*18>))
     (del (next-to robot <door.*18>))
     (del (next-to robot <key.*18>))
     (add (next-to robot <door.dx>)))))



(PUSH-BOX
 (params (<box.ba> <box.bb> <room.ra>))
 (preconds
     (and (is-object <box.ba>)
	  (is-object <box.bb>)
	  (inroom <box.bb> <room.ra>)
	  (inroom <box.ba> <room.ra>)
	  (pushable <box.ba>)
 	  (next-to robot <box.ba>)))
 (effects
    ((del (next-to robot <box.*14>))
     (del (next-to <box.ba> <door.*5>))
     (del (next-to <box.ba> <box.*5>))
     (del (next-to <box.*6> <box.ba>))
     (add (next-to robot <box.ba>))
     (add (next-to robot <box.bb>))
     (add (next-to <box.ba> <box.bb>))
     (add (next-to <box.bb> <box.ba>))     
    )))




(GOTO-BOX
 (params (<box.b> <room.rm>))
 (preconds 
     (and 
	  (is-object <box.b>)
	  (inroom <box.b> <room.rm>)
	  (inroom robot <room.rm>)))
 (effects ((add (next-to robot <box.b>))
	   (del (next-to robot <box.*109>))
	   (del (next-to robot <door.*109>))
	   (del (next-to robot <key.*109>)))))


(GOTO-KEY
 (params (<key.b> <room.rm>))
 (preconds 
     (and 
	  (is-object <key.b>)
	  (inroom <key.b> <room.rm>)
	  (inroom robot <room.rm>)))
 (effects ((add (next-to robot <key.b>))
	   (del (next-to robot <box.*109>))
	   (del (next-to robot <door.*109>))
	   (del (next-to robot <key.*109>)))))


(OPEN
 (params (<door>))
 (preconds
     (and (is-door <door>)
	  (unlocked <door>)
	  (next-to robot <door>)
	  (dr-closed <door>)
	  ))
 (effects 
    ((del (dr-closed <door>))
     (add (dr-open <door>)))))

(CLOSE
 (params (<door.door1>))
 (preconds
     (and (is-door <door.door1>)
	  (next-to robot <door.door1>)
	  (dr-open <door.door1>)
	  ))
 (effects 
    ((del (dr-open <door.door1>))
     (add (dr-closed <door.door1>)))))


(LOCK
 (params (<door.door2> <key.k1> <room.rm-b>))
 (preconds
     (and (is-door <door.door2>)
	  (is-key <door.door2> <key.k1>)
	  (connects <door.door2> <room.rm-c> <room.rm-b>) ; added for abstraction
;	  (dr-to-rm <door.door2> <room.rm-b>)
	  (inroom <key.k1> <room.rm-b>)
	  (holding <key.k1>)
	  (next-to robot <door.door2>)
	  (dr-closed <door.door2>)
	  (unlocked <door.door2>)
	  ))
 (effects 
    ((del (unlocked <door.door2>))
     (add (locked <door.door2>)))))


(UNLOCK
 (params (<door.door3> <key.k2> <room.rm-a>))
 (preconds
     (and (is-door <door.door3>)
	  (is-key <door.door3> <key.k2>)
	  (connects <door.door3> <room.rm-d> <room.rm-a>) ;added for abstraction
;	  (dr-to-rm <door.door3> <room.rm-a>)
	  (inroom <key.k2> <room.rm-a>)
	  (holding <key.k2>)
	  (inroom robot <room.rm-a>)
	  (next-to robot <door.door3>)
	  (locked <door.door3>) 
	  ))
 (effects 
    ((del (locked <door.door3>))
     (add (unlocked <door.door3>)))))


		 ))

(setq *INFERENCE-RULES* nil)

