

(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES*
      '(

; Always work on the goals in the order they are generated
	(SELECT-FIRST-GOAL
	 (lhs (and (current-node <node>)
		   (list-of-candidate-goals <node> <goals>)
		   (is-first-goal <goal> <goals>)))
	 (rhs (select goal <goal>)))

	))

(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES*
       '(
;	(OPEN-DOOR-FROM-ROOM-YOU-ARE-IN
;	 (lhs (and (current-node <node>)
;		   (current-op <node> OPEN-DOOR)
;		   (candidate-bindings <node> (<door> <room>))
;		   (known <node> (in-room robot <room>))))
;	 (rhs (select bindings (<door> <room>))))

	(RESTRICT-LOCATIONS-FOR-PUTDOWN
	      (LHS (AND (current-node <node>)
		        (current-goal <node> (~ (HOLDING <block>)))
		        (current-op <node> PUT-DOWN)
		        (known <node> (at robot <rob-loc>))
		        (known <node> (next-to <rob-loc> <loc>))))
	      (RHS (select bindings (<block> <loc>))))

	))

(setq *SCR-NODE-REJECT-RULES*
       '(
; Don't try to use the same object to support itself.
	 (BLOCK-SUPPORT-RULE-1  
	    (lhs (and (candidate-node <node>)
		      (candidate-goal <node> (at <obj> <loc1>))
		      (on-goal-stack <node> (at <obj> <loc2>))
			;  DONT really need KNOWN test
		      (known <node> (under-loc <loc1> <loc2>))))
	    (rhs (reject node <node>)))
	 ))
(setq *SCR-GOAL-REJECT-RULES* 
	'(
	 (DONT-GO-3D 
 	    (LHS (AND (current-node <node>)
	    	      (candidate-goal <node> (at robot <loc>))
		      (~ (is-in-zero-plane <loc>))))
	    (RHS (reject goal (at robot <loc>))))
))

(setq *SCR-OP-REJECT-RULES*
      '(

; Don't use GO-THRU-DOOR as a way of getting AT a location.
	(DONT-GO-THRU-DOOR-TO-ACHIEVE-AT
	 (lhs (and (current-node <node>)
		   (current-goal <node> (at robot <loc>))
		   (candidate-op <node> GO-THRU-DOOR)))
	 (rhs (reject op GO-THRU-DOOR)))

; Dont ever try to putdown robot.  Its not possible.
	 (DONT-PUTDOWN-ROBOT
	  (lhs (and (current-node <node>)
		    (current-goal <node> (at robot <loc>))
		    (candidate-op <node> PUT-DOWN)))
	  (rhs (reject op PUT-DOWN)))
	))
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* 
      '(
	(TOWARDS
          (lhs (and (current-node <node>)
	 	    (current-op <node> MOVE)
	            (candidate-bindings <node> (<adj-sq2> <to-sq2>))
	            (candidate-bindings <node> (<adj-sq1> <to-sq1>))
	   	    (known <node>
			   (and (at robot <from-loc>)
	                        (distance <from-loc> <adj-sq1> <dis1>)
	                        (distance <from-loc> <adj-sq2> <dis2>)
	             		(less-than <dis1> <dis2>)))))
	  (rhs (prefer bindings (<adj-sq1> <to-sq1>)
	    	                (<adj-sq2> <to-sq2>))))

	(OPEN-DOOR-FROM-ROOM-YOU-ARE-IN
	 (lhs (and (current-node <node>)
		   (current-op <node> OPEN-DOOR)
		   (candidate-bindings <node> (<door> <rm1>))
		   (candidate-bindings <node> (<door> <rm2>))
		   (not-equal <rm1> <rm2>)
		   (known <node> (in-room robot <robot-rm>))
		   (is-equal <rm1> <robot-rm>)))
	 (rhs (prefer bindings (<door> <rm1>)
		               (<door> <rm2>))))
	))

