

; Operators for the new Jupiter domain. -- yg

; NOTE: changed so that all variables appear in the params list. -- yg

(setq *OPERATORS* 
'(
   (MOVE 
    (params (<pxi> <pyi> <px> <py>))
    (preconds (and 
		(at-prodigy <pxi> <pyi>)
		(force-to-move <px> <py> <pxi> <pyi>)))
    (effects (
		(del (at-prodigy <pxi> <pyi>))
	        (add (at-prodigy <px> <py>)))))
   

   (BUMP-OBJECT
;    (params (<object> <ox> <oy> <pxi> <pyi>))
    (params (<object> <ox> <oy> <pxi> <pyi> <oxi> <oyi> <px> <py>))
    (preconds (and 
		(at <object> <oxi> <oyi>)
		(is-sphere <object>)
		(force-to-bump <object> <pxi> <pyi> <oxi> <oyi> 
			       <ox> <oy> <px> <py>)
		(at-prodigy <pxi> <pyi>)))

    (effects (
		(del (at <object> <oxi> <oyi>))
     		(del (at-prodigy <pxi> <pyi>)) 
	      	(add (at <object> <ox> <oy>))
	      	(add (at-prodigy <px> <py>)))))

))



; Inference Rules for PRODIGY/JUPITER domain

(setq *INFERENCE-RULES*
'(


   (INFER-FORCE-TO-MOVE
     (params (<object> <px> <py> <pxi> <pyi> <rad-prod> 
	      <lin-visc> <t-step> <upd-cycle> <th-f-time> <fx> <fy>))
     (preconds (and
		(linear-viscosity <lin-visc>)
		(radius prodigy <rad-prod>)
		(radius <object> <rad-obj>)
		(timestep <t-step>)
		(upd-per-cycle <upd-cycle>)
		(theo-f-ap-time <th-f-time>)
		(calculate-force-to-move <px> <py> <pxi> <pyi> <rad-prod> 
		       <lin-visc> <t-step> <upd-cycle> <th-f-time> <fx> <fy>)))
      (effects (
	 	(add (force-to-move <px> <py> <pxi> <pyi>)))))


    (INFER-POINT-BEFORE-BUMPING
     (params (<object> <oxi> <oyi> <ox> <oy>
	      <rad-prod> <rad-obj> <pxi> <pyi>))
     (preconds (and 
		(radius prodigy <rad-prod>)
		(radius <object> <rad-obj>)
		(calculate-point-before-bumping <oxi> <oyi> <ox> <oy>
			        <rad-prod> <rad-obj> <pxi> <pyi>)))
     (effects (
		(add (point-before-bumping <object> <oxi> <oyi> 
				<ox> <oy> <pxi> <pyi>)))))



    (INFER-FORCE-TO-BUMP
     (params (<object> <pxi> <pyi> <oxi> <oyi> <ox> <oy> 
	      <rad-prod> <rad-obj> <lin-visc> 
	      <t-step> <upd-cycle> <th-f-time>
	      <mass-prod> <mass-obj> <elast-prod> 
	      <elast-obj> <rest-prod> <rest-obj> 
	      <px> <py> <fx> <fy>))
     (preconds (and 
		(point-before-bumping <object> 
				      <oxi> <oyi> <ox> <oy> <pxi> <pyi>)
		(radius prodigy <rad-prod>)
		(radius <object> <rad-obj>)
		(linear-viscosity <lin-visc>)
		(mass prodigy <mass-prod>)
		(mass <object> <mass-obj>)
		(modul-elast prodigy <elast-prod>)
		(modul-elast <object> <elast-obj>)
		(coeff-resti prodigy <rest-prod>)
		(coeff-resti <object> <rest-obj>)
		(timestep <t-step>)
		(upd-per-cycle <upd-cycle>)
		(theo-f-ap-time <th-f-time>)
		(calculate-force-to-bump <pxi> <pyi> <oxi> <oyi> <ox> <oy> 
				<rad-prod> <rad-obj> <lin-visc> 
				<t-step> <upd-cycle> <th-f-time>
		     		<mass-prod> <mass-obj> <elast-prod> 
				<elast-obj> <rest-prod> <rest-obj> 
				<px> <py> <fx> <fy>)))
     (effects(
		(add (force-to-bump <object> <pxi> <pyi> <oxi> <oyi> 
				<ox> <oy> <px> <py>)))))

))
