(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)

(setq *SCR-BINDINGS-REJECT-RULES* nil)

(setq *SCR-BINDINGS-SELECT-RULES*

;;;
;;; FORCE-ORDERED-VOICE-BINDINGS
;;; Use existing pitch bindings for inferring ordered voices.  If they are
;;; out of order, this forces a subgoal of using these pitches instead of
;;; considering every possible combination of valid pitches.  It is very
;;; probable that a solution exists without considering pitches other than
;;; these two, and if not, there will be another path to that solution that
;;; doesn't involve such a large branching factor.
;;;
'(
(FORCE-ORDERED-VOICE-BINDINGS
 (lhs (and (current-node <node>)
	       (current-goal <node>
						 (voices-ordered <pchord> <voice1> <voice2>))
	       (current-op <node> INFER-VOICES-ORDERED)
	       (known <node> (pitch <pchord> <voice1> <note1> <octave1>))
	       (known <node> (pitch <pchord> <voice2> <note2> <octave2>))))
 (rhs (select bindings (<pchord> <voice1> <note1> <octave1>
								 <voice2> <note2> <octave2>))))
	
;;;
;;; EXCHANGE-OUT-OF-ORDER-NOTES
;;; In looking at the goal stack, it can be seen that the reason we cur-
;;; rently want a new pitch is because of two notes being out of order.
;;; The remedy for this situation is simply to exchange those two notes.
;;;
(EXCHANGE-OUT-OF-ORDER-NOTES
 (lhs (and (current-node <node>)
	       (current-goal <node>
						 (pitch <pchord> <voice1> <note> <octave>))
	       (current-op <node> EXCHANGE-NOTES)
	       (direct-supergoal-of <node>
								(pitch <pchord> <voice1>
									   <note> <octave>)
								(voices-ordered <pchord>
												<voice1> <voice2>))))
 (rhs (select bindings (<pchord> <voice1> <voice2>))))
	
;;;
;;; CHOOSE-REQUIRED-CHORD-TONE
;;; In looking at the goal stack, it can be seen that the reason we cur-
;;; rently want a new pitch is because a particular chord tone (ie. root,
;;; third, or fifth) is missing from a chord.  We want the correct tone
;;; to be picked rather than any note in the chord, so force the particu-
;;; set of bindings to make that happen.
;;;
(CHOOSE-REQUIRED-CHORD-TONE
 (lhs (and (current-node <node>)
	       (current-goal <node>
						 (pitch <pchord> <voice> <note> <octave>))
	       (current-op <node> ADD-TONE)
	       (direct-supergoal-of <node>
								(pitch <pchord> <voice>
									   <note> <octave>)
								(has-tone <pchord> <tone>))))
 (rhs (select bindings (<pchord> <voice> <tone> <octave>))))
	
;;;
;;; FIX-ONE-FOR-SINGLE-PART
;;; If a particular chord in the progression is found to have more than
;;; one note for a given voice, the extra note or notes must be removed.
;;; This control rule picks the note to keep.  For example, if soprano
;;; has both an A 3 and a C 4 for a chord, without this rule, the possi-
;;; bilities would be: get rid of A 3, get rid of C 4, get rid of both
;;; and add E 4, get rid of both and add E 3, get rid of both and add
;;; C 3, etc.  All we want to do is throw away extras, so keep one and
;;; throw away the rest.
;;;
(FIX-ONE-FOR-SINGLE-PART
 (lhs (and (current-node <node>)
	       (current-goal <node> (single-part <pchord> <voice>))
	       (current-op <node> INFER-SINGLE-PART)
	       (known <node> (pitch <pchord> <voice> <note> <octave>))))
 (rhs (select bindings (<pchord> <voice> <note> <octave>))))
	
;;;
;;; FIX-ONE-FOR-SMALL-SKIP
;;; If there are more than five semitones between two chords in a parti-
;;; cular voice line, it must be corrected.  Instead of considering all
;;; the various possibilities of valid pairs of notes that are within a 
;;; small skip of each other, we will make the bindings so that the first
;;; is correct, reducing the number of subgoaling possibilities in getting
;;; a valid second note.
;;;
(FIX-ONE-FOR-SMALL-SKIP
 (lhs (and (current-node <node>)
	       (current-goal <node>
						 (small-skip <pchord1> <pchord2> <voice>))
	       (current-op <node> INFER-SMALL-SKIP)
	       (known <node> (pitch <pchord1> <voice> <note> <octave>))))
 (rhs (select bindings (<pchord1> <voice> <note> <octave>))))
	
;;;
;;; FIX-ONE-FOR-VOICES-NOT-OVERLAPPED
;;; If voices between successive chords overlap (eg. the alto in the first
;;; chord is higher than the soprano in the second), it must be corrected.
;;; Instead of considering all the various possibilities of valid pairs of
;;; notes that are non-overlapping, we will make the bindings so that the
;;; first is correct, reducing the number of subgoaling possibilities in
;;; getting a valid second note.
;;;
        (FIX-ONE-FOR-VOICES-NOT-OVERLAPPED
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(voices-not-overlapped <pchord1> <pchord2>
		 <voice1> <voice2>))
	       (current-op <node> INFER-VOICES-NOT-OVERLAPPED)
	       (known <node> (pitch <pchord1> <voice1> <note> <octave>))))
	 (rhs (select bindings (<pchord1> <pchord2> <voice1> <voice2>
				<note> <octave>))))
	
;;;
;;; FIX-SOPRANO-FOR-DISSIMILAR-MOTION
;;; If all voices between successive chords move in the same direction,
;;; either all up or all down, it must be corrected.  Instead of consider-
;;; ing all the various possibilities of valid pairs of notes that move
;;; correctly, we will make the bindings so that the soprano is correct,
;;; reducing the number of subgoaling possibilities.  This is reasonable
;;; because it is intended that problems in this domain generally have a
;;; fixed soprano line for a goal.
;;;
        (FIX-SOPRANO-FOR-DISSIMILAR-MOTION
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(dissimilar-motion <pchord1> <pchord2>))
	       (current-op <node> INFER-DISSIMILAR-MOTION)
	       (known <node> (pitch <pchord1> soprano <note1> <octave1>))
	       (known <node> (pitch <pchord2> soprano <note2> <octave2>))))
	 (rhs (select bindings (<pchord1> <note1> <octave1>
				<pchord2> <note2> <octave2>))))
	
;;;
;;; FIX-TWO-FOR-NO-PARALLEL-OCTAVE
;;; If a pair of voices between successive chords are a multiple of an
;;; octave apart in both chords, it must be corrected.  Instead of consider-
;;; ing all the various possibilities of valid pairs of notes that are
;;; correct, we will make the bindings so that the pair of notes in the
;;; first chord is correct, reducing the number of subgoaling possibilities
;;; in finding a valid pair of notes in the second chord.
;;;
        (FIX-TWO-FOR-NO-PARALLEL-OCTAVE
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(no-parallel-octave <pchord1> <pchord2>
		 <voice1> <voice2>))
	       (current-op <node> INFER-NO-PARALLEL-OCTAVE)
	       (known <node> (pitch <pchord1> <voice1>
			      <note1> <octave1>))
	       (known <node> (pitch <pchord1> <voice2>
			      <note2> <octave2>))))
	 (rhs (select bindings (<pchord1> <pchord2>
				<voice1> <note1> <octave1>
				<voice2> <note2> <octave2>))))
	
;;;
;;; FIX-TWO-FOR-NO-PARALLEL-FIFTH
;;; If a pair of voices between successive chords are a fifth (or varia-
;;; tion of a fifth such as a 12th) apart in both chords, it must be
;;; corrected.  Instead of considering all the various possibilities of
;;; valid pairs of notes that are correct, we will make the bindings so
;;; that the pair of notes in the first chord is correct, reducing the
;;; number of subgoaling possibilities in finding a valid pair of notes
;;; in the second chord.
;;;
        (FIX-TWO-FOR-NO-PARALLEL-FIFTH
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(no-parallel-fifth <pchord1> <pchord2>
		 <voice1> <voice2>))
	       (current-op <node> INFER-NO-PARALLEL-FIFTH)
	       (known <node> (pitch <pchord1> <voice1>
			      <note1> <octave1>))
	       (known <node> (pitch <pchord1> <voice2>
			      <note2> <octave2>))))
	 (rhs (select bindings (<pchord1> <pchord2>
				<voice1> <note1> <octave1>
				<voice2> <note2> <octave2>))))
	
;;;
;;; FIX-TWO-FOR-NO-DIRECT-OCTAVE
;;; If a pair of voices between successive chords both move in the same
;;; direction by more than a whole tone to reach an interval that is
;;; a multiple of an octave apart, it must be corrected.  Instead of
;;; considering all the various possibilities of valid pairs of notes
;;; that are correct, we will make the bindings so that the pair of
;;; notes in the first chord is correct, reducing the number of subgoal-
;;; ing possibilities in finding a valid pair of notes in the second chord.
;;;
        (FIX-TWO-FOR-NO-DIRECT-OCTAVE
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(no-direct-octave <pchord1> <pchord2>
		 <voice1> <voice2>))
	       (current-op <node> INFER-NO-DIRECT-OCTAVE)
	       (known <node> (pitch <pchord1> <voice1>
			      <note1> <octave1>))
	       (known <node> (pitch <pchord1> <voice2>
			      <note2> <octave2>))))
	 (rhs (select bindings (<pchord1> <pchord2>
				<voice1> <note1> <octave1>
				<voice2> <note2> <octave2>))))
	
;;;
;;; USE-EXISTING-TONE-FOR-VOICE
;;; Each voice must have a note in each chord.  When inferring that this
;;; is true using INFER-PART, bind the voice's note in the chord in ques-
;;; tion if it exists.  It is possible that a note exists for a voice but
;;; it could be out of range.  Because the note is bound, subgoaling to
;;; get it into range will force transposition.  If this were not done,
;;; it would be much easier to clobber other harmony goals in trying to
;;; get it into range.
;;; 
        (USE-EXISTING-TONE-FOR-VOICE
	 (lhs (and (current-node <node>)
	       (current-op <node> INFER-PART)
	       (known <node> (pitch <pchord> <voice> <note> <octave>))))
	 (rhs (select bindings (<pchord> <voice> <note>))))
	
	
	))

(setq *SCR-GOAL-PREFERENCE-RULES* nil)

(setq *SCR-GOAL-REJECT-RULES* nil)

(setq *SCR-GOAL-SELECT-RULES* 
      
;;;
;;; SELECT-FIRST-GOAL
;;; This is the default goal selection rule taken from the blocksworld
;;; domain.  It selects the primary candidate goal.
;;;
      '((SELECT-FIRST-GOAL
	 (lhs (and (current-node <node>)
	       (not-top-level-node <node>)
	       (primary-candidate-goal <node> <goal>)))
	 (rhs (select goal <goal>)))
	
	))

(setq *SCR-NODE-PREFERENCE-RULES* nil)
     
(setq *SCR-NODE-REJECT-RULES* nil)

(setq *SCR-NODE-SELECT-RULES* nil)

(setq *SCR-OP-PREFERENCE-RULES*
      
;;;
;;; PREFER-COPIED-VOICE-TO-ADDED-VOICE
;;; When successive chords share common notes, it is preferable to copy a
;;; note in a particular voice of the first chord to the same note in the
;;; same voice of the second chord.  This is preferred to just randomly
;;; picking a note for a voice in the second chord.
;;;
      '((PREFER-COPIED-VOICE-TO-ADDED-VOICE
	 (priority 0)
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(pitch <pchord2> <voice> <note2> <octave2>))
	       (candidate-op <node> COMMON-TONE-COPY)
	       (candidate-op <node> ADD-VOICE)
	       (known <node> (follows <pchord1> <pchord2>))
	       (known <node> (pitch <pchord1> <voice> <note1> <octave1>))))
	 (rhs (prefer operator COMMON-TONE-COPY ADD-VOICE)))
	
;;;
;;; PREFER-NEAREST-VOICE-TO-ADDED-VOICE
;;; When successive chords do not share common notes, it is preferable to
;;; pick a note in the second chord which is close to a note in the same
;;; voice of the first chord.  This is preferred to just randomly picking
;;; a note for a voice in the second chord.
;;;
        (PREFER-NEAREST-VOICE-TO-ADDED-VOICE
	 (priority 0)
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(pitch <pchord2> <voice> <note2> <octave2>))
	       (candidate-op <node> NEAREST-TONE-COPY)
	       (candidate-op <node> ADD-VOICE)
	       (known <node> (follows <pchord1> <pchord2>))
	       (known <node> (pitch <pchord1> <voice> <note1> <octave1>))))
	 (rhs (prefer operator NEAREST-TONE-COPY ADD-VOICE)))

;;;
;;; EXCHANGE-FOR-OUT-OF-ORDER-NOTES
;;; If the goal stack indicates that the reason we want a new pitch is
;;; because two notes are out of order, the preferred method of getting
;;; them into order is to exchange them by using the EXCHANGE-NOTES
;;; operator.
;;;
        (PREFER-EXCHANGE-FOR-OUT-OF-ORDER-NOTES
	 (priority 0)
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(pitch <pchord> <voice1> <note> <octave>))
	       (candidate-op <node> EXCHANGE-NOTES)
	       (candidate-op <node> <op>)
	       (not-equal EXCHANGE-NOTES <op>)
	       (direct-supergoal-of <node>
		(pitch <pchord> <voice1> <note> <octave>)
		(voices-ordered <pchord> <voice1> <voice2>))))
	 (rhs (prefer operator EXCHANGE-NOTES <op>)))
	
	))

(setq *SCR-OP-REJECT-RULES*
      
;;;
;;; DONT-EXCHANGE-NONEXISTENT-VOICE
;;; If the current goal is to add a pitch, don't do so by trying to
;;; exchange two existing pitches if no pitches exist.  Subgoaling
;;; to get two pitches to exchange is taking the long route to a
;;; solution.
;;;
      '((DONT-EXCHANGE-NONEXISTENT-VOICE
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(pitch <pchord> <voice> <note1> <octave1>))
	       (candidate-op <node> EXCHANGE-NOTES)
	       (known <node>
		(~ (pitch <pchord> <voice> <note2> <octave2>)))))
	 (rhs (reject operator EXCHANGE-NOTES)))
	
;;;
;;; DONT-TRANSPOSE-NONEXISTENT-VOICE
;;; If the current goal is to add a pitch, don't do so by trying to
;;; transpose a non-existent pitch.  Subgoaling to get a pitch to trans-
;;; pose is taking the long route to a solution.
;;;
        (DONT-TRANSPOSE-NONEXISTENT-VOICE
	 (lhs (and (current-node <node>)
	       (current-goal <node>
		(pitch <pchord> <voice> <note1> <octave1>))
	       (candidate-op <node> TRANSPOSE)
	       (known <node>
		(~ (pitch <pchord> <voice> <note2> <octave2>)))))
	 (rhs (reject operator TRANSPOSE)))
	
;;;
;;; DONT-INVERT-DOWN-PARTIAL-CHORD
;;; INVERT-CHORD-DOWN is a valuable operator for getting pitches into
;;; the middle of the proper range or for dealing with similar motion.
;;; However, it is not useful if voices are missing from the chord.
;;; Subgoaling to get pitches to invert is taking the long route to a
;;; solution.
;;;
        (DONT-INVERT-DOWN-PARTIAL-CHORD
	 (lhs (and (current-node <node>)
	       (or (current-goal <node> (pitch <pchord> <voice1>
					       <note1> <octave1>))
		(current-goal <node> (~ (pitch <pchord> <voice1>
					       <note1> <octave1>))))
	       (candidate-op <node> INVERT-CHORD-DOWN)
	       (or (known <node>
		    (~ (pitch <pchord> soprano <s-note> <s-octave>)))
		(known <node>
		 (~ (pitch <pchord> alto <a-note> <a-octave>)))
		(known <node>
		 (~ (pitch <pchord> tenor <t-note> <t-octave>)))
		(known <node>
		 (~ (pitch <pchord> bass <b-note> <b-octave>))))))
	 (rhs (reject operator INVERT-CHORD-DOWN)))
	
;;;
;;; DONT-INVERT-UP-PARTIAL-CHORD
;;; INVERT-CHORD-UP is a valuable operator for getting pitches into
;;; the middle of the proper range or for dealing with similar motion.
;;; However, it is not useful if voices are missing from the chord.
;;; Subgoaling to get pitches to invert is taking the long route to a
;;; solution.
;;;
        (DONT-INVERT-UP-PARTIAL-CHORD
	 (lhs (and (current-node <node>)
	       (or (current-goal <node> (pitch <pchord> <voice1>
					       <note1> <octave1>))
		(current-goal <node> (~ (pitch <pchord> <voice1>
					       <note1> <octave1>))))
	       (candidate-op <node> INVERT-CHORD-UP)
	       (or (known <node>
		    (~ (pitch <pchord> soprano <s-note> <s-octave>)))
		(known <node>
		 (~ (pitch <pchord> alto <a-note> <a-octave>)))
		(known <node>
		 (~ (pitch <pchord> tenor <t-note> <t-octave>)))
		(known <node>
		 (~ (pitch <pchord> bass <b-note> <b-octave>))))))
	 (rhs (reject operator INVERT-CHORD-UP)))
	
;;;
;;; REJECT-DOUBLE-WHEN-CHORD-INCOMPLETE
;;; Since there are four voices per chord and only three notes per chord,
;;; at least one of the notes must be doubled.  However, if less than three
;;; voices in the chord have been assigned a note, it does not make sense
;;; to assign a voice a new note by doubling an existing note since there
;;; must be at least one unassigned note.  Therefore, DOUBLE-VOICE is
;;; rejected in this case.
;;;
(REJECT-DOUBLE-WHEN-CHORD-INCOMPLETE
 (lhs (and (current-node <node>)
	       (current-goal <node>
						 (pitch <pchord> <voice> <note> <octave>))
	       (candidate-op <node> DOUBLE-VOICE)
	       (or (and (known <node> (~ (pitch <pchord> soprano
											<s-note> <s-oct>)))
					(known <node> (~ (pitch <pchord> alto
											<a-note> <a-oct>))))
			   (and (known <node> (~ (pitch <pchord> soprano
											<s-note> <s-oct>)))
					(known <node> (~ (pitch <pchord> tenor
											<t-note> <t-oct>))))
			   (and (known <node> (~ (pitch <pchord> soprano
											<s-note> <s-oct>)))
					(known <node> (~ (pitch <pchord> bass
											<b-note> <b-oct>))))
			   (and (known <node> (~ (pitch <pchord> alto
											<a-note> <a-oct>)))
					(known <node> (~ (pitch <pchord> tenor
											<t-note> <t-oct>))))
			   (and (known <node> (~ (pitch <pchord> alto
											<a-note> <a-oct>)))
					(known <node> (~ (pitch <pchord> bass
											<b-note> <b-oct>))))
			   (and (known <node> (~ (pitch <pchord> tenor
											<t-note> <t-oct>)))
					(known <node> (~ (pitch <pchord> bass
											<b-note> <b-oct>)))))))
 (rhs (reject operator DOUBLE-VOICE)))
	
;;;
;;; REJECT-EXTRA-VOICE
;;; If the goal stack indicates that we are trying to achieve a single
;;; part for a particular voice in a chord, reject all operators that
;;; add another voice to the chord since this runs counter to what we
;;; are trying to accomplish.
;;;
(REJECT-EXTRA-VOICE
 (lhs (and (current-node <node>)
	       (primary-candidate-goal <node>
								   (pitch <pchord> <voice> <note> <octave>))
	       (direct-supergoal-of <node>
								(pitch <pchord> <voice> <note> <octave>)
								(single-part <pchord> <voice>))
	       (candidate-op <node> <op>)))
 (rhs (reject operator <op>)))
	
	))

(setq *SCR-OP-SELECT-RULES*

`(

;;;
;;; TRANSPOSE-NOTE-OUT-OF-RANGE
;;; If the goal stack indicates that a new pitch is needed so that we can
;;; get a particular voice into range, then the correct way of doing this
;;; is to transpose an existing note for that voice.
;;;
(TRANSPOSE-NOTE-OUT-OF-RANGE
 (lhs (and (current-node <node>)
	       (current-goal <node> (pitch <pchord> <voice>
									   <note> <octave>))
	       (direct-supergoal-of <node>
								(pitch <pchord> <voice> <note> <octave>)
								(range-valid <pchord> <voice>))
	       (candidate-op <node> TRANSPOSE)))
 (rhs (select operator TRANSPOSE)))
	
;;;
;;; ADD-SHORT-SKIP-NOTE
;;; If the goal stack indicates that a new pitch is needed because a
;;; large skip was found between notes in successive chords, the most
;;; expedient way of handling this is to add a note which is within a
;;; small skip, knowing that the extraneous incorrect note will be removed
;;; later.
;;;
(ADD-SHORT-SKIP-NOTE
 (lhs (and (current-node <node>)
	       (current-goal <node> (pitch <pchord> <voice>
									   <note> <octave>))
	       (direct-supergoal-of <node>
								(pitch <pchord> <voice> <note> <octave>)
								(small-skip <pchord1> <pchord2>
											<voice>))
	       (candidate-op <node> ADD-VOICE)))
 (rhs (select operator ADD-VOICE)))
	
;;;
;;; ADD-MISSING-CHORD-TONE
;;; If the goal stack indicates that a new pitch is needed because a
;;; a chord tone (ie. root, third, or fifth) was missing, ADD-TONE is
;;; the correct operator to use to get it.
;;;
(ADD-MISSING-CHORD-TONE
 (lhs (and (current-node <node>)
	       (current-goal <node> (pitch <pchord> <voice>
									   <note> <octave>))
	       (direct-supergoal-of <node>
								(pitch <pchord> <voice> <note> <octave>)
								(has-tone <pchord> <tone>))
	       (candidate-op <node> ADD-TONE)))
 (rhs (select operator ADD-TONE)))
	
;;;
;;; DELETE-EXCESS-NOTE
;;; When it has been inferred that a chord has more than one note for a
;;; particular voice, extra notes must be deleted.  There are many opera-
;;; tors which delete notes, but all of them except for DELETE-VOICE also
;;; add them.  Therefore, if any operator other than DELETE-VOICE is
;;; used in this case, it will most likely introduce other problems from
;;; the new notes created.
;;;
(DELETE-EXCESS-NOTE
 (lhs (and (current-node <node>)
	       (current-goal <node> (~ (pitch <pchord> <voice>
										  <note> <octave>)))
	       (direct-supergoal-of <node>
								(~ (pitch <pchord> <voice>
										  <note> <octave>))
								(single-part <pchord> <voice>))
	       (candidate-op <node> DELETE-VOICE)))
 (rhs (select operator DELETE-VOICE)))
	
;;;
;;; ADD-ALTERNATE-NOTE-FOR-DIRECTS-AND-PARALLELS
;;; If the goal stack indicates that a new pitch is needed because a
;;; direct octave, direct fifth, parallel octave, or parallel fifth
;;; was found, the most expedient way of handling this is to add a
;;; note knowing that the extraneous incorrect note will be removed
;;; later.
;;;
        (ADD-ALTERNATE-NOTE-FOR-DIRECTS-AND-PARALLELS
	 (lhs (and (current-node <node>)
	       (current-goal <node> (pitch <pchord2> <voice>
				     <note> <octave>))
	       (or (direct-supergoal-of <node>
		    (pitch <pchord2> <voice>
			   <note> <octave>)
		    (no-direct-octave <pchord1>
				      <pchord2>
				      <voice1>
				      <voice2>))
		(direct-supergoal-of <node>
		 (pitch <pchord2> <voice>
			<note> <octave>)
		 (no-direct-fifth <pchord1>
				  <pchord2>
				  <voice1>
				  <voice2>))
		(direct-supergoal-of <node>
		 (pitch <pchord2> <voice>
			<note> <octave>)
		 (no-parallel-octave <pchord1>
				     <pchord2>
				     <voice1>
				     <voice2>))
		(direct-supergoal-of <node>
		 (pitch <pchord2> <voice>
			<note> <octave>)
		 (no-parallel-fifth <pchord1>
				    <pchord2>
				    <voice1>
				    <voice2>)))
	       (candidate-op <node> ADD-VOICE)))
	 (rhs (select operator ADD-VOICE)))
	
	))
