;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; AUthor : Tak Sinn
;;; Account: c473by
;;; Domain : typing
;;;
;;; I have written a lot of functions in order to simplify the
;;; job in solving the problem.
;;;
;;; Static Function to determine which hand should be used to
;;; type the key.
;;;
(defun leftorright (hand key)
  (cond ((or (is-variable hand)
	     (is-variable key)) 
	 'no-match-attempted)
	((eql hand 'left) (not (null (member key (lefthandkey)))))
	((eql hand 'right) (null (member key (lefthandkey))))))
 
;;;
;;; Function to return the left hand keys.
;;;
(defun lefthandkey ()
  '(a z q x s w c d e r f v b g t lshift tab 1 2 3 4 5 spc))

;;;
;;; Function to determine which finger should be used to type
;;; the key.
;;;
(defun isfinger (finger key)
  (cond ((or (is-variable finger)
	     (is-variable key))
	 'no-match-attempted)
	((equal finger 'thumb)
	 (thumb key))
	((equal finger 'index)
	 (if (index key) t nil))
	((equal finger 'middle)
	 (if (middle key) t nil))
	((equal finger 'ring)
	 (if (ring key) t nil))
	((equal finger 'pinky)
	 (if (pinky key) t nil))
	(t nil)))

;;;
;;; Function to return the what keys should thumb responsible for.
;;;
(defun thumb (key)
  (equal key 'spc))

;;;
;;; Function to return the what keys should index responsible for.
;;;
(defun index (key)
  (not (null (member key '(f g r t v b y u h j n m 5 6) :test #'equal))))

;;;
;;; Function to return the what keys should middle responsible for.
;;;
(defun middle (key)
  (not (null (member key '(e d c i k comma 3 8) :test #'equal))))

;;;
;;; Function to return the what keys should ring responsible for.
;;;
(defun ring (key)
  (not (null (member key '(w s x o l dot 2 9) :test #'equal))))

;;;
;;; Function to return the what keys should pinky responsible for.
;;;
(defun pinky (key)
  (not (null (member key '(q a z p semicolon slash lshift rshift 1 0)
                              :test #'equal))))

;;;
;;; Function to return the keys on bottom row.
;;;
(defun bottomrow ()
  '(z x c v b n m comma dot slash))

;;;
;;; Function to return the keys on top row.
;;;
(defun upperrow ()
  '(q w e r t y u i o p))

;;;
;;; Function to return the keys on middle row.
;;;
(defun middlerow ()
  '(a s d f g h j k l semicolon))

;;;
;;; Function to return the set of keys on is on the right side of
;;; left index finger and the right index finger.
;;;
(defun rightset ()
  '(t g b u j m ))

;;;
;;; Function to return the set of keys on is on the left side of
;;; left index finger and the right index finger.
;;;
(defun leftset ()
  '(r f v y h n ))

;;;
;;; Function to bind the old if it is varible to the (1- new)
;;; eg. if new = 1 then old is binded to 0
;;; returning a binding list of old.
;;; otherwise it check for old = new-1
;;;
(defun next-key (old new)
  (cond ((is-variable new) 'no-match-attempted)
	((is-variable old) '(((old (1- new)))))
	(t (= old (- new 1)))))

;;;
;;; Function to determine which motion operator should be
;;; used in order to type the key.
;;;
(defun positioning (key1 key2 direction)
  (cond ((or (is-variable key1) (is-variable key2))
	 'no-match-attempted)
	((equal direction 'left)
	 (not (null (member key1 (rightset)))))
	((equal direction 'right)
	 (not (null (member key1 (leftset)))))
	((equal direction 'up)
	 (checkup key1 key2))
	((equal direction 'down)
	 (checkdown key1 key2))
	))

;;;
;;; Function to determine whether key1 is above the current key2
;;;
(defun checkup (key1 key2)
  (cond ((not (null (member key1 (bottomrow))))
	 (if (or (not (null (member key2 (middlerow))))
		 (not (null (member key2 (upperrow)))))
	     t nil))
	((and (not (null (member key1 (middlerow))))
	      (not (null (member key2 (upperrow))))) t)
	(t nil)))

;;;
;;; Function to determine whether key1 is below the current key2
;;;
(defun checkdown (key1 key2)
  (cond ((not (null (member key1 (upperrow))))
	 (or (not (null (member key2 (middlerow)))) 
	     (not (null (member key2 (bottomrow)))))) 
	(t (and (not (null (member key1 (middlerow))))
		(not (null (member key2 (bottomrow))))))))

;;;
;;; Function to determine whether the caps-lock is on in order to
;;; match the case of the key.
;;;
(defun samecase (shiftkey keycase1)
  (cond ((or (is-variable shiftkey)
	     (is-variable keycase1)) 'no-match-attempted)
	((and (equal 'off keycase1) (equal 'lower shiftkey)) t)
	((and (equal 'on keycase1) (equal 'upper shiftkey)) t)))
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
