;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;
;;; Domain : Typing
;;;
;;; This domain show you the sequence to type a sentence on the
;;; keyboard. Just a real world problem typing class, learn how to type.
;;;
;;; STATIC PREDICATED ARE:
;;; 
;;;          (letter spc)
;;;          (letter dot)
;;;          (letter semicolon)
;;;          (letter z)
;;;          (letter y)
;;;          (letter x)
;;;          (letter w)
;;;          (letter v)
;;;          (letter u)
;;;          (letter t)
;;;          (letter s)
;;;          (letter r)
;;;          (letter q)
;;;          (letter p)
;;;          (letter o)
;;;          (letter n)
;;;          (letter m)
;;;          (letter l)
;;;          (letter k)
;;;          (letter j)
;;;          (letter i)
;;;          (letter h)
;;;          (letter g)
;;;          (letter f)
;;;          (letter e)
;;;          (letter d)
;;;          (letter c)
;;;          (letter b)
;;;          (letter a)
;;;          (presscap on off)
;;;          (presscap off on)
;;;          (capflag off)
;;;          (capflag on)
;;;          (istip ring)
;;;          (istip middle)
;;;          (istip index)
;;;          (istip thumb)
;;;          (istip pinky)
;;;          (ishand right) 
;;;          (ishand left)
;;;          (isfinger <finger> <key>)
;;;          (next-key <key1> <key2>)
;;;          (positioning <key1> <key2> direction)
;;;
;;; NON-STATIC PREDICATES
;;;
;;;          (cap-key off)
;;;          (on right index j)
;;;          (on right middle k)
;;;          (on right ring l)
;;;          (on right pinky semicolon)
;;;          (on right thumb spc)
;;;          (on left thumb spc)
;;;          (on left index f)
;;;          (on left middle d)
;;;          (on left ring s)
;;;          (on left pinky a)
;;;          (keyed 0)
;;;          (leftorright <hand> <key>)
;;;          (typed <shift> <key> <newkey>)
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Operators
;;;
;;; The followings are the operators in my domain.
;;;
;;;
(SETQ *OPERATORS* 
  '(
;;;
;;; The first one is the TYPE-USING.
;;; This is the operator to show how to type a key.
;;; It will subgoal on (cap-key) and (on) in order to acheive the
;;; goal on upper and lower case, and the motion of the hand.
;;; It will determine which finger to type and which hand to use.
;;;
    (TYPE-USING
     (params (<hand> <finger> <key> <newkey>))
     (preconds (and
		(letter <key>)              ;static generators
		(capflag <flag>)
		(samecase <shift> <flag>)   ;check cap lock
		(cap-key <flag>)
		(ishand <hand>)           
		(istip <finger>)
		(leftorright <hand> <key>)  ;check which hand
		(on <hand> <finger> <key>)  ;
		(keyed <oldkey>)
		(next-key <oldkey> <newkey>)
		))
     (effects  (
		(del (keyed <oldkey>))
		(add (keyed <newkey>))
		(add (typed <shift> <key> <newkey>)))))
    
;;;
;;; The followings are the operators to implement the motion
;;; of the finger and the hand in order to type the key.
;;;
;;; Move the <finger> up of the hand <hand>
;;;
    (MOVE-UP
     (params (<hand> <finger> <key>))
     (preconds (and
		(letter <key>)
		(ishand <hand>)
		(leftorright <hand> <key>)
		(on <hand> <finger> <oldkey>)
		(isfinger <finger> <key>)
		(positioning <oldkey> <key> up)
		))
     
     (effects  (
		(del (on <hand> <finger> <oldkey>))
		(add (on <hand> <finger> <key>)))))
    
;;;
;;; Move the <finger> down of the hand <hand>
;;;     
    (MOVE-DOWN
     (params (<hand> <finger> <key>))
     (preconds (and
		(letter <key>)
		(ishand <hand>)
		(leftorright <hand> <key>)
		(on <hand> <finger> <oldkey>)
		(isfinger <finger> <key>)
		(positioning <oldkey> <key> down)
		))
     (effects (
	       (del (on <hand> <finger> <oldkey>))
	       (add (on <hand> <finger> <key>)))))
    
;;;
;;; Move the <finger> left of the hand <hand>
;;;     
    (MOVE-LEFT
     (params (<hand> <finger> <key>))
     (preconds (and
		(letter <key>)
		(ishand <hand>)
		(leftorright <hand> <key>)
		(on <hand> <finger> <oldkey>)
		(isfinger <finger> <key>)
		(positioning <oldkey> <key> left)
		))
     (effects (
	       (del (on <hand> <finger> <oldkey>))
	       (add (on <hand> <finger> <key>)))))
;;;
;;; Move the <finger> right of the hand <hand>
;;;
    
    (MOVE-RIGHT
     (params (<hand> <finger> <key>))
     (preconds (and
		(letter <key>)
		(ishand <hand>)
		(leftorright <hand> <key>)
		(on <hand> <finger> <oldkey>)
		(isfinger <finger> <key>)
		(positioning <oldkey> <key> right)
		))
     (effects (
	       (del (on <hand> <finger> <oldkey>))
	       (add (on <hand> <finger> <key>)))))
    
;;;
;;; This is the operator to do the caps-lock when we are typing
;;; uppercase.
;;;
    (CAPS-LOCK
     (params (<flag>))
     (preconds (and
		(cap-key <off>)
		(presscap <off> <flag>)
		))
     (effects (
	       (del (cap-key <off>))
	       (add (cap-key <flag>)))))))
  
;;;
;;; there is no inference rule.
;;;
(SETQ *INFERENCE-RULES* nil) 
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

