;;;***********************************************
;;;
;;;          Test Problems
;;;***********************************************

(load-goal 
           '(and
                (with-embroidery RED COLLAR)     ;some embroidery on the collar of shirt
                (tag-attached-at BACK)           ;a tag at back of shirt
                (shirt-with-collar)              ;this is shirt with collar
                (with-buttons 1 GREEN)           ;has green buttons with diameter 1 cm.
            )      
)

(load-start-state
    '(

       ;; all the tools
       (is-tool  SEWING-MACHINE)                 
       (is-tool  EMBROIDERING-MACHINE)
       (is-tool  IRON)

       ;;all the necessary parts of the shirt
       (fabric-is fabA LEFT-SLEEVE)
       (size-of   fabA WIDTH  50)
       (size-of   fabA LENGTH 30)
       (free      fabA)

       (fabric-is fabB RIGHT-SLEEVE)
       (size-of   fabB WIDTH  60)
       (size-of   fabB LENGTH 90)
       (free      fabB)

       (fabric-is fabC BACK)
       (size-of   fabC WIDTH  100)
       (size-of   fabC LENGTH 100)
       (free      fabC)

       (fabric-is fabD LEFT-FRONT)
       (size-of   fabD WIDTH  55)
       (size-of   fabD LENGTH 85)
       (free      fabD)

       (fabric-is fabE RIGHT-FRONT)
       (size-of   fabE WIDTH 40)
       (size-of   fabE LENGTH 80)
       (free      fabE)

       (fabric-is fabF COLLAR)
       (size-of   fabF WIDTH  48)
       (size-of   fabF LENGTH 25)
       (free      fabF)


       ;; have more embroidering material than needed; let
       ;; prodigy choose the right one.
      
       (has thread1 EMBROIDERY-THREAD)
       (has thread2 EMBROIDERY-THREAD)
       (has thread3 EMBROIDERY-THREAD)
       (has thread4 EMBROIDERY-THREAD)

       (color-of thread1 RED)
       (color-of thread2 GREEN)
       (color-of thread3 BLACK)
       (color-of thread4 YELLOW)

       (has but1 BUTTONS)
       (has but2 BUTTONS)

       (size-of but1 DIAMETER 1)
       (size-of but2 DIAMETER 2)

       (color-of but2 BLUE)
       (color-of but1 GREEN)
       
     )
)


