;;;*******************************************************************
;;;
;;;  Test Problem: sew some GREEN embroidery on ther pocket and sew
;;;                the pocket on the right-front.
;;;
;;;  This problem tests if the goal (with-embroidery GREEN POCKET) will be selected
;;;  to be subgoaled on before the goal (with-option POCKET RIGHT-FRONT) is chosen.
;;;
;;;********************************************************************
(load-goal 
           '(and
                (with-option POCKET RIGHT-FRONT) ;has a pocket at right front of shirt
                (with-embroidery GREEN POCKET)   ;some green embroidery on the collar of shirt
            )      
)

(load-start-state
    '(

       ;; all the tools
       (is-tool  SEWING-MACHINE)                 
       (is-tool  EMBROIDERING-MACHINE)

       (fabric-is fabE RIGHT-FRONT)
       (size-of   fabE WIDTH 45)
       (size-of   fabE LENGTH 90)
       (free      fabE)

       (fabric-is fabF POCKET)
       (size-of   fabF WIDTH 35)
       (size-of   fabF LENGTH 90)
       (free      fabF)

       ;; have more embroidering material than needed; let
       ;; prodigy choose the right one.
      
       (has thread1 EMBROIDERY-THREAD)
       (has thread2 EMBROIDERY-THREAD)
       (has thread3 EMBROIDERY-THREAD)
       (has thread4 EMBROIDERY-THREAD)

       (color-of thread1 RED)
       (color-of thread2 GREEN)
       (color-of thread3 BLACK)
       (color-of thread4 YELLOW)
     )
)


