
(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)

(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)

(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)

;;;-----------------------------------------------------------------------------
;;;
;;; 
;;; All the control rules have one main purpose:  To control the goal ordering
;;;
;;;
;;;-----------------------------------------------------------------------------
;;;**************************************************************************
;;;
;;;          Search Control rules:  Goal Selection
;;;
;;;          Total of 4.
;;;**************************************************************************


(setq *SCR-GOAL-SELECT-RULES* '(

;;;
;;; SEW-BUTTONS-ON-POCKET-BEFORE-SEW-POCKET:
;;;
;;;    If the pocket is sewed onto the garment, buttons can not be added on it.
;;; So this rule ensures that the buttons is sewed onto the pocket first.
;;;

   (SEW-BUTTONS-ON-POCKET-BEFORE-SEW-POCKET
      (lhs  
           (and (current-node <node>)
                (candidate-goal <node> (with-option POCKET <any-pattern>))
                (candidate-goal <node> (pocket-with-buttons <diameter> <any-color>))
           )
      )
      (rhs
          (select goal (pocket-with-buttons <diameter> <any-color>))
      )
   )


;;;
;;; SEW-POCKET-BEFORE-SEW-SHIRTS:
;;;
;;;   The pocket should be sewed onto the specified part of the garment before
;;; that garment part is sewed with any other parts.  This rule ensures the
;;; proper sewing sequence is done.
;;;

   (SEW-POCKET-BEFORE-SEW-SHIRTS
      (lhs  
           (and (current-node <node>)
                (candidate-goal <node> (with-option POCKET <any-pattern>))
                (or (candidate-goal <node> (T-shirt))
                    (candidate-goal <node> (shirt-with-collar))
                )
           )
      )
      (rhs
          (select goal (with-option POCKET <any-pattern>))
      )
   )



;;;
;;; EMBROIDER-BEFORE-SEW-SHIRTS:
;;;
;;;   The embroidery should be sewed onto the specified part of the garment before
;;; that garment part is sewed with any other parts.  This rule ensures the
;;; proper sewing sequence is done.
;;; 

   (EMBROIDER-BEFORE-SEW-SHIRTS
      (lhs  
           (and (current-node <node>)
                (candidate-goal <node> (with-embroidery <color> <any-pattern>))
                (or (candidate-goal <node> (T-shirt))
                    (candidate-goal <node> (shirt-with-collar))
                )
           )
      )
      (rhs
          (select goal (with-embroidery <color> <any-pattern>))
      )
   )



;;; SEW-TAG-BEFORE-SEW-SHIRTS
;;;
;;;   The tag should be sewed onto the back of the garment before
;;; the back is sewed with any other parts.  This rule ensures the
;;; proper sewing sequence is done.
;;;

   (SEW-TAG-BEFORE-SEW-SHIRTS
      (lhs  
           (and (current-node <node>)
                (candidate-goal <node> (tag-attached-at BACK))
                (or (candidate-goal <node> (T-shirt))
                    (candidate-goal <node> (shirt-with-collar))
                )
           )
      )
      (rhs
          (select goal (tag-attached-at BACK))
      )
   )


))





;;;**************************************************************************
;;;
;;;          Search Control rules:  Goal preferences
;;;
;;;          Total of 5.
;;;**************************************************************************


;;;
;;; SEW-T-SHIRT-BEFORE-IRON-GARMENT: 
;;;
;;;    Before the garment can be ironed, the precondition (garment-ready)
;;; must be sastified. To satisfy (garment-ready), Prodigy might chose
;;; to subgoal on (shirt-with-collar) instead of (T-shirt).  This rule
;;; makes sure the proper subgoaling is chosen.
;;;

(setq *SCR-GOAL-PREFERENCE-RULES*  '(

   (SEW-T-SHIRT-BEFORE-IRON-GARMENT
      (lhs
           (and (current-node <node>)
                (candidate-goal <node> (garment-ironed))
                (candidate-goal <node> (T-shirt))
           )
      )
      (rhs
           (prefer goal (T-shirt) (garment-ironed))
      )
   )



;;;
;;; SEW-SHIRT-WITH-COLLAR-BEFORE-IRON-GARMENT: 
;;;
;;;    Before the garment can be ironed, the precondition (garment-ready)
;;; must be sastified. To satisfy (garment-ready), Prodigy might chose
;;; to subgoal on (T-shirt) instead of (shirt-with-collar).  This rule
;;; makes sure the proper subgoaling is chosen.
;;;

   (SEW-SHIRT-WITH-COLLAR-BEFORE-IRON-GARMENT
      (lhs
           (and (current-node <node>)
                (candidate-goal <node> (garment-ironed))
                (candidate-goal <node> (shirt-with-collar))
           )
      )
      (rhs
           (prefer goal (shirt-with-collar) (garment-ironed))
      )
   )



;;;
;;; EMBROIDER-BEFORE-SEW-POCKET:
;;;
;;;    This rule assures that if the goal (embroidery <any-color> POCKET)
;;; is fulfilled before the pocket is sewed onto the garment.
;;;

   (EMBROIDER-BEFORE-SEW-POCKET
      (lhs
           (and (current-node <node>)
                (candidate-goal <node> (with-embroidery <any-color> <pattern1>))
                (candidate-goal <node> (with-option POCKET <pattern2>))
           )
      )
      (rhs
           (prefer goal (with-embroidery <any-color> <pattern1>)
                        (with-option POCKET <pattern2>)
           )
      )
   )



;;;
;;; SEW-T-SHIRT-BEFORE-SEW-BUTTONS:
;;;
;;;    Since the buttons may only be sewed after the T-shirt is sewed; this 
;;; rule controls the appopriate sewing sequence.
;;;

   (SEW-T-SHIRT-BEFORE-SEW-BUTTONS
      (lhs  
           (and (current-node <node>)
                (candidate-goal <node> (with-buttons <diameter> <any-color>))
                (candidate-goal <node> (T-shirt))
           )
      )
      (rhs
          (prefer goal (T-shirt)
                       (with-buttons <diameter> <any-color>)
          )
      )
   )



;;;
;;; SEW-SHIRT-WITH-COLLAR-BEFORE-SEW-BUTTONS
;;;
;;;    Since the buttons may only be sewed after the shirt-with-collar is sewed; 
;;; this rule controls the appopriate sewing sequence.
;;;    

   (SEW-SHIRT-WITH-COLLAR-BEFORE-SEW-BUTTONS
      (lhs  
           (and (current-node <node>)
                (candidate-goal <node> (with-buttons <diameter> <any-color>))
                (candidate-goal <node> (shirt-with-collar))
           )
      )
      (rhs
          (prefer goal (shirt-with-collar)
                       (with-buttons <diameter> <any-color>)
          )
      )
  )
   


))
