;;;***********************************************
;;;
;;; Test Problem: sew a skirt with zipper.
;;;***********************************************

(load-goal 
        
        '(and
              (skirt)
              (skirt-with-zipper-of-length 15)
         )
)

(load-start-state
    '(

       ;; all the tools
       (is-tool  SEWING-MACHINE)                 
       (is-tool  EMBROIDERING-MACHINE)
       (is-tool  IRON)

       ;;all the necessary parts of the shirt
       (fabric-is fabA SKIRT-LEFT-FRONT)
       (size-of   fabA WIDTH  100)
       (size-of   fabA LENGTH 70)
       (free      fabA)

       (fabric-is fabB SKIRT-RIGHT-FRONT)
       (size-of   fabB WIDTH  60)
       (size-of   fabB LENGTH 90)
       (free      fabB)

       (fabric-is fabD SKIRT-LEFT-BACK)
       (size-of   fabD WIDTH  100)
       (size-of   fabD LENGTH 70)
       (free      fabD)

       (fabric-is fabE SKIRT-RIGHT-BACK)
       (size-of   fabE WIDTH  60)
       (size-of   fabE LENGTH 90)
       (free      fabE)

       (fabric-is fabF WAIST-BAND)
       (size-of   fabF WIDTH  70)
       (size-of   fabF LENGTH 25)
       (free      fabF)


       ;; have more embroidering material than needed; let
       ;; prodigy choose the right one.
      
       (has thread1 EMBROIDERY-THREAD)
       (has thread2 EMBROIDERY-THREAD)
       (has thread3 EMBROIDERY-THREAD)
       (has thread4 EMBROIDERY-THREAD)

       (color-of thread1 RED)
       (color-of thread2 GREEN)
       (color-of thread3 BLACK)
       (color-of thread4 YELLOW)

 

       (has zip1 ZIPPER)
       (has zip2 ZIPPER)
       (has zip3 ZIPPER)

       (zipper-len zip1 10)
       (zipper-len zip2 7)
       (zipper-len zip3 15)
       
     )
)







