;;;*********************************************************************
;;;
;;; Test Problem: sew a T-shirt with a front pocket. Iron the T-shirt
;;;               after done.
;;;
;;;
;;; This problem is similar to the problem T-shirt, only the goal ordering
;;; is different.
;;;
;;;*********************************************************************
(load-goal '(and 
                 (garment-ironed)              ; iron the garment.
                 (T-shirt)                     ; this is a T-shirt
                 (with-option POCKET FRONT)    ; with pocket at the front
            )

)

(load-start-state
    '(

       ;; Tools needed
       (is-tool SEWING-MACHINE)
       (is-tool IRON)
       
       ;; parts of T-shirt
       (fabric-is  fabA LEFT-SLEEVE)
       (size-of    fabA WIDTH  70)
       (size-of    fabA LENGTH 40)
       (free       fabA)

       (fabric-is  fabB RIGHT-SLEEVE)
       (size-of    fabB WIDTH  50)
       (size-of    fabB LENGTH 50)
       (free       fabB)

       (fabric-is  fabC BACK)
       (size-of    fabC WIDTH 60)
       (size-of    fabC LENGTH 82)
       (free       fabC)

       (fabric-is  fabF FRONT)
       (size-of    fabF WIDTH  100)
       (size-of    fabF LENGTH 80)
       (free       fabF)

       (fabric-is  fabG POCKET)
       (size-of    fabG WIDTH  40)
       (size-of    fabG LENGTH 20)
       (free       fabG)

     )
)
