;; -----------------------------------------------------------
;; -----------------------------------------------------------
;;
;;   Kristine Hauff -- c473al
;;   May 29, 1991
;;   Domain:  Sewing different articles of clothing
;;   File:  sc-rules.lisp, which lists all of the search
;;          control rules
;;
;; -----------------------------------------------------------
;; -----------------------------------------------------------


(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* '(
  (SELECT-FIRST-GOAL
    (lhs (and (current-node <node>)
              (not-top-level-node <node>)
              (primary-candidate-goal <node> <goal>)))
    (rhs (select goal <goal>)))
))

(setq *SCR-OP-SELECT-RULES* '(


;; --------------------
;; --------------------
;;  SELECT-TO-SEW-SHORTS allows Prodigy to choose from alternate sewing operators 
;;  for different garments in order to sew the specified garment.  From the shorts
;;  pattern it can start sewing shorts.

  (SELECT-TO-SEW-SHORTS
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-sewn <garment>))
	      (candidate-op <node> SEW-SHORTS)
	      (candidate-op <node> SEW-DRESS)
	      (candidate-op <node> SEW-SLEEVES-TO-BODICE)
	      (candidate-op <node> SEW-PANTS)
	      (candidate-op <node> SEW-SKIRT)
	      (known <node> (have-pattern <garment> SHORT-PATTERN))))
    (rhs (select operator SEW-SHORTS)))


;; --------------------
;; --------------------
;;  SELECT-TO-SEW-DRESS allows Prodigy to choose from alternate sewing operators 
;;  for different garments in order to sew the specified garment.  From the dress
;;  pattern it can start sewing a dress.

  (SELECT-TO-SEW-DRESS
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-sewn <garment>))
	      (candidate-op <node> SEW-SHORTS)
	      (candidate-op <node> SEW-DRESS)
	      (candidate-op <node> SEW-SLEEVES-TO-BODICE)
	      (candidate-op <node> SEW-PANTS)
	      (candidate-op <node> SEW-SKIRT)
	      (known <node> (have-pattern <garment> DRESS-PATTERN))))
    (rhs (select operator SEW-DRESS)))


;; --------------------
;; --------------------
;;  SELECT-TO-SEW-SHIRT allows Prodigy to choose from alternate sewing operators 
;;  for different garments in order to sew the specified garment.  From the shirt
;;  pattern it can start sewing a shirt.

  (SELECT-TO-SEW-SHIRT
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-sewn <garment>))
	      (candidate-op <node> SEW-SHORTS)
	      (candidate-op <node> SEW-DRESS)
	      (candidate-op <node> SEW-SLEEVES-TO-BODICE)
	      (candidate-op <node> SEW-PANTS)
	      (candidate-op <node> SEW-SKIRT)
	      (known <node> (have-pattern <garment> SHIRT-PATTERN))))
    (rhs (select operator SEW-SLEEVES-TO-BODICE)))

;; --------------------
;; --------------------
;;  SELECT-TO-SEW-PANTS allows Prodigy to choose from alternate sewing operators 
;;  for different garments in order to sew the specified garment.  From the pants
;;  pattern it can start sewing pants.


  (SELECT-TO-SEW-PANTS
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-sewn <garment>))
	      (candidate-op <node> SEW-SHORTS)
	      (candidate-op <node> SEW-DRESS)
	      (candidate-op <node> SEW-SLEEVES-TO-BODICE)
	      (candidate-op <node> SEW-PANTS)
	      (candidate-op <node> SEW-SKIRT)
	      (known <node> (have-pattern <garment> PANT-PATTERN))))
    (rhs (select operator SEW-PANTS)))

;; --------------------
;; --------------------
;;  SELECT-TO-SEW-SKIRT allows Prodigy to choose from alternate sewing operators 
;;  for different garments in order to sew the specified garment.  From the skirt
;;  pattern it can start sewing a skirt.


  (SELECT-TO-SEW-SKIRT
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-sewn <garment>))
	      (candidate-op <node> SEW-SHORTS)
	      (candidate-op <node> SEW-DRESS)
	      (candidate-op <node> SEW-SLEEVES-TO-BODICE)
	      (candidate-op <node> SEW-PANTS)
	      (candidate-op <node> SEW-SKIRT)
	      (known <node> (have-pattern <garment> SKIRT-PATTERN))))
    (rhs (select operator SEW-SKIRT)))

))

(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* '(


;; --------------------
;; --------------------
;;  USE-MACHINE-FOR-BUTTON-HOLES allows Prodigy to choose from alternate ways to
;;  make button holes.  Sewing and cutting out the button holes needs to be done
;;  by machine for bottom garments that need the extra durability.  The machine
;;  provides this durability more so than by hand.

  (USE-MACHINE-FOR-BUTTON-HOLES
    (lhs (and (current-node <node>)
	      (current-goal <node> (button-holes-cut <garment>))
	      (candidate-op <node> CUT-BUTTON-HOLES-BY-MACHINE)
	      (candidate-op <node> CUT-BUTTON-HOLES-BY-HAND)
 	      (or (known <node> (have-pattern <garment> SKIRT-PATTERN))
                  (known <node> (have-pattern <garment> SHORT-PATTERN))
                  (known <node> (have-pattern <garment> PANT-PATTERN)))))
    (rhs (reject operator CUT-BUTTON-HOLES-BY-HAND)))


;; --------------------
;; --------------------
;;  HAND-STITCH-BUTTON-HOLES allows Prodigy to choose from alternate ways to
;;  make button holes.  Hand stitching and cutting out the button holes needs
;;  to be done by hand for top garments and those that are a little more dressy.
;;  Hand stitching provides a better look more so than by machine.

  (HAND-STITCH-BUTTON-HOLES
    (lhs (and (current-node <node>)
	      (current-goal <node> (button-holes-cut <garment>))
	      (candidate-op <node> CUT-BUTTON-HOLES-BY-MACHINE)
	      (candidate-op <node> CUT-BUTTON-HOLES-BY-HAND)
	      (or (known <node> (have-pattern <garment> SHIRT-PATTERN))
                  (known <node> (have-pattern <garment> DRESS-PATTERN)))))
    (rhs (reject operator CUT-BUTTON-HOLES-BY-MACHINE)))


;; --------------------
;; --------------------
;;  USE-MACHINE-TO-HEM allows Prodigy to choose from alternate ways to sew a
;;  hem.  Hemming by machine can be used for those garments, such as shorts
;;  and pants, where it does not matter if the hem shows or not.

  (USE-MACHINE-TO-HEM
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-hemmed <garment>))
	      (candidate-op <node> HEM-BY-MACHINE)
	      (candidate-op <node> HEM-BY-HAND)
	      (or (known <node> (have-pattern <garment> SHORT-PATTERN))
                  (known <node> (have-pattern <garment> PANT-PATTERN)))))
    (rhs (reject operator HEM-BY-HAND)))


;; --------------------
;; --------------------
;;  HAND-STITCH-HEMMING allows Prodigy to choose from alternate ways to sew a
;;  hem.  Hemming by hand can be used for dressier garments, such as a shirt,
;;  a skirt, and a dress, where it looks nicer if the hem does not show.
;;  Hand stitching provides a better look more so than by machine.

  (HAND-STITCH-HEMMING
    (lhs (and (current-node <node>)
	      (current-goal <node> (garment-hemmed <garment>))
	      (candidate-op <node> HEM-BY-MACHINE)
	      (candidate-op <node> HEM-BY-HAND)
	      (or (known <node> (have-pattern <garment> SHIRT-PATTERN))
	          (known <node> (have-pattern <garment> SKIRT-PATTERN))
                  (known <node> (have-pattern <garment> DRESS-PATTERN)))))
    (rhs (reject operator HEM-BY-MACHINE)))


;; --------------------
;; --------------------
;;  REJECT-STRAIGHT-SKIRT-FOR-DRESS allows Prodigy to reject sewing the bottom
;;  part of the dress as a straight skirt because it pulls on the top part of
;;  the garment too much to look nice.  Hence this eliminates A LOT of backtracking
;;  while trying to sew a dress.


  (REJECT-STRAIGHT-SKIRT-FOR-DRESS
    (lhs (and (current-node <node>)
	      (current-goal <node> (technique-completed <garment>))
	      (candidate-op <node> MAKE-GATHERS)
	      (candidate-op <node> MAKE-PLEATS)
	      (candidate-op <node> MAKE-STRAIGHT-BAND)
              (known <node> (have-pattern <garment> DRESS-PATTERN))))
    (rhs (reject operator MAKE-STRAIGHT-BAND)))


))

(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)


