;; -----------------------------------------------------------
;; -----------------------------------------------------------
;;
;;   Kristine Hauff -- c473al
;;   May 17, 1991
;;   Domain:  Sewing different articles of clothing
;;   File:  functions.lisp
;;
;; -----------------------------------------------------------
;; -----------------------------------------------------------


;; MATCHES compares a specified pattern to another pattern.

(defun matches (pattern pattern-given)
   (equal pattern pattern-given))


;; CALC-PATTERN-SIZE calculates the total size that a pattern will
;; take up given the size of the garment and the number of inches
;; that a pattern of size 1 would take up.  The total size is 
;; returned through the parameter result.

(defun calc-pattern-size (a b result)
  (cond  ((is-variable a)
          'no-match-attempted)                    
         ((is-variable b)
          'no-match-attempted)                    
         ((is-variable result)
          `(((,result ,(+ a (- b 1))))))))


;; CALC-NEW-FABRIC-AMOUNT subtracts the total size of the fabric
;; piece that is cut out (total size of the pattern from above) from
;; the amount of fabric available.

(defun calc-new-fabric-amount (a b result)
  (cond  ((is-variable a)
          'no-match-attempted)                    
         ((is-variable b)
          'no-match-attempted)                    
         ((is-variable result)
          `(((,result ,(- a b)))))))


;; GREATER-THAN compares two values and returns true if the first
;; parameter is greater than the second.

(defun greater-than (a b)
  (cond  ((is-variable a)
          'no-match-attempted)                    
         ((is-variable b)
          'no-match-attempted)                    
         (t (> a b))))
