; Operators

(setq *OPERATORS* '(


;; operator to perform an appropriate motion from a neutral to a left
(neutral-to-left
  (params (<m1> <m2>))
  (preconds (and (motion <m1> neutral <s1>)
                 (motion <m2> left <s2>)
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end neutral-to-left


;; operator to perform an appropriate motion from a neutral to a right
(neutral-to-right
  (params (<m1> <m2>))
  (preconds (and (motion <m1> neutral <s1>)
                 (motion <m2> right <s2>)
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end neutral-to-right


;; operator to perform an appropriate motion from a left to a neutral
(left-to-neutral
  (params (<m1> <m2>))
  (preconds (and (motion <m1> left <s1>)
                 (motion <m2> neutral <s2>)
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end left-to-neutral


;; operator to perform an appropriate motion from a right to a neutral
(right-to-neutral
  (params (<m1> <m2>))
  (preconds (and (motion <m1> right <s1>)
                 (motion <m2> neutral <s2>)
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end right-to-neutral


;; operator to perform an appropriate motion from a neutral to a neutral
(neutral-to-neutral
  (params (<m1> <m2>))
  (preconds (and (motion <m1> neutral <s1>)
                 (motion <m2> neutral <s2>)
                 (not-same <m1> <m2>)     ;keeps sequential motions different
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end neutral-to-neutral


;; operator to perform an appropriate motion from a left to a left
(left-to-left
  (params (<m1> <m2>))
  (preconds (and (motion <m1> left <s1>)
                 (motion <m2> left <s2>)
                 (not-same <m1> <m2>)     ;keeps sequential motions different
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end left-to-left


;; operator to perform an appropriate motion from a right to a right
(right-to-right
  (params (<m1> <m2>))
  (preconds (and (motion <m1> right <s1>)
                 (motion <m2> right <s2>)
                 (not-same <m1> <m2>)     ;keeps sequential motions different
                 (swap no)
            )
  )
  (effects ((del (swap no))
            (add (swap <s2>))
            (add (follows <m1> <m2>))
           )
  )
) ; end right-to-right


;; operators that modify partner orientations
(circle-left-partner-swap
  (params (<p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
  (preconds (and (mixing-ok)
                 (swap circle-left)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap circle-left))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p1> <p8> <p3> <p2> <p5> <p4> <p7> <p6>))
           )
  )
) ; end circle-left-partner-swap


(circle-right-partner-swap
  (params (<p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
  (preconds (and (mixing-ok)
                 (swap circle-right)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap circle-right))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p1> <p4> <p3> <p6> <p5> <p8> <p7> <p2>))
           )
  )
) ; end circle-right-partner-swap


(slide-through-partner-swap
  (params (<p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
  (preconds (and (mixing-ok)
                 (swap slide-through)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap slide-through))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p5> <p6> <p7> <p8> <p1> <p2> <p3> <p4>))
           )
  )
) ; end slide-through-partner-swap


(cross-through-partner-swap
  (params (<p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
  (preconds (and (mixing-ok)
                 (swap cross-through)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap cross-through))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p5> <p2> <p7> <p4> <p1> <p6> <p3> <p8>))
           )
  )
) ; end cross-through-partner-swap


(square-up-start  ; can only be the first step in a complete dance
  (params (<m1>))
  (preconds (and (swap begin)
                 (motion <m1> <d1> <s1>) ;start dance with any (d1) motion type
            )
  )
  (effects ((del (swap begin))
            (add (swap <s1>))
            (add (follows square-up-begin <m1>))
           )
  )
) ; end square-up-start


(square-up-finish  ; can only be the last step in a complete dance
  (params (<m2>))
  (preconds (and (swap no)
                 (motion <m1> <d1> <s1>)
                 (motion <m2> <d2> <s2>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((del (swap no))
            (add (swap end))
            (add (follows <m2> square-up-end))
           )
  )
) ; end square-up-finish


                 ))

(setq *INFERENCE-RULES* '(


(infer-end-with-original-partners
  (params nil)
  (preconds (partners 1 2 3 4 5 6 7 8)
  )
  (effects ((add (end-with-original-partners))
           )
  )
)


                 ))
