;
; Search Control Rules
;
; Eivind O. Sandstrand  cse473  Spring 1991
;
; This set of sc-rules is not complete, but represents a tentative and still
; helpful bunch of rules.
; Future changes might include adding more 'reject' and 'select' rules, which
; should even further enhance performance .


(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* '(

;
; Don't even bother trying taking something from a shelf which isn't there
;   Is here since prodigy will try to take something from a shelf before
;   looking at the floor
;
  (REJECT-TAKE-FROM-SHELF
   (lhs (and
	 (current-node <node>)
	 (candidate-op <node> TAKE-FROM-SHELF)
	 (known <node>
	  (and (~(holding <part>))
 	       (~(on-shelf <part> <any-shelf>))))))
   (rhs (reject operator TAKE-FROM-SHELF)))


;
; No sense in trying to put something down when nothing is held.
;   To make sure that prodigy doesn't attemp to place something in a room
;   without actually holding it.
;
  (REJECT-PUT-DOWN
   (lhs (and
	 (current-node <node>)
	 (current-op <node> PUT-DOWN)
	 (known <node>
	  (~(holding <anything>)))))
   (rhs (reject operator PUT-DOWN)))
))

(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* '(

;
; Run is better, since it takes less time...
;    Prodigy will first attempt to walk, but should rather check to see if
;    it could run.  (The timing might be added later)
;
  (PREFER-RUN-INSTEAD-OF-WALK
   (lhs (and 
	 (current-node <node>)
	 (candidate-op <node> WALK-TO)
	 (current-goal <node> (is-in-room robo <someroom>))
	 (known <node>
	  (or (~(holding <anything>))
	      (and (holding <something>)
		   (is-light <something>))))))
   (rhs (prefer operator RUN-TO WALK-TO)))

; 
; Pick up from floor rather than taking from a shelf
;    There are fewer parts in the shelves, and thus effort should not be
;    wasted when (statistically) there is a better chance of finding a 
;    particular part elsewhere.
;
 (PREFER-PICK-UP-INSTEAD-OF-TAKE-FROM-SHELF
   (lhs (and
	 (current-node <node>)
	 (candidate-op <node> TAKE-FROM-SHELF)
	 (current-goal <node> (holding <part>))
	 (known <node> (~(holding <anything>)))))
   (rhs (prefer operator PICK-UP TAKE-FROM-SHELF)))


;
; These rules result in the same, but have different causes.
;
;    If the goal is to not hold a part, put down will statistically be the
;    most likely right choice.
;
  (PREFER-PUT-DOWN-INSTEAD-OF-PUT-ON-SHELF
   (lhs (and
	 (current-node <node>)
	 (current-goal <node> (~(holding <part>)))
	 (known <node>
	  (and
	   (holding <part>)
	   (is-in-room robo <room>)))))
   (rhs (prefer operator PUT-DOWN PUT-ON-SHELF)))
;
;    Does the same as it's brother above, but if the goal is to place a
;    part in a specific room.
;
  (PREFER-PUT-DOWN-INSTEAD-OF-PUT-ON-SHELF
   (lhs (and
	 (current-node <node>)
	 (current-goal <node> (is-in-room <part> <room>))
	 (known <node>
	  (and 
	   (holding <part>)
	   (is-in-room robo <room>)))))
   (rhs (prefer operator PUT-DOWN PUT-ON-SHELF)))

))

(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)



