#|*****************************************************************************

      Rick Granberg    8632411    CSE 473 A    Spring 1991    Project 2 

*****************************************************************************|#




; Operators

(setq *OPERATORS* '(




;;;
;;;  If the given house does not have room1, has room2 and room2 has a free
;;;  wall to the North, place room1 to the North of room2.  Room1 will have
;;;  have an outer wall on the same side as does room2.  The length of this
;;;  outer wall will be updated.
;;;

(ADD-ROOM-TO-NORTH
 (params (<rambler> <room1> <room2> <inside> <outside> 
	  <side-length> <room-length> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room2>)
	        (~(has-room <rambler> <room1>))
	        (has-free-wall <room2> NORTH)

	        (direction <outside>)
	        (not-equal <outside> NORTH)
	        (not-equal <outside> SOUTH)
	        (has-outer-wall <room2> <outside>)

	        (direction <inside>)
	        (not-equal <inside> NORTH)
	        (not-equal <inside> SOUTH)
	        (not-equal <inside> <outside>)

                (room-length <room1> <room-length>)
	        (side-length <outside> <side-length>)
                (increment-length <side-length> <room-length> <new-length>)))

 (effects ((del (has-free-wall <room2> NORTH))

	   (del (side-length <outside> <side-length>))
	   (add (side-length <outside> <new-length>))

           (add (has-room <rambler> <room1>))
           (add (share-corner <room1> <room2> <outside>))
           (add (share-corner <room2> <room1> <outside>))
	   (add (has-outer-wall <room1> <outside>))
	   (add (has-free-wall <room1> NORTH))
	   (add (has-free-wall <room1> <inside>)))))




;;;
;;;  If the given house does not have room1, has room2 and room2 has a free
;;;  wall to the South, place room1 to the South of room2.  Room1 will have
;;;  have an outer wall on the same side as does room2.  The length of this
;;;  outer wall will be updated.
;;;

(ADD-ROOM-TO-SOUTH
 (params (<rambler> <room1> <room2> <inside> <outside> 
	  <side-length> <room-length> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room2>)
	        (~(has-room <rambler> <room1>))
	        (has-free-wall <room2> SOUTH)

	        (direction <outside>)
	        (not-equal <outside> NORTH)
	        (not-equal <outside> SOUTH)
	        (has-outer-wall <room2> <outside>)

	        (direction <inside>)
	        (not-equal <inside> NORTH)
	        (not-equal <inside> SOUTH)
	        (not-equal <inside> <outside>)

                (room-length <room1> <room-length>)
	        (side-length <outside> <side-length>)
                (increment-length <side-length> <room-length> <new-length>)))

 (effects ((del (has-free-wall <room2> SOUTH))

	   (del (side-length <outside> <side-length>))
	   (add (side-length <outside> <new-length>))

           (add (has-room <rambler> <room1>))
           (add (share-corner <room1> <room2> <outside>))
           (add (share-corner <room2> <room1> <outside>))
	   (add (has-outer-wall <room1> <outside>))
	   (add (has-free-wall <room1> SOUTH))
	   (add (has-free-wall <room1> <inside>)))))




;;;
;;;  If the given house does not have room1, has room2 and room2 has a free
;;;  wall to the East, place room1 to the East of room2.  Room1 will have
;;;  have an outer wall on the same side as does room2.  The length of this
;;;  outer wall will be updated.
;;;

(ADD-ROOM-TO-EAST
 (params (<rambler> <room1> <room2> <inside> <outside> 
	  <side-length> <room-width> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room2>)
	        (~(has-room <rambler> <room1>))
	        (has-free-wall <room2> EAST)

	        (direction <outside>)
	        (not-equal <outside> EAST)
	        (not-equal <outside> WEST)
	        (has-outer-wall <room2> <outside>)

	        (direction <inside>)
	        (not-equal <inside> EAST)
	        (not-equal <inside> WEST)
	        (not-equal <inside> <outside>)

                (room-width <room1> <room-width>)
	        (side-length <outside> <side-length>)
                (increment-length <side-length> <room-width> <new-length>)))

 (effects ((del (has-free-wall <room2> EAST))

	   (del (side-length <outside> <side-length>))
	   (add (side-length <outside> <new-length>))

           (add (has-room <rambler> <room1>))
           (add (share-corner <room1> <room2> <outside>))
           (add (share-corner <room2> <room1> <outside>))
	   (add (has-outer-wall <room1> <outside>))
	   (add (has-free-wall <room1> EAST))
	   (add (has-free-wall <room1> <inside>)))))




;;;
;;;  If the given house does not have room1, has room2 and room2 has a free
;;;  wall to the West, place room1 to the West of room2.  Room1 will have
;;;  have an outer wall on the same side as does room2.  The length of this
;;;  outer wall will be updated.
;;;

(ADD-ROOM-TO-WEST
 (params (<rambler> <room1> <room2> <inside> <outside> 
	  <side-length> <room-width> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room2>)
	        (~(has-room <rambler> <room1>))
	        (has-free-wall <room2> WEST)

	        (direction <outside>)
	        (not-equal <outside> EAST)
	        (not-equal <outside> WEST)
	        (has-outer-wall <room2> <outside>)

	        (direction <inside>)
	        (not-equal <inside> EAST)
	        (not-equal <inside> WEST)
	        (not-equal <inside> <outside>)

                (room-width <room1> <room-width>)
	        (side-length <outside> <side-length>)
                (increment-length <side-length> <room-width> <new-length>)))

 (effects ((del (has-free-wall <room2> WEST))

	   (del (side-length <outside> <side-length>))
	   (add (side-length <outside> <new-length>))

           (add (has-room <rambler> <room1>))
           (add (share-corner <room1> <room2> <outside>))
           (add (share-corner <room2> <room1> <outside>))
	   (add (has-outer-wall <room1> <outside>))
	   (add (has-free-wall <room1> WEST))
	   (add (has-free-wall <room1> <inside>)))))




;;;
;;;  If room1 shares an outer wall with room2, and room1 has a free wall to
;;;  the North, make this free wall an outer wall.  Thus room1 becomes a
;;;  corner room.  The length of the outer Northern wall is incremented.
;;;

(MAKE-CORNER-ROOM-NORTH
 (params (<rambler> <room1> <room2> <side> 
	  <side-length> <room-width> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room1>)
	        (has-room <rambler> <room2>)
	        (has-free-wall <room1> NORTH)

	        (direction <side>)
	        (not-equal <side> NORTH)
	        (not-equal <side> SOUTH)
	        (share-corner <room1> <room2> <side>)

                (room-width <room1> <room-width>)
	        (side-length NORTH <side-length>)
	        (increment-length <side-length> <room-width> <new-length>)))

 (effects ((del (has-free-wall <room1> NORTH))
	   (add (has-outer-wall <room1> NORTH))

	   (del (side-length NORTH <side-length>))
	   (add (side-length NORTH <new-length>)))))




;;;
;;;  If room1 shares an outer wall with room2, and room1 has a free wall to
;;;  the South, make this free wall an outer wall.  Thus room1 becomes a
;;;  corner room.  The length of the outer Southern wall is incremented.
;;;

(MAKE-CORNER-ROOM-SOUTH
 (params (<rambler> <room1> <room2> <side> 
	  <side-length> <room-width> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room1>)
	        (has-room <rambler> <room2>)
	        (has-free-wall <room1> SOUTH)

	        (direction <side>)
	        (not-equal <side> NORTH)
	        (not-equal <side> SOUTH)
	        (share-corner <room1> <room2> <side>)

                (room-width <room1> <room-width>)
	        (side-length SOUTH <side-length>)
	        (increment-length <side-length> <room-width> <new-length>)))

 (effects ((del (has-free-wall <room1> SOUTH))
	   (add (has-outer-wall <room1> SOUTH))

	   (del (side-length SOUTH <side-length>))
	   (add (side-length SOUTH <new-width>)))))




;;;
;;;  If room1 shares an outer wall with room2, and room1 has a free wall to
;;;  the East, make this free wall an outer wall.  Thus room1 becomes a
;;;  corner room.  The length of the outer Eastern wall is incremented.
;;;

(MAKE-CORNER-ROOM-EAST
 (params (<rambler> <room1> <room2> <side> 
	  <side-length> <room-length> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room1>)
	        (has-room <rambler> <room2>)
	        (has-free-wall <room1> EAST)

	        (direction <side>)
	        (not-equal <side> EAST)
	        (not-equal <side> WEST)
	        (share-corner <room1> <room2> <side>)

                (room-length <room1> <room-length>)
	        (side-length EAST <side-length>)
	        (increment-length <side-length> <room-length> <new-length>)))

 (effects ((del (has-free-wall <room1> EAST))
	   (add (has-outer-wall <room1> EAST))

	   (del (side-length EAST <side-length>))
	   (add (side-length EAST <new-length>)))))




;;;
;;;  If room1 shares an outer wall with room2, and room1 has a free wall to
;;;  the Wast, make this free wall an outer wall.  Thus room1 becomes a
;;;  corner room.  The length of the outer Western wall is incremented.
;;;

(MAKE-CORNER-ROOM-WEST
 (params (<rambler> <room1> <room2> <side> 
	  <side-length> <room-length> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room1>)
	        (has-room <rambler> <room2>)
	        (has-free-wall <room1> WEST)

	        (direction <side>)
	        (not-equal <side> EAST)
	        (not-equal <side> WEST)
	        (share-corner <room1> <room2> <side>)

                (room-length <room1> <room-length>)
	        (side-length WEST <side-length>)
	        (increment-length <side-length> <room-length> <new-length>)))

 (effects ((del (has-free-wall <room1> WEST))
	   (add (has-outer-wall <room1> WEST))

	   (del (side-length WEST <side-length>))
	   (add (side-length WEST <new-length>)))))




;;;
;;;  If two rooms are adjacent to each other in the specified house, add
;;;  a doorway between them. 
;;;

(ADD-DOORWAY-BETWEEN
 (params (<rambler> <room1> <room2> <side>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room1>)
	        (has-room <rambler> <room2>)
	        (direction <side>)
	        (share-corner <room1> <room2> <side>)))

 (effects ((add (doorway-between <room1> <room2>))
           (add (doorway-between <room2> <room1>)))))




;;;
;;;  Add an outer door on the specified side of the specified room of the
;;;  specified house.
;;;

(ADD-OUTSIDE-DOOR
 (params (<rambler> <room> <side>))

 (preconds (and (house <rambler>)
	        (is-room <room>)
	        (has-room <rambler> <room>)
	        (direction <side>)
	        (has-outer-wall <room> <side>)))

 (effects ((add (has-outside-door <room> <side>)))))




;;;
;;;  If two rooms are adjacent to each other, add to the state that this is
;;;  so by indicating that they share either an eastern or western corner.
;;;

(JOIN-ROOMS-E-W
 (params (<rambler> <room1> <room2> <outside> <side1> <side2> <wall-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (has-room <rambler> <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room2>)
	    
	        (direction <outside>)
	        (or (is-equal <outside> NORTH)
		    (is-equal <outside> SOUTH))
	        (has-outer-wall <room1> <outside>)
	        (has-outer-wall <room2> <outside>)

	        (side-length NORTH <wall-length>)
	        (side-length SOUTH <wall-length>)

	        (direction <side1>)
	        (direction <side2>)

	        (or (and (is-equal <side1> EAST) (is-equal <side2> WEST))
		    (and (is-equal <side1> WEST) (is-equal <side2> EAST)))

	        (has-free-wall <room1> <side1>)
	        (has-free-wall <room2> <side2>)))

 (effects ((del (has-free-wall <room1> <side1>))
	   (del (has-free-wall <room2> <side2>))

	   (add (share-corner <room1> <room2> <outside>))
	   (add (share-corner <room2> <room1> <outside>)))))




;;;
;;;  If two rooms are adjacent to each other, add to the state that this is
;;;  so by indicating that they share either a Southern or southern corner.
;;;

(JOIN-ROOMS-N-S
 (params (<rambler> <room1> <room2> <outside> <side1> <side2> <wall-length>))

 (preconds (and (house <rambler>)
	        (is-room <room1>)
	        (has-room <rambler> <room1>)
	        (is-room <room2>)
	        (has-room <rambler> <room2>)
	    
	        (side-length EAST <wall-length>)
	        (side-length WEST <wall-length>)

	        (direction <outside>)
	        (or (is-equal <outside> EAST)
		    (is-equal <outside> WEST))
	        (has-outer-wall <room1> <outside>)
	        (has-outer-wall <room2> <outside>)

	        (direction <side1>)
	        (direction <side2>)

	        (or (and (is-equal <side1> NORTH) (is-equal <side2> SOUTH))
		    (and (is-equal <side1> SOUTH) (is-equal <side2> NORTH)))

	        (has-free-wall <room1> <side1>)
	        (has-free-wall <room2> <side2>)))

 (effects ((del (has-free-wall <room1> <side1>))
	   (del (has-free-wall <room2> <side2>))

	   (add (share-corner <room1> <room2> <outside>))
	   (add (share-corner <room2> <room1> <outside>)))))




;;;
;;;  Convert the existing free wall of a room to an outer wall.  Update the
;;;  length of the outer wall for the particular side.
;;;

(ADD-OUTER-WALL-N-S
 (params (<rambler> <room> <side> <side-length> <room-width> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room>)
	        (has-room <rambler> <room>)

	        (direction <side>)
                (not-equal <side> EAST)
                (not-equal <side> WEST)
	        (has-free-wall <room> <side>)

                (room-width <room> <room-width>)
	        (side-length <side> <side-length>)
	        (increment-length <side-length> <room-width> <new-length>)))

 (effects ((del (has-free-wall <room> <side>))
	   (add (has-outer-wall <room> <side>))

	   (del (side-length <side> <side-length>))
	   (add (side-length <side> <new-length>)))))




;;;
;;;  Convert the existing free wall of a room to an outer wall.  Update the
;;;  length of the outer wall for the particular side.
;;;

(ADD-OUTER-WALL-E-W
 (params (<rambler> <room> <side> <side-length> <room-length> <new-length>))

 (preconds (and (house <rambler>)
	        (is-room <room>)
	        (has-room <rambler> <room>)

	        (direction <side>)
                (not-equal <side> NORTH)
                (not-equal <side> SOUTH)
	        (has-free-wall <room> <side>)

                (room-length <room> <room-length>)
	        (side-length <side> <side-length>)
	        (increment-length <side-length> <room-length> <new-length>)))

 (effects ((del (has-free-wall <room> <side>))
	   (add (has-outer-wall <room> <side>))

	   (del (side-length <side> <side-length>))
	   (add (side-length <side> <new-length>)))))




;;;
;;;  Inspect the resulting house.  Make sure that no rooms have free walls,
;;;  that all rooms have doorways and that there is an outer door for the
;;;  house.  Also opposite side lengths are compared to be sure that they
;;;  are equal.
;;;
;;;  NOTE:  Non-static generators are used throughout this file for the 
;;;         lengths of the walls.  This is because it would make little
;;;         sense to declare all relevant integers as lengths.
;;;
;;;  <room2> is also non-statically generated.  This is because we only check
;;;  that there exists a <room2> such that there is a doorway between <room1> 
;;;  and <room2>, for all <room1>'s.
;;;
;;;  <outside> is also non-statically generated.  This is because we only 
;;;  check that every room has an outer wall; we don't care which side it
;;;  is on.
;;;

(INSPECT-HOUSE
 (params (<rambler> <side> <wall-width> <wall-length>))

 (preconds (and (house <rambler>)

	        (direction <side>)
    	        (~(exists (<room>) (is-room <room>) 
   		   (and (has-room <rambler> <room>)
		        (has-free-wall <room> <side>))))

	        (side-length SOUTH <wall-width>)
 	        (side-length NORTH <wall-width>)

 	        (side-length WEST <wall-length>)
	        (side-length EAST <wall-length>)


	        (forall (<room1>) (is-room <room1>)
		 (and (has-room <rambler> <room1>)
		      (doorway-between <room1> <room2>)))

	        (exists (<outer-room>) (is-room <outer-room>)
   		   (and (has-room <rambler> <outer-room>)
		        (has-outside-door <outer-room> SOUTH)))

	        (forall (<room>) (is-room <room>)
		 (and (has-room <rambler> <room>)
		      (has-outer-wall <room> <outside>)
		      (has-window <room> <outside>)))))

 (effects ((add (house-inspected <rambler>)))))



		 ))


(setq *INFERENCE-RULES* '(

;;;
;;;  If a room has two outer walls, it must be a corner room.  
;;;  This is because houses are more than one room wide.
;;; 

(INFER-CORNER-ROOM
 (params (<rambler> <room> <side1> <side2>))

 (preconds (and (house <rambler>)
	        (is-room <room>)
	        (has-room <rambler> <room>)

	        (direction <side1>)
	        (or (is-equal <side1> NORTH)
		    (is-equal <side1> SOUTH))

	        (direction <side2>)
	        (or (is-equal <side2> EAST)
		    (is-equal <side2> WEST))

	        (has-outer-wall <room> <side1>)
	        (has-outer-wall <room> <side2>)))

 (effects ((add (is-corner-room <room> <side1> <side2>)))))




;;;
;;;  If a room has an outer wall, it has a window on that wall.
;;;

(INFER-HAS-WINDOW
 (params (<rambler> <room> <side>))

 (preconds (and (house <rambler>)
	        (is-room <room>)
	        (has-room <ramlber> <room>)
	        (direction <side>)
	        (has-outer-wall <room> <side>)))

 (effects ((add (has-window <room> <side>)))))

		       ))





