
(defun increment-length (x y z)
  (cond ((and (is-variable x) (numberp y) (numberp z)) `(((,x ,(- z y)))))
	((and (numberp x) (is-variable y) (numberp z)) `(((,y ,(- z x)))))
	((and (numberp x) (numberp y) (is-variable z)) `(((,z ,(+ x y)))))
	((and (numberp x) (numberp y) (numberp z)) (= (+ x y) z))
	(t 'no-match-attempted)))



(defun parent-op (node op)
  (and (not-top-level-node node)
       (current-op (node-parent node) op)))

(add-meta-fn 'parent-op)