;;; FINGERING Domain

;;; TB May 91

;;; Search-Control Rules
;;;



(setq *SCR-NODE-SELECT-RULES* nil)

;;; Modify SELECT-FIRST-GOAL (see PRODIGY manual, p. 29)
;;; so that it applies in EACH level, i.e. in the top level as well.
;;; we do so, because we only wnat to play the notes in the
;;; right order (we HAVE to do so !)
(setq *SCR-GOAL-SELECT-RULES* 
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
;;; the next line is REMOVED, NOT in effect !!
;;;                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)
       ))
           (rhs (select goal <goal>)))
       ))

(setq *SCR-OP-SELECT-RULES* nil)

(setq *SCR-BINDINGS-SELECT-RULES* nil)

;;; REJECT-ALL-SUBGOALING
;;; ... prevents subgoaling on ANY predicate. This sounds very weird in
;;; the first place, but it isn't. 
;;; See comments in the README-DOC file, Sections 6/8
;;; Not necessary for domain, but makes it faster ...
(setq *SCR-NODE-REJECT-RULES*
      '((REJECT-ALL-SUBGOALING
	 (lhs (and (current-node <node>)
                   ; if <node> is not top-level
	           (not-top-level-node <node>)
         ))
         ; then reject it !
	 (rhs (reject node <node>)))
       ))


(setq *SCR-GOAL-REJECT-RULES* nil)

(setq *SCR-OP-REJECT-RULES*
'(

;;; Dont't allow JUMP-xxxx, if PLAY-yyy is possible
;;; --> 5 SCR's referring to the actual state
;;; see 8.1. README-DOC
;;; only the 1st of the fiveSCRs is commented
(REJECT-JUMP-THUMB-1
 (lhs 
  (AND (current-node <node>)
       ; check we are subgoaling on playing a note
       (current-goal <node> (play-note <note> <N>))
       ; JUMP-THUMB applicable ?
       (candidate-op <node> JUMP-THUMB)
       ; any finger on the note we want to play ?
       (OR 
	(known <node> (thumb <note>))
	(known <node> (index <note>))
	(known <node> (middle <note>))         
	(known <node> (ring <note>))       
	(known <node> (pinky <note>)))
 ))
 ; if so: Reject JUMP-THUMB
 (rhs (reject op JUMP-THUMB))
)

;;; same for JUMP-INDEX
(REJECT-JUMP-INDEX-1
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       (candidate-op <node> JUMP-INDEX)
       (OR 
	(known <node> (thumb <note>))
	(known <node> (index <note>))
	(known <node> (middle <note>))         
	(known <node> (ring <note>))       
	(known <node> (pinky <note>)))
 ))
 (rhs (reject op JUMP-INDEX))
)

;;; same for JUMP-MIDDLE
(REJECT-JUMP-MIDDLE-1
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       (candidate-op <node> JUMP-MIDDLE)
       (OR 
	(known <node> (thumb <note>))
	(known <node> (index <note>))
	(known <node> (middle <note>))         
	(known <node> (ring <note>))       
	(known <node> (pinky <note>)))
 ))
 (rhs (reject op JUMP-MIDDLE))
)

;;; same for JUMP-RING
(REJECT-JUMP-RING-1
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       (candidate-op <node> JUMP-RING)
       (OR 
	(known <node> (thumb <note>))
	(known <node> (index <note>))
	(known <node> (middle <note>))         
	(known <node> (ring <note>))       
	(known <node> (pinky <note>)))
 ))
 (rhs (reject op JUMP-RING))
)

;;; same for JUMP-PINKY
(REJECT-JUMP-PINKY-1
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       (candidate-op <node> JUMP-PINKY)
       (OR 
	(known <node> (thumb <note>))
	(known <node> (index <note>))
	(known <node> (middle <note>))         
	(known <node> (ring <note>))       
	(known <node> (pinky <note>)))
 ))
 (rhs (reject op JUMP-PINKY))
)



;;; Reject JUMP-XXX if the following is true:
;;; - the note before the note to play is directly
;;;   adjacent to the note to play
;;; ---> 5 SCR's, referring to the note before
;;; see 8.2. README-DOC file
;;; only the 1st is commented
(REJECT-JUMP-THUMB-2
 (lhs 
  (AND 
   (current-node <node>)
   ; 'bind' <note1> and <N1>, the note and number we are about to play
   (current-goal <node> (play-note <note1> <N1>))
   ; JUMP-THUMB considered ?
   (candidate-op <node> JUMP-THUMB)
   ; find note played before: It has been added to the state, so we can
   ;                          use 'known'
   (known <node> (is-more <N1> <N0> 1))
   (known <node> (play-note <note0> <N0>))
   ; check if note played before is adjacent to note now
   (OR 
    (known <node> (next-note <note1> <note0>))
    (known <node> (next-note <note0> <note1>))
   )
 ))
 ; if so: Reject JUMP-THUMB
 (rhs 
  (reject op JUMP-THUMB))
)

;;; same for JUMP-INDEX
(REJECT-JUMP-INDEX-2
 (lhs 
  (AND 
   (current-node <node>)
   (current-goal <node> (play-note <note1> <N1>))
   (candidate-op <node> JUMP-INDEX)
   (known <node> (is-more <N1> <N0> 1))
   (known <node> (play-note <note0> <N0>))
   (OR 
    (known <node> (next-note <note1> <note0>))
    (known <node> (next-note <note0> <note1>))
   )
 ))
 (rhs 
  (reject op JUMP-INDEX))
)

;;; same for JUMP-MIDDLE
(REJECT-JUMP-MIDDLE-2
 (lhs 
  (AND 
   (current-node <node>)
   (current-goal <node> (play-note <note1> <N1>))
   (candidate-op <node> JUMP-MIDDLE)
   (known <node> (is-more <N1> <N0> 1))
   (known <node> (play-note <note0> <N0>))
   (OR 
    (known <node> (next-note <note1> <note0>))
    (known <node> (next-note <note0> <note1>))
   )
 ))
 (rhs 
  (reject op JUMP-MIDDLE))
)

;;; same for JUMP-RING
(REJECT-JUMP-RING-2
 (lhs 
  (AND 
   (current-node <node>)
   (current-goal <node> (play-note <note1> <N1>))
   (candidate-op <node> JUMP-RING)
   (known <node> (is-more <N1> <N0> 1))
   (known <node> (play-note <note0> <N0>))
   (OR 
    (known <node> (next-note <note1> <note0>))
    (known <node> (next-note <note0> <note1>))
   )
 ))
 (rhs 
  (reject op JUMP-RING))
)

;;; same for JUMP-PINKY
(REJECT-JUMP-PINKY-2
 (lhs 
  (AND 
   (current-node <node>)
   (current-goal <node> (play-note <note1> <N1>))
   (candidate-op <node> JUMP-PINKY)
   (known <node> (is-more <N1> <N0> 1))
   (known <node> (play-note <note0> <N0>))
   (OR 
    (known <node> (next-note <note1> <note0>))
    (known <node> (next-note <note0> <note1>))
   )
 ))
 (rhs 
  (reject op JUMP-PINKY))
)



))


(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES*
'(

;;; If we jump (which we don't do with pleasure, but 
;;;  AT LEAST have to do in the beginning), jump with
;;;  the best finger:
;;;  - Use thumb if next 4 notes are higher
;;;  - Use middle if next 4 notes are 2 higher/2 lower each
;;;  - Use pinky if next 4 notes are lower
;;;  - Use ring/index ....
;;; --> 5 SCR's, referring to the 4 next notes
;;; see 8.3. README-DOC
;;; note the usage of TB-IN-GOAL, TB-NOTE-LOWER and TB-NOTE-HIGHER,
;;; new meta-functions defined in
;;;     my-metas.lisp
;;; only the first SCR is commented
(PREFER-JUMP-THUMB-1
 ; assign a priority to avoid warning
 ; not neccessary now
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       ; 'bind' <note0> and <N0>, the note to be played next
       (current-goal <node> (play-note <note0> <N0>))
       ; JUMP-THUMB consideed ?
       (candidate-op <node> JUMP-THUMB)
       ; any other JUMP considered ?
       ; (we don't want to prefer over other op groups...)
       (candidate-op <node> <jump-other>)
       (OR
        (is-equal <jump-other> JUMP-INDEX)
        (is-equal <jump-other> JUMP-MIDDLE)
        (is-equal <jump-other> JUMP-RING)
        (is-equal <jump-other> JUMP-PINKY)
       )
       ; 'bind' the next 4 notes using the counter
       ; and the meta-fnc TB-IN-GOAL
       (known <node> (is-more <N1> <N0> 1))
       (known <node> (is-more <N2> <N0> 2))
       (known <node> (is-more <N3> <N0> 3))
       (known <node> (is-more <N4> <N0> 4))
       (TB-IN-GOAL (play-note <note1> <N1>))
       (TB-IN-GOAL (play-note <note2> <N2>))
       (TB-IN-GOAL (play-note <note3> <N3>))
       (TB-IN-GOAL (play-note <note4> <N4>))
       ; check if all 4 are higher than the 'current' note
       ; 1 permutation of 4 notes higher
       (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
       (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
       (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
       (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
  ))
 ; if so: prefer JUMP-THUMB
 (rhs (prefer op JUMP-THUMB <jump-other>))
)

;;; same for JUMP-INDEX
(PREFER-JUMP-INDEX-1
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note0> <N0>))
       (candidate-op <node> JUMP-INDEX)
       (candidate-op <node> <jump-other>)
       (OR
        (is-equal <jump-other> JUMP-THUMB)
        (is-equal <jump-other> JUMP-MIDDLE)
        (is-equal <jump-other> JUMP-RING)
        (is-equal <jump-other> JUMP-PINKY)
       )
       (known <node> (is-more <N1> <N0> 1))
       (known <node> (is-more <N2> <N0> 2))
       (known <node> (is-more <N3> <N0> 3))
       (known <node> (is-more <N4> <N0> 4))
       (TB-IN-GOAL (play-note <note1> <N1>))
       (TB-IN-GOAL (play-note <note2> <N2>))
       (TB-IN-GOAL (play-note <note3> <N3>))
       (TB-IN-GOAL (play-note <note4> <N4>))
       ;4 permutations of one note lower, 3 higher
       (OR
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
       )
  ))
 (rhs (prefer op JUMP-INDEX <jump-other>))
)

;;; same for JUMP-MIDDLE
(PREFER-JUMP-MIDDLE-1
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note0> <N0>))
       (candidate-op <node> JUMP-MIDDLE)
       (candidate-op <node> <jump-other>)
       (OR
        (is-equal <jump-other> JUMP-THUMB)
        (is-equal <jump-other> JUMP-INDEX)
        (is-equal <jump-other> JUMP-RING)
        (is-equal <jump-other> JUMP-PINKY)
       )
       (known <node> (is-more <N1> <N0> 1))
       (known <node> (is-more <N2> <N0> 2))
       (known <node> (is-more <N3> <N0> 3))
       (known <node> (is-more <N4> <N0> 4))
       (TB-IN-GOAL (play-note <note1> <N1>))
       (TB-IN-GOAL (play-note <note2> <N2>))
       (TB-IN-GOAL (play-note <note3> <N3>))
       (TB-IN-GOAL (play-note <note4> <N4>))
       ;6 permutations of two notes lower, 2 higher
       (OR
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
       )
  ))
 (rhs (prefer op JUMP-MIDDLE <jump-other>))
)

;;; same for JUMP-RING
(PREFER-JUMP-RING-1
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note0> <N0>))
       (candidate-op <node> JUMP-RING)
       (candidate-op <node> <jump-other>)
       (OR
        (is-equal <jump-other> JUMP-THUMB)
        (is-equal <jump-other> JUMP-INDEX)
        (is-equal <jump-other> JUMP-MIDDLE)
        (is-equal <jump-other> JUMP-PINKY)
       )
       (known <node> (is-more <N1> <N0> 1))
       (known <node> (is-more <N2> <N0> 2))
       (known <node> (is-more <N3> <N0> 3))
       (known <node> (is-more <N4> <N0> 4))
       (TB-IN-GOAL (play-note <note1> <N1>))
       (TB-IN-GOAL (play-note <note2> <N2>))
       (TB-IN-GOAL (play-note <note3> <N3>))
       (TB-IN-GOAL (play-note <note4> <N4>))
       ;4 permutations of 3 notes lower, 1 higher
       (OR
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-LOWER-EQUAL <note1> <note0>)
         (TB-NOTE-HIGHER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
        (AND
         (TB-NOTE-HIGHER-EQUAL <note1> <note0>)
         (TB-NOTE-LOWER-EQUAL <note2> <note0>)
         (TB-NOTE-LOWER-EQUAL <note3> <note0>)
         (TB-NOTE-LOWER-EQUAL <note4> <note0>)
        )
       )
  ))
 (rhs (prefer op JUMP-RING <jump-other>))
)

;;; same for JUMP-PINKY
(PREFER-JUMP-PINKY-1
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note0> <N0>))
       (candidate-op <node> JUMP-PINKY)
       (candidate-op <node> <jump-other>)
       (OR
        (is-equal <jump-other> JUMP-THUMB)
        (is-equal <jump-other> JUMP-INDEX)
        (is-equal <jump-other> JUMP-MIDDLE)
        (is-equal <jump-other> JUMP-RING)
       )
       (known <node> (is-more <N1> <N0> 1))
       (known <node> (is-more <N2> <N0> 2))
       (known <node> (is-more <N3> <N0> 3))
       (known <node> (is-more <N4> <N0> 4))
       (TB-IN-GOAL (play-note <note1> <N1>))
       (TB-IN-GOAL (play-note <note2> <N2>))
       (TB-IN-GOAL (play-note <note3> <N3>))
       (TB-IN-GOAL (play-note <note4> <N4>))
       ; 1 permutation of 4 notes lower
       (TB-NOTE-LOWER-EQUAL <note1> <note0>)
       (TB-NOTE-LOWER-EQUAL <note2> <note0>)
       (TB-NOTE-LOWER-EQUAL <note3> <note0>)
       (TB-NOTE-LOWER-EQUAL <note4> <note0>)
  ))
 (rhs (prefer op JUMP-PINKY <jump-other>))
)


;;; 4 very special SCRs:
;;; C-major scale: try a jump at standard positions first
;;; Standard Position 1: Middle on E, going up, then do THUMB-UNDER-MIDDLE
;;; Standard Position 2: Ring on B, going up, then do THUMB-UNDER-RING
;;; Standard Position 3: Thumb on F, going down, then do MIDDLE-OVER-THUMB
;;; Standard Position 4: Thumb on C, going down, then do RING-OVER-THUMB
;;; see 8.4. README-DOC

;;; Standard Position 1
;;; only this SCR commented
(PREFER-THUMB-UNDER-MIDDLE-C-MAJOR
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       ; check for c-major-scale
       (known <node> (scale c-major))
       ; check if THUMB-UNDER-MIDDLE considered
       (candidate-op <node> THUMB-UNDER-MIDDLE)
       (candidate-op <node> <other-op>)
       (~ (is-equal <other-op> THUMB-UNDER-MIDDLE))
       ; check if note is F, the standard note to change (going up) in C-major
       ; and middle finger is on E
       (OR
        (AND
         (is-equal <note> F)
         (known <node> (middle E))
        )
        (AND
         (is-equal <note> F1)
         (known <node> (middle E1))
        )
        (AND
         (is-equal <note> F2)
         (known <node> (middle E2))
        )
        (AND
         (is-equal <note> F3)
         (known <node> (middle E3))
        )
       )
  ))
 ; if so: prefer THUMB-UNDER-MIDDLE
 (rhs (prefer op THUMB-UNDER-MIDDLE <other-op>))
)

;;; Standard Position 2
(PREFER-THUMB-UNDER-RING-C-MAJOR
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       ; check for c-major-scale
       (known <node> (scale c-major))
       ; check if THUMB-UNDER-RING considered
       (candidate-op <node> THUMB-UNDER-RING)
       (candidate-op <node> <other-op>)
       (~ (is-equal <other-op> THUMB-UNDER-RING))
       (OR
        (AND
         (is-equal <note> C1)
         (known <node> (ring B))
        )
        (AND
         (is-equal <note> C2)
         (known <node> (ring B1))
        )
        (AND
         (is-equal <note> C3)
         (known <node> (ring B2))
        )
       )
  ))
 ; if so: prefer THUMB-UNDER-RING
 (rhs (prefer op THUMB-UNDER-RING <other-op>))
)

;;; Standard Position 3
(PREFER-MIDDLE-OVER-THUMB-C-MAJOR
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       ; check for c-major-scale
       (known <node> (scale c-major))
       ; check if MIDDLE-OVER-THUMB considered
       (candidate-op <node> MIDDLE-OVER-THUMB)
       (candidate-op <node> <other-op>)
       (~ (is-equal <other-op> MIDDLE-OVER-THUMB))
       (OR
        (AND
         (is-equal <note> E)
         (known <node> (thumb F))
        )
        (AND
         (is-equal <note> E1)
         (known <node> (thumb F1))
        )
        (AND
         (is-equal <note> E2)
         (known <node> (thumb F2))
        )
        (AND
         (is-equal <note> E3)
         (known <node> (thumb F3))
        )
       )
  ))
 ; if so: prefer MIDDLE-OVER-THUMB
 (rhs (prefer op MIDDLE-OVER-THUMB <other-op>))
)

;;; Standard Position 4
(PREFER-RING-OVER-THUMB-C-MAJOR
 (priority 0)
 (lhs 
  (AND (current-node <node>)
       (current-goal <node> (play-note <note> <N>))
       ; check for c-major-scale
       (known <node> (scale c-major))
       ; check if RING-OVER-THUMB considered
       (candidate-op <node> RING-OVER-THUMB)
       (candidate-op <node> <other-op>)
       (~ (is-equal <other-op> RING-OVER-THUMB))
       (OR
        (AND
         (is-equal <note> B)
         (known <node> (thumb C1))
        )
        (AND
         (is-equal <note> B1)
         (known <node> (thumb C2))
        )
        (AND
         (is-equal <note> B2)
         (known <node> (thumb C3))
        )
       )
  ))
 ; if so: prefer RING-OVER-THUMB
 (rhs (prefer op RING-OVER-THUMB <other-op>))
)



))


(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
