;;; hans-without.lisp

;;; Problem for PIANO FINGERING domain: (TB 6 May 91)
;;; Fingering of "Haenschen Klein" (German Folk Song)
;;; 
;;; quite trivial job: No movement of the hand whatsoever necessary
;;;

;;; Needed for 'Hack'-domain only:
;;; Initialize *SOLU-L*. In this global Lisp variable
;;; the solutions so far will be counted
(setq *SOLU-L* nil)


;;; load C-Major-Scale as current scale in Initial state
;;; The file contains the specific information for the scale
;;; (see that file as well)
(load-path *WORLD-PATH* "scales/c-major.scale")

;;; add additional predicates to start state
;;; (ADD-START-STATE: see Functions File)
(add-start-state '(

      ; no note played in beginning
      (played-so-far 0)
      ; cost 0 in the beginning
      (cost-so-far 0)

))


;;; Goal State: Play the melody 'Haenschen klein'

(load-goal
 
   ;********* 
   ;** The goal state consists of a list of predicates 
   ;   play-note <pitch> <n>
   ;   meaning that the pitch <pitch> is the <n>th note to play
   ;
   ;   Operators will add "play-note" predicates to the state,
   ;   counting is done using the predicate "played-so-far"

   '(AND 

   (play-note g1 1) (play-note e1 2) (play-note e1 3)     ;Haenschen klein
   (play-note f1 4) (play-note d1 5) (play-note d1 6)     ;ging allein
   (play-note c1 7) (play-note d1 8) (play-note e1 9)     ;in die wei-
   (play-note f1 10) (play-note g1 11) (play-note g1 12)  ;te Welt hi-
   (play-note g1 13)                                      ;nein

   ;and so on, the song is not complete, but as we only play this 
   ;5 notes, it stays the same problem.

   ; Finally: Maximum cost to play piece is 21
   ;          This value can either be calculated with the 'Hack'-
   ;          Domain (giving the best value the program can come
   ;          up with)
   ;          or be calculated from a human solution
   (most-cost 999)


   )
)
