


;;; Problem generator for PIANO-FINGERING domain
;;; TB June 1991


;;; print TXT on stream, add Linefeed
(defun princ-lf (txt stream)
   (princ txt stream)
   (terpri stream)) 



;;; Scan LST, print each entry in STREAM in format required by domain
;;; Start counter with COUNTER, increase for each line
(defun print-notes-to-file (lst stream counter)
  (cond 
	 ((null lst) t)             ;done
	 (t 
          (terpri stream)
          (princ "(PLAY-NOTE " stream)
	  (princ (first lst) stream)
          (princ " " stream)
          (princ counter stream)
          (princ ")" stream)
	  (print-notes-to-file (rest lst) stream (1+ counter))) ; next one
  )
)




;;; Problem generator for Piano-Fingering Domain
;;; takes Name of Problem, Scale, List of notes and Name of output-file
;;; as parameters, i.e
;;;       (generate-problem "Easy" "C-major" '(c d e f g a b c) "easy.lisp")
;;;
(defun generate-problem (name scale notes out-file)
  ; open out-file
  (let* ((out-stream (open out-file :direction :output)))
    ; -- comment to screen
    (princ "Writing on File: ")
    (princ out-stream)
    (terpri)
    ; -- comment with Name of problem
    (terpri out-stream)
    (princ-lf ";;;---- Problem for Piano Domain" out-stream)
    (princ-lf ";;;" out-stream)
    (princ ";;; Problem Name: " out-stream)
    (princ name out-stream)
    (terpri out-stream)
    (princ-lf ";;;" out-stream)
    (princ-lf ";;;---- The following file has been generated by" out-stream)
    (princ-lf ";;;---- the non-random Problem generator" out-stream)
    (princ-lf ";;;---- Version 1.0 , 31 May 1991, Thomas Burg" out-stream)
    (terpri out-stream)
    ; -- Reset var 'Hack' Domain
    (princ-lf ";;; Reset Var for 'Hack-domain'" out-stream)
    (princ-lf "(setq *SOLU-L* nil)" out-stream)
    (terpri out-stream)
    ; -- Load Scale-File
    (princ-lf ";;; load scale" out-stream)
    (princ "(load-path *WORLD-PATH* " out-stream)
    (princ #\" out-stream) (princ "scales/" out-stream)
    (princ scale out-stream) (princ ".scale" out-stream)
    (princ #\" out-stream) (princ-lf ")" out-stream)
    (terpri out-stream)
    ; -- Init counters
    (princ-lf ";;; Initialize Counters" out-stream)
    (princ-lf "(add-start-state '((played-so-far 0) (cost-so-far 0)))" 
               out-stream)
    (terpri out-stream)
    ; -- Finally the piece
    (princ-lf ";;; The notes" out-stream)
    (princ-lf "(load-goal '(AND" out-stream)
    (print-notes-to-file notes out-stream 1)
    ; -- and the maximum cost, very high per default (1st solution !)
    (terpri out-stream)
    (princ-lf "(most-cost 99999)))" out-stream)
    (close out-stream)
    'DONE
  )
)
    
    
	
