;;; FINGERING Domain

;;; Thomas Burg, May 91
;;; -------------------- FUNCTIONS -------------------


;;; ADD-START-STATE
;;; is only used in the problem-files
;;; it adds the predicates supplied to the start state
;;; (similar to LOAD-START-STATE, but without deleting the old)
(defun add-start-state (lst)
  (setq *START-STATE* (append *START-STATE* lst)))

; IS-ONE-MORE: checks if 1st argument is one larger than 2nd
; may be used to generate the 2nd argument, but not for the first
; struture similar to PRODIGY manual, p. 16,LESS-THAN (2)


(defun is-more (x y m)
  (cond ((AND (is-variable x) (is-variable y)) (princ x) (princ y)'no-match-attempted)
	((is-variable y) (princ y) '(((y (- x m)))))
	((is-variable x) (princ x) '(((x 1))))
	((= x (+ y m)) (princ "=") t)))

	

(defun halt ()
  (read))
