;**
;**
;**        KATHERINE A. FARBER
;**
;**        COOKING DOMAIN
;**
;**        05/17/91
;**


(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))

(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  
      '(
	
; All of the following search control rules are based on the idea that
; it is usually quicker to cook something which takes more time before
; doing something else which takes less time.  (For example: you probably
; want to starting baking the chicken before steaming the potatoes because
; the chicken takes longer).

	
;;; COOK-BEFORE-MAKING-SALAD is so that prodigy will try cooking something
;;; before making a salad.  This helps when a meal needs to be done in a 
;;; short period of time because, once something has started to cook, a
;;; salad can be prepared while it is cooking.
	
	(COOK-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and 
	       (current-node <node>)
	       (candidate-goal <node> (cooked <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (cooked <x>) (mixed-salad <a> <b> <c>))))
	

;;; BAKE, STEAM, MICROWAVE, BOIL, PANFRY, & TOAST -BEFORE-MAKING-SALAD are all
;;; more specific instances of the above cook-before-making-salad.  
;;; These are needed if the goal state specifies a certain method of cooking

	
	(BAKE-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and 
	       (current-node <node>)
	       (candidate-goal <node> (baked <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (baked <x>) (mixed-salad <a> <b> <c>))))
	
	
	(STEAM-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and 
	       (current-node <node>)
	       (candidate-goal <node> (steamed <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (steamed <x>) (mixed-salad <a> <b> <c>))))
	
	
	(MICROWAVE-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and 
	       (current-node <node>)
	       (candidate-goal <node> (microwaved <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (microwaved <x>) (mixed-salad <a> <b> <c>))))
	
	
	(BOIL-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and 
	       (current-node <node>)
	       (candidate-goal <node> (boiled <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (boiled <x>) (mixed-salad <a> <b> <c>))))
	

	(PANFRY-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and 
	       (current-node <node>)
	       (candidate-goal <node> (panfried <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (panfried <x>) (mixed-salad <a> <b> <c>))))
	

	(TOAST-BEFORE-MAKING-SALAD
	 (priority 0)
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (toasted <x>))
	       (candidate-goal <node> (mixed-salad <a> <b> <c>))))
	 (rhs (prefer goal (toasted <x>) (mixed-salad <a> <b> <c>))))


	       
;;; COOK-BEFORE-TOASTING tells prodigy to try cooking any food before
;;; toasting another food.  This is because cooking generally takes longer
;;; than toasting.

	(COOK-BEFORE-TOASTING
	 (priority 0)
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (cooked <x>))
	       (candidate-goal <node> (toasted <y>))))
	 (rhs (prefer goal (cooked <x>) (toasted <y>))))


;;; COOK-ANY-BEFORE-BROCCOLI & COOK-ANY-BEFORE-CORN tell prodigy to try 
;;; cooking any food before broccoli or corn-on-the-cob.  This is because
;;; broccoli and corn-on-the-cob generally take the least amount of
;;; time to cook.

	(COOK-ANY-BEFORE-BROCCOLI
	 (priority 0)
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (cooked <x>))
	       (candidate-goal <node> (cooked broccoli))))
	 (rhs (prefer goal (cooked <x>) (cooked broccoli))))


	(COOK-ANY-BEFORE-CORN
	 (priority 0)
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (cooked <x>))
	       (candidate-goal <node> (cooked corn-on-the-cob))))
	 (rhs (prefer goal (cooked <x>) (cooked corn-on-the-cob))))


	))

	       
(setq *SCR-OP-PREFERENCE-RULES*  nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
	
	