;**
;**
;**        KATHERINE A. FARBER
;**
;**        COOKING DOMAIN
;**
;**        05/17/91
;**


;  ---- Primitives ----
;
;   raw <food>       :  <food> is uncooked
;   clock <time>     :  <time> is the accumulated time spent so far
;   finish-by <time> :  <time> is the total number of minutes allowed


;  ---- Static Comments ----
;
;  The following are some static generators that are NOT in this domain.
;  The reasons follow.
;
;  is-time <time> : Would be used before clock <time>, finish-by <time>,
;                   less-than <time1> <time2>, and add-time <t1> <t2>.
;                   The reason this static generator is not included in
;                   this domain is because to be complete it would have
;                   to generate all integers >= 0.  That is simply beyond
;                   the demands of this domain.
;
;  is-food <food> : Would be used in almost all operators.  Instead of 
;                   using this generator in almost every single operator,
;                   I used raw <food> in most of them.  The reason for this
;                   is that I could not create and destroy when I needed to
;                   when using a static generator.
;



(setq *OPERATORS* '(




; Short-term Operators:  The following operations take 5 minutes or less
;                        each in a normal kitchen.



(WASH
 (params (<food>))
 (preconds (and 
	    (raw <food>)
	    (~(chopped <food>))
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (clean <food>))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   )))


(CUT-UP
 (params (<food>))
 (preconds (and
	    (raw <food>)
	    (clean <food>)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (chopped <food>))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))


(MAKE-SALAD
 (params (<food1> <food2> <food3>))
 (preconds (and
	    (raw <food1>)
	    (raw <food2>)
	    (raw <food3>)
	    (salad-prep <food1>)
	    (salad-prep <food2>)
	    (salad-prep <food3>)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (mixed-salad <food1> <food2> <food3>))
	   (del (raw <food1>))
	   (del (raw <food2>))
	   (del (raw <food3>))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))

	    
(TOAST
 (params (<food>))
 (preconds (and
	    (raw <food>)
	    (idle toaster)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((del (raw <food>))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   (add (toasted <food>)))))
	    

(SEASON
 (params (<food>))
 (preconds (and
	    (raw <food>)
	    (clean <food>)))
 (effects ((add (seasoned <food>)))))






; Prep for Long-Term Operators:  The following operations are short-term 
;                                but are all used before a long-term op.


(PREHEAT-OVEN
 (params (<temp>))
 (preconds (and
	    (idle oven)
	    (~(preheated-oven <xtemp>))
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (preheated-oven <temp>))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))


(WARM-PAN-ON-RANGE1
 (params nil)
 (preconds (and 
	    (have range1)
	    (idle range1)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (pan-warmed range1))
	   (del (idle range1))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))


(WARM-PAN-ON-RANGE2
 (params nil)
 (preconds (and 
	    (have range2)
	    (idle range2)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (pan-warmed range2))
	   (del (idle range2))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))



(BOIL-WATER-RANGE1
 (params nil)
 (preconds (and 
	    (have range1)
	    (idle range1)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (boiling-water range1))
	   (del (idle range1))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))


(BOIL-WATER-RANGE2
 (params nil)
 (preconds (and 
	    (have range2)
	    (idle range2)
	    (clock <time>)
	    (have-time <time> 5)))
 (effects ((add (boiling-water range2))
	   (del (idle range2))
	   (del (clock <time>))
	   (del (have-time <time> 5)))))





; Long-term Operators:  The following operations take longer than 5 minutes
;                       to complete in a normal kitchen

 
(BOIL
 (params (<food> <app> <boiltime>))
 (preconds (and
	    (raw <food>)
	    (boil <food> <boiltime>)
	    (boiling-water <app>)
	    (clock <time>)
	    (finish-by <donetime>)
	    (add-time <time> <boiltime> <outtime>)
	    (less-than <outtime> <donetime>)
	    (have-time <time> 5)))
 (effects ((add (boiled <food>))
	   (del (raw <food>))
	   (del (boiling-water <app>))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   (add (free <app> <outtime>)))))


(PANFRY
 (params (<food> <app> <frytime>))
 (preconds (and
	    (raw <food>)
	    (panfry <food> <frytime>)
	    (pan-warmed <app>)
	    (seasoned <food>)
	    (clock <time>)
	    (finish-by <donetime>)
	    (add-time <time> <frytime> <outtime>)
	    (less-than <outtime> <donetime>)
	    (have-time <time> 5)))
 (effects ((add (panfried <food>))
	   (del (raw <food>))
	   (del (pan-warmed <app>))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   (add (free <app> <outtime>)))))


(STEAM
 (params (<food> <app> <steamtime>))
 (preconds (and
	    (raw <food>)
	    (steam <food> <steamtime>)
	    (clean <food>)
	    (boiling-water <app>)
	    (seasoned <food>)
	    (clock <time>)
	    (finish-by <donetime>)
	    (add-time <time> <steamtime> <outtime>)
	    (less-than <outtime> <donetime>)
	    (have-time <time> 5)))
 (effects ((add (steamed <food>))
	   (del (raw <food>))
	   (del (boiling-water <app>))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   (add (free <app> <outtime>)))))
	    


(MICROWAVE
 (params (<food> <cooktime>))
 (preconds (and
	    (raw <food>)
	    (micro-cook <food> <temp> <cooktime>)
	    (clean <food>)
	    (idle microwave-oven)
	    (seasoned <food>)
	    (clock <time>)
	    (finish-by <donetime>)
	    (add-time <time> <cooktime> <outtime>)
	    (less-than <outtime> <donetime>)
	    (have-time <time> 5)))
 (effects ((add (microwaved <food>))
	   (del (raw <food>))
	   (del (idle microwave-oven))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   (add (free microwave-oven <outtime>)))))

	    

(BAKE
 (params (<food> <baketime>))
 (preconds (and
	    (raw <food>)
	    (bake <food> <temp> <baketime>)
	    (idle oven)
	    (preheated-oven <temp>)
	    (seasoned <food>)
	    (clock <time>)
	    (finish-by <donetime>)
	    (add-time <time> <baketime> <outtime>)
	    (less-than <outtime> <donetime>)
	    (have-time <time> 5)))
 (effects ((add (baked <food>))
	   (del (raw <food>))
	   (del (idle oven))
	   (del (preheated-oven <temp>))
	   (del (clock <time>))
	   (del (have-time <time> 5))
	   (add (free oven <outtime>)))))

	    


))




(setq *INFERENCE-RULES* '(


; Inferences about specific foods

(INFER-CHICKEN
 (params nil)
 (preconds
  (raw chicken))
 (effects 
  ((add (bake chicken 425 45))
   (add (clean chicken))
   (add (steam chicken 60))
   (add (panfry chicken 30)))))

(INFER-PORKCHOPS
 (params nil)
 (preconds
  (raw porkchops))
 (effects
  ((add (bake porkchops 400 60))
   (add (panfry porkchops 30))
   (add (clean porkchops)))))

(INFER-ROAST
 (params nil)
 (preconds
  (raw small-roast))
 (effects
  ((add (bake small-roast 350 120))
   (add (clean small-roast)))))

(INFER-POTATOES
 (params nil)
 (preconds
  (raw potatoes))
 (effects
  ((add (micro-cook potatoes high 10))
   (add (seasoned potatoes))
   (add (steam potatoes 45)))))

(INFER-FISH
 (params nil)
 (preconds 
  (raw fish))
 (effects
  ((add (panfry fish 5))
   (add (bake fish 350 20))
   (add (boil fish 15))
   (add (clean fish)))))

(INFER-BROCCOLI
 (params nil)
 (preconds
  (raw broccoli))
 (effects ((add (steam broccoli 15))
	   (add (panfry broccoli 10)))))


(INFER-CORN-ON-THE-COB
 (params nil)
 (preconds
  (raw corn-on-the-cob))
 (effects ((add (boil corn-on-the-cob 10)))))


(INFER-RICE
 (params nil)
 (preconds
  (raw rice))
 (effects ((add (steam rice 25))
	   (add (clean rice))
	   (add (seasoned rice)))))



; Inference that <food> is ready to be put in a salad 

(INFER-PREP-FOR-SALAD
 (params (<food>))
 (preconds (and
	    (clean <food>)
	    (chopped <food>)))
 (effects ((add (salad-prep <food>)))))




; Inference of available kitchen appliances

(INFER-APPLIANCES
 (params nil)
 (preconds (kitchen appliances))
 (effects ((add (have oven))
	   (add (have range1))
	   (add (have range2))
	   (add (have toaster))
	   (add (have microwave-oven)))))



; Inferences about idle kitchen appliances

(INFER-IDLE-NOT-IN-USE
 (params (<app>))
 (preconds (and
	    (have <app>)
	    (~(free <app> <anytime>))))
 (effects ((add (idle <app>)))))

(INFER-IDLE-IN-USE
 (params (<app>))
 (preconds (and 
	    (have <app>)
	    (clock <time>)
	    (free <app> <outtime>)
	    (less-than <outtime> <time>)))
 (effects ((add (idle <app>)))))


;;; Inference that there is enough time to do something that 
;;; takes <addtime> minutes

(INFER-HAVE-TIME
 (params (<nowtime> <addtime>))
 (preconds (and
	    (finish-by <endtime>)
	    (add-time <nowtime> <addtime> <newtime>)
	    (less-than <newtime> <endtime>)))
 (effects ((add (clock <newtime>))
	   (add (have-time <nowtime> <addtime>)))))



;;; Inferences that if <food> is baked, boiled, steamed, microwaved,
;;; or panfried, then it is cooked.

(INFER-BAKE-COOK
 (params (<food>))
 (preconds (baked <food>))
 (effects ((add (cooked <food>)))))

(INFER-STEAM-COOK
 (params (<food>))
 (preconds (steamed <food>))
 (effects ((add (cooked <food>)))))

(INFER-MICRO-COOK
 (params (<food>))
 (preconds (microwaved <food>))
 (effects ((add (cooked <food>)))))

(INFER-BOIL-COOK
 (params (<food>))
 (preconds (boiled <food>))
 (effects ((add (cooked <food>)))))

(INFER-PANFRY-COOK
 (params (<food>))
 (preconds (panfried <food>))
 (effects ((add (cooked <food>)))))


))








