;;; ~/my-domains/jobsite/sc-rules.lisp
;;;
;;; AUTHOR : Bruce LeSourd
;;;          c473ak
;;;
;;; DATE   : 5/12/91
;;;
;;; PROJECT - search control rules

(setq *SCR-NODE-SELECT-RULES* NIL)

(setq *SCR-GOAL-SELECT-RULES*
  '(
    (SELECT-FIRST-GOAL
     (lhs (and (current-node <node>)
	       (not-top-level-node <node>) ; optional 
	       (primary-candidate-goal <node> <goal>)))
     (rhs (select goal <goal>)))
    ))


(setq *SCR-OP-SELECT-RULES* NIL)
"
  '(
    ;; These SCRS are intended to prevent Prodigy from using
    ;; BUCKET-EXCAVATE to achieve AT-LOC subgoals.
    (USE-MOVE-RESOURCE-TO-POSITION-RESOURCE
     (LHS (and
	   (CURRENT-NODE <node>)
	   (CURRENT-GOAL <node> (at-loc <r-id> <coords> <time>))
	   (CANDIDATE-OP <node> move-resource)
	   (CANDIDATE-OP <node> bucket-excavate)
	   (KNOWN <node> (and
			  (resource <r-id> <r-dsc>)
			  (resource-type <r-dsc> <r-type>)
			  (~ (is-sub <r-type>))))))
     (RHS (SELECT OPERATOR move-resource)))

    (USE-MOVE-SUBCONTRACTOR-TO-POSITION-SUBCONTRACTOR
     (LHS (and
	   (CURRENT-NODE <node>)
	   (CURRENT-GOAL <node> (at-loc <sub-id> <coords> <time>))
	   (CANDIDATE-OP <node> move-subcontractor)
	   (KNOWN <node> (and
			  (resource <sub-id> <sub-dsc>)
			  (resource-type <sub-dsc> <sub-type>)
			  (is-sub <sub-type>)))))
     (RHS (SELECT OPERATOR move-subcontractor)))
	  
    )) "
(setq *SCR-BINDINGS-SELECT-RULES* NIL)
"This control rule produces (2) selections, and doesn't work.
  '(
    ;; If all necessary resources are already in position at the correct time
    ;; (at a location xy-adjacent to the coords being excavated, at the excavation
    ;; start time), then don't try to move them to another location - just excavate
    ;; from this one.
    (SELECT-CURRENT-EXCAVATION-RESOURCE-LOCATION-IF-POSS
     (LHS (and
	   (CURRENT-NODE <node>)
	   (CURRENT-GOAL <node> (ground <excavating-coords>))
	   (CURRENT-OP   <node> bucket-excavate)
	   (KNOWN <node> (and
			  (project-deadline <deadline>)
			  (project-space <space-dsc>)
			  (resource <excavator-id> <excavator-dsc>)
			  (resource-type <excavator-dsc> (subcontractor excavation))
			  (resource <bucket-id> <bucket-dsc>)
			  (resource-type <bucket-dsc> (equipment bucket-excavator))
			  (resource <truck-id> <truck-dsc>)
			  (resource-type <truck-dsc> (equipment dump-truck))
			  (xy-adjacent <excavating-coords> <excavator-coords> <space-dsc>)
			  (in-range <time-i> 2 <deadline>)
			  (forall (<time1>) (between-include-high <time-i> <time1> <deadline>)
				  (forall (<coords1>) (location <coords1> <space-dsc>)
					   (~ (at-loc <excavator-id> <coords1> <time1>))))
			  (forall (<time2>) (between-include-high <time-i> <time2> <deadline>)
				  (forall (<coords2>) (location <coords2> <space-dsc>)
					   (~ (at-loc <bucket-id> <coords2> <time2>))))
			  (forall (<time3>) (between-include-high <time-i> <time3> <deadline>)
				  (forall (<coords3>) (location <coords3> <space-dsc>)
					   (~ (at-loc <truck-id> <coords3> <time3>))))
			  (at-loc <excavator-id> <excavator-coords> <time-i>)
			  (at-loc <bucket-id>    <excavator-coords> <time-i>)
			  (at-loc <truck-id>     <excavator-coords> <time-i>)))))
					  
     (RHS (SELECT BINDINGS (<excavating-coords> <excavator-coords> <time-i> <excavator-id> <bucket-id> <truck-id>))))
    ))
"


(setq *SCR-NODE-REJECT-RULES* NIL)
(setq *SCR-GOAL-REJECT-RULES*
  '(
    ;; Once a location has been excavated, don't try to excavate it again.
    ;; This seems to be pretty effective.
    (DO-NOT-RE-EXCAVATE
     (LHS (and
	   (CURRENT-NODE <node>)
	   (KNOWN <node> (~ (SOLID <coords>)))))
     (RHS (REJECT GOAL (ground <coords>))))
	  
    ))
(setq *SCR-OP-REJECT-RULES*
  '(
    ;; These working SCRs prevent Prodigy from using BUCKET-EXCAVATE
    ;; to achieve (at-loc <id> <coords> <time>), significantly pruning
    ;; Prodigy's search.
    (DO-NOT-EXCAVATE-TO-MOVE
     (LHS (and
	   (CURRENT-NODE <node>)
	   (CURRENT-GOAL <node> (at-loc <id> <coords> <time>))))
     (RHS (REJECT OPERATOR bucket-excavate)))

    (DO-NOT-MOVE-POSITIONED-RESOURCE-TO-NEW-EXCAVATOR-LOCATION
     (LHS (and
	   (CURRENT-NODE <node>)
	   (CURRENT-GOAL <node> (ground <coords>))
	   (KNOWN <node> (and
			  (resource <excavator-id> ((subcontractor excavation) 0 0))
			  (resource <bucket-id> ((equipment bucket-excavator) 0 0))
			  (resource <truck-id> ((equipment dump-truck) 0 0))
			  (at-loc <excavator-id> <excavator-coords> <time-i>)
			  (at-loc <bucket-id>    <excavator-coords> <time-i>)
			  (at-loc <truck-id>     <excavator-coords> <time-i>)))
	   (CANDIDATE-BINDINGS <node>
			       (<coords> <excavator-coords> <time-i> <excavator-id> <bucket-id> <truck-id>))))
     (RHS (REJECT OPERATOR move-resource)))
			 
	   
    ))
(setq *SCR-BINDINGS-REJECT-RULES* NIL)
(setq *SCR-NODE-PREFERENCE-RULES* NIL)
(setq *SCR-GOAL-PREFERENCE-RULES* NIL)
(setq *SCR-OP-PREFERENCE-RULES* NIL)
(setq *SCR-BINDINGS-PREFERENCE-RULES* NIL)
"I get a weird Prodigy error - 'Cand [sic] find vals' on this SCR  '(
*** Another attempt at keeping Prodigy from excavating from impossible locations
*** at unattainable times.
    (PREFER-EXISTING-EXCAVATOR-LOCATION
     (LHS (and
	   (CURRENT-NODE <node>)
	   (CURRENT-GOAL <node> (ground <coords>))
	   (CURRENT-OP <node> bucket-excavate)
	   (KNOWN <node> (and
			  (project-space <space-dsc>)
			  (resource <excavator-id> ((subcontractor excavation) 0 0))
			  (resource <bucket-id> ((equipment bucket-excavator) 0 0))
			  (resource <truck-id> ((equipment dump-truck) 0 0))
			  (xy-adjacent <coords> <excavator-coords> <space-dsc>)
			  (at-loc <excavator-id> <excavator-coords> <time-i>)
			  (at-loc <bucket-id>    <excavator-coords> <time-i>)
			  (at-loc <truck-id>     <excavator-coords> <time-i>)))))
;;	   (CANDIDATE-BINDINGS <node>
;;			       (<coords> <excavator-coords> <time-i> <excavator-id> <bucket-id> <truck-id>))))
					  
     (RHS (PREFER BINDINGS
		  (<coords> <excavator-coords> <time-i> <excavator-id> <bucket-id> <truck-id>)
		  (<*coords> <*some-coords> <*some-time> <*some-excavator-id> <*some-bucket-id> <*some-truck-id>))))
			  
    ))
"




