;;; ~/my-domains/jobsite/functions.lisp
;;;
;;; AUTHOR : Bruce LeSourd
;;;          c473ak
;;;
;;; DATE   : 5/12/91
;;;
;;; PROJECT - function definitions

(defun resource-type (resource-dsc type)
  (cond ((is-variable resource-dsc)
	 'no-match-attempted)
	((is-variable type)
	 (list (list (list type (first resource-dsc)))))
	(T
	 (equal (first resource-dsc) type))))
	      
(defun material-type (material-dsc type)
  (cond ((is-variable material-dsc)
	 'no-match-attempted)
	((is-variable type)
	 (list (list (list type (first material-dsc)))))
	(T
	 (equal (first material-dsc) type))))
	      
(defun material-use-loc (material-dsc use-loc)
  (cond ((is-variable material-dsc)
	 'no-match-attempted)
	((is-variable use-loc)
	 (list (list (list use-loc (second material-dsc)))))
	(T
	 (if (eq use-loc 'offsite)
	     NIL
	   (equal (second material-dsc) use-loc)))))
	      
(defun is-sub (type)
  (let ((subcontractors '(excavation
			  steel
			  concrete)))
    (cond ((is-variable type)
	   (mapcar #'(lambda (sub)
		       (list (list type (list 'subcontractor sub))))
		   subcontractors))
	  (T
	   (eq (first type) 'subcontractor)))))
	
(defun in-range (arg start end)
  (cond ((or (is-variable start)
	     (is-variable end))
	 'no-match-attempted)
	((is-variable arg)
	 (let ((list-of-bindings NIL))
	   (dotimes (val (1+ (- end start)))
	     (setf list-of-bindings (append list-of-bindings
					    (list (list (list arg
							      (+ val start)))))))
	   list-of-bindings))
	(T
	 (and (<= start arg)
	      (>= end arg)))))

(defun schedule-operation (length
			   t0
			   start end
			   tf)
  (cond ((or (is-variable length)
	     (is-variable t0)
	     (is-variable tf))
	 'no-match-attempted)		;NYI
	((and (is-variable start)
	      (is-variable end))
	 (let ((list-of-bindings NIL))
	   (dotimes (val (+ 1 (- tf (+ length t0))))
	     (setf list-of-bindings (append list-of-bindings
					    (list (list (list start
							      (+ val t0))
							(list end
							      (+ val t0 length)))))))
	   list-of-bindings))
	((is-variable end)
	 (if (> (+ start length) tf)
	     NIL
	   (list (list (list end (+ start length))))))
	((is-variable start)
	 (if (< (- end length) t0)
	     NIL
	   (list (list (list start (- end length))))))
	(T
	 (and  (<= t0 start)
	       (= end (+ start length))
	       (<= end tf)))))

(defun latest (time &rest check-times)
  (cond ((is-variable time)
	 (list (list (list time
			   (apply #'max check-times)))))
	(T
	 (= time (apply #'max check-times)))))

(defun location (coords space-dsc)
  (cond ((is-variable space-dsc)
	 'no-match-attempted)
	((is-variable coords)
	 (let* ((x-grids (first space-dsc))
		(y-grids (second space-dsc))
		(bottom-floor (- 0 (third space-dsc)))
		(top-floor (1- (fourth space-dsc)))
		(total-floors (1+ (- top-floor bottom-floor)))
		(list-of-bindings NIL))
	   (dotimes (floor-count total-floors)
	     (dotimes (x-grid x-grids)
	       (dotimes (y-grid y-grids)
		 (setf list-of-bindings (append list-of-bindings
						(list (list (list coords
								  (list x-grid
									y-grid
									(+ floor-count bottom-floor))))))))))
	   list-of-bindings))
	(T
	 (if (eq coords 'offsite)
	     NIL
	   (let ((x-grids (first space-dsc))
		 (y-grids (second space-dsc))
		 (bottom-floor (- 0 (third space-dsc)))
		 (top-floor (1- (fourth space-dsc))))
	     (and (<= 0 (first coords))
		  (<= 0 (second coords))
		  (<= bottom-floor (third coords))
		  (>= x-grids (first coords))
		  (>= y-grids (second coords))
		  (>= top-floor (third coords))))))))
	 
(defun staging-location (coords space-dsc)
  (cond ((is-variable space-dsc)
	 'no-match-attempted)
	((is-variable coords)
	 (let ((x-grids (first space-dsc))
	       (y-grids (second space-dsc))
	       (zero-var-y-side NIL)
	       (max-x-var-y-side NIL)
	       (var-x-zero-side NIL)
	       (var-x-max-y-side NIL))
	   (dotimes (y-grid (1- y-grids))
	     (setf zero-var-y-side (append zero-var-y-side
					   (list (list (list coords
							     (list 0
								   y-grid
								   0))))))
	     (setf max-x-var-y-side (append max-x-var-y-side
					    (list (list (list coords
							      (list (1- x-grids)
								    (1+ y-grid)
								    0)))))))
	   (setf var-y-sides (append zero-var-y-side
				     max-x-var-y-side))
	   (dotimes (x-grid (1- x-grids))
	     (setf var-x-zero-side (append var-x-zero-side
					   (list (list (list coords
							     (list (1+ x-grid)
								   0
								   0))))))
	     (setf var-x-max-y-side (append var-x-max-y-side
					    (list (list (list coords
							      (list x-grid
								    (1- y-grids)
								    0)))))))
	   (setf var-x-sides (append var-x-zero-side
				     var-x-max-y-side))
	   (setf list-of-bindings (append var-y-sides var-x-sides))))
	(T
	 (if (eq coords 'offsite)
	     NIL
	   (let ((x-grids (first space-dsc))
		 (y-grids (second space-dsc)))
	     (and (= 0 (third coords))
		  (or (= 0 (first coords))
		      (= (1- x-grids) (first coords)))
		  (or (= 0 (second coords))
		      (= (1- y-grids) (second coords)))))))))

(defun building-location (coords space-dsc)
  (cond ((is-variable space-dsc)
	 'no-match-attempted)
	((is-variable coords)
	 (let ((locations (location coords space-dsc))
	       (staging-locations (staging-location coords space-dsc)))
	   (remove-if #'(lambda (location)
			  (member location staging-locations :test #'equal))
		      locations)))
	(T
	 (and (location coords space-dsc)
	      (not (staging-location coords space-dsc))))))

(defun add (arg1 arg2 result)
  (cond ((or (is-variable arg1)
	     (is-variable arg2))
	 'no-match-attempted)
	((is-variable result)
	 (list (list (list result (+ arg1 arg2)))))
	(T
	 (= (+ arg1 arg2) result))))

(defun below (below-coord above-coord)
  (cond ((and (is-variable below-coord)
	      (is-variable above-coord))
	 'no-match-attempted)
	((is-variable below-coord)
	 (if (eq above-coord 'offsite)
	     NIL
	   (list (list (list below-coord (list (first above-coord)
						(second above-coord)
						(1- (third above-coord))))))))
	((is-variable above-coord)
	 (if (eq below-coord 'offsite)
	     NIL
	   (list (list (list above-coord
			     (list (first below-coord)
				   (second below-coord)
				   (1+ (third below-coord))))))))
	(T
	 (if (or (eq below-coord 'offsite)
		 (eq above-coord 'offsite))
	     NIL
	   (and (= (first below-coord)
		   (first above-coord))
		(= (second below-coord)
		   (second above-coord))
		(= 1 (abs (- (third below-coord)
			     (third above-coord)))))))))

(defun can-share-space (type1 type2)
  (cond ((or (is-variable type1)
	     (is-variable type2))
	 'no-match-attempted)		;NYI
	((or (atom type1)
	     (atom type2))
	 T)
	(T
	 (let ((super-type1 (first type1))
	       (sub-type1 (second type1))
	       (super-type2 (first type2))
	       (sub-type2 (second type2)))
	   (or (eq super-type1 'subcontractor)
	       (eq super-type2 'subcontractor)
	       (and (eq sub-type1 bucket-excavator)
		    (eq sub-type2 dump-truck))
	       (and (eq sub-type2 bucket-excavator)
		    (eq sub-type1 dump-truck))
	       (and (eq sub-type1 concrete-mixer)
		    (eq sub-type2 concrete-pumper))
	       (and (eq sub-type2 concrete-mixer)
		    (eq sub-type1 concrete-pumper)))))))

(defun adjacent (coord1 coord2)
  (cond ((or (is-variable coord1)
	     (is-variable coord2))
	 'no-match-attempted)		;NYI
	(T
	 (if (or (eq coord1 'offsite)
		 (eq coord2 'offsite))
	     NIL
	   (and (= 1 (abs (- (third coord1) (third coord2))))
		(= 1 (abs (- (first coord1) (first coord2))))
		(= 1 (abs (- (second coord1) (second coord2)))))))))
	      
(defun is-at-ground-level (coord)
  (cond ((is-variable coord)
	 'no-match-attempted)
	(T
	 (if (eq coord 'offsite)
	     T
	   (= 0 (third coord))))))

(defun is-above-ground (coord)
  (cond ((is-variable coord)
	 'no-match-attempted)
	(T
	 (if (eq coord 'offsite)
	     NIL
	   (< 0 (third coord))))))

(defun is-below-ground (coord)
  (cond ((is-variable coord)
	 'no-match-attempted)
	(T
	 (if (eq coord 'offsite)
	     NIL
	   (> 0 (third coord))))))




