
(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
;  standard choice rule for Prodigy.
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))

(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES*
; To save time, let the gangster with the crowbar force drawers. 
      '((ASSIGN-CROWBAR-HOLDER-TO-FORCE
	 (lhs (and (current-node <node>)
	           (on-goal-stack <node> (unlocked <place>))
	           (current-op <node> FORCE-DRAWER)
	           (known <node> (holding CROWBAR <person>))))
	 (rhs (select bindings (<person> <place>))))

; To save time, let the gangster with the crowbar collect the money.
	(ASSIGN-CROWBAR-HOLDER-TO-WITHDRAW
	 (lhs (and (current-node <node>)
	           (on-goal-stack <node> (empty <place>))
	           (current-op <node> WITHDRAW)
	           (known <node> (holding CROWBAR <person>))))
	 (rhs (select bindings (<person> <place>))))

; Have only one gangster cover the civilians, allowing the other crooks to
;  remain unoccupied.
	(ONE-GANGSTER-FOR-ALL-CIVILIANS
	 (lhs (and (current-node <node>)
	           (current-goal <node> (covered <gangster> <civ1>))
	           (current-op <node> COVER)
	           (known <node> (covered <gangster> <civ2>))))
	 (rhs (select bindings (<gangster> <civ1>))))

; Have the gangster currently holding civilians at bay control the 
;  movement of all civilians.
	(HAVE-HOSTAGE-HOLDER-CONTROL-CIVILIANS
	 (lhs (and (current-node <node>)
	           (current-goal <node> (near <place1> <civ1>))
	           (current-op <node> MOVE-CIVILIAN)
	           (known <node> (covered <gangster> <civ2>))))
	 (rhs (select bindings (<gangster> <civ1> <place1>))))

; Prevent robber from exchanging items he will need shortly.
	(KEEP-NEEDED-COLLECTION-TOOLS
	 (lhs (and (current-node <node>)
	           (current-goal <node> (holding BAG <gangster1>))
	           (current-op <node> EXCHANGE)
	           (known <node> (and (holding CROWBAR <gangster1>)
				      (holding BAG <gangster2>)
				      (holding <obj> <gangster1>)))))
	 (rhs (select bindings (<gangster1> <obj> <gangster2> BAG))))
	))

(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* 
; Avoid the dreaded Not subgoal.
	'((EXIT-BEFORE-NULLIFY
	   (lhs (and (current-node <node>)
		   (current-op <node> SHOOT)
	           (primary-candidate-goal <node> (~(civilian)))))
	   (rhs (reject goal (~(civilian)))))
	))

(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* 
; An occupied gangster cannot move from his position.
      '((BUSY-GANGSTER-CANT-MOVE
	 (lhs (and (current-node <node>)
	           (current-op <node> MOVE)
	           (candidate-bindings <node> (<gangster> <station>))
	           (known <node> (busy <gangster>))))
	 (rhs (reject bindings (<gangster> <station>))))
	))

(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  
; If a choice exists, get needed equipment before going anywhere.
      '((GET-BEFORE-GO
	 (priority 0)
	 (lhs (and (current-node <node>)
	           (candidate-goal <node> (holding <person> <obj>))
	           (candidate-goal <node> (near <place> <person>))))
	 (rhs (prefer goal (holding <person> <obj>)
	                   (near <place> <obj>))))

; Control all civilians before collecting money.
	(FREEZE-BEFORE-WITHDRAWALS
	 (priority 0)
	 (lhs (and (current-node <node>)
	           (candidate-goal <node> (cleaned-out))
	           (candidate-goal <node> (civilians-frozen))))
	 (rhs (prefer goal (civilians-frozen)
	                   (cleaned-out))))

	(EXIT-BEFORE-NULLIFY2
	 (priority 0)
	   (lhs (and (current-node <node>)
		     (current-op <node> FLEE)
		     (candidate-goal <node> (outside <gangster>))
	             (candidate-goal <node> (~(criminal <gangster>)))))
	   (rhs (prefer goal (outside <gangster>) (~(criminal <gangster>)))))
	))

(setq *SCR-OP-PREFERENCE-RULES* 
; Force a civilian to move instead of moving a gangster.
      '((MOVE-CIVILIAN-OVER-TRANS
	 (priority 0)
	 (lhs (and (current-node <node>)
	           (current-goal <node> (near <place1> <place2>))
	           (candidate-op <node> TRANSITIVE-LOCATION)
	           (candidate-op <node> MOVE-CIVILIAN)
	           (known <node> (or (civilian <place1>)
				  (civilian <place2>)))
	           (known <node> (covered <civ> <crook>))))
	 (rhs (prefer operator MOVE-CIVILIAN MOVE)))
	))

;; Check to see if in the same place before moving.
;      (TRANS-OVER-MOVE
;	 (priority 1)
;	 (lhs (and (current-node <node>)
;	           (current-goal <node> (near <x> <z>))
;	           (candidate-op <node> MOVE)
;	           (candidate-op <node> TRANSITIVE-LOCATION)
;	           (known <node> (and (near <x> <y>)
;				      (near <y> <z>)))))
;	 (rhs (prefer operator TRANSITIVE-LOCATION MOVE)))

;	))

(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)


