
; *** HEIST ***
; Domain file


;*********************************************
;                  OPERATORS
;*********************************************

(setq *OPERATORS* '(
		    
; *** EXCHANGE ***
; Exchange allows two gangsters to swap objects.

(EXCHANGE
 (params (<gangster1> <obj1> <gangster2> <obj2>))

 (preconds (and (object <obj1>)
	        (object <obj2>)
	        (criminal <gangster1>)
	        (criminal <gangster2>)	        
	        (holding <obj1> <gangster1>) 
	        (holding <obj2> <gangster2>)
	        (~ (busy <gangster1>))
	        (~ (busy <gangster2>))
	        (~ (is-equal <obj1> <obj2>))
	        (~ (is-equal <gangster1> <gangster2>))))
 (effects ((add (holding <obj1> <gangster2>))
	   (add (holding <obj2> <gangster1>))
	   (del (holding <obj1> <gangster1>))
	   (del (holding <obj2> <gangster2>)))))


; *** STICK-EM-UP ***
; Stick-em-up assures that all civilians within the bank are 
; being covered by at least one gangster.

(STICK-EM-UP
 (params (<employee> <gangster>))
 (preconds (forall (<employee>) (free <employee>) 
		     (covered <gangster> <employee>)))
 (effects ((add (busy <gangster>))
	   (add (civilians-frozen)))))


; *** COVER ***
; Cover has a robber hold a civilian at bay with a weapon.

(COVER
 (params (<gangster> <employee>))
 (preconds (and (all-clear)
	        (civilian <employee>)
	        (large-weapon <obj1>)
	        (holding <obj1> <gangster>)
	        (near <employee> <gangster>)))
 (effects ((add (busy <gangster>))
	   (del (free <employee>))
	   (add (covered <gangster> <employee>)))))


; *** COAST-IS-CLEAR ***
; Coast-is-Clear assures that all law enforcement personnel are dealt with
;  prior to collecting money or hostages.

(COAST-IS-CLEAR
 (params (<cop>))
 (preconds
  (forall (<cop>) (lawman <cop>) (or (outside <cop>)
				     (dead <cop>))))
 (effects ((add (all-clear)))))


; *** SHOOT ***
; Shoot has a criminal or lawman fire bullets at a member of
; the opposing side.

(SHOOT
 (params (<shooter> <target>))
 (preconds (and (or (and (criminal <shooter>) (or (lawman <target>)
						  (civilian <target>)))
		    (and (lawman <shooter>) (criminal <target>)))
	        (holding <firearm> <shooter>)
	        (weapon <firearm>)
	        (and (~(away <target>)) (~(away <shooter>)))
	        (or (and (outside <shooter>) (or (outside <target>)
						 (in-car <target>)))
		    (and (inside <shooter>) (inside <target>)))))
 (effects ((add (dead <target>))
	   (if  (criminal <target>) (del (criminal <target>)))
	   (if  (leader <target>)   (add (panic-stricken)))
	   (if  (leader <target>)   (del (leader <target>)))
	   (if  (lawman <target>)   (del (lawman <target>)))
	   (if  (civilian <target>) (del (civilian <target>)))
	   (if  (inside <target>)   (del (inside <target>)))
	   (if  (outside <target>)  (del (outside <target>))))))


; *** CLEANOUT ***
; Cleanout assure that all positions in the bank that hold money are 
; emptied by the robbers.

(CLEANOUT
 (params (<place>))
 (preconds (and
	    (all-clear)
	    (forall (<place>) (money-location <place>) (empty <place>))))
 (effects ((add (cleaned-out)))))


; *** WITHDRAW ***
; Withdraw has a robber remove the money from a position in the bank.

(WITHDRAW
 (params (<gangster> <station>))
 (preconds (and (money-location <station>)
		(container <bag>)
		(~(busy <gangster>))
		(holding <bag> <gangster>)
		(unlocked <station>)
		(full <station> <cash>)
		(near <station> <gangster>)))
 (effects ((add (empty <station>))
	   (add (robbery-ended))
	   (add	(bagged <cash> <bag>))
	   (del (full <station> <cash>)))))


; *** FORCE-DRAWER ***
; Force-Drawer has a robber use a crowbar to open a locked drawer.

(FORCE-DRAWER
 (params (<gangster> <station>))
 (preconds (and (criminal <gangster>)
		(holding CROWBAR <gangster>)
		(light-lock <station>)
		(near <station> <gangster>)))
 (effects ((add (unlocked <station>)))))


; *** DETONATE ***
; Detonate has a robber use explosives to force open the vault.

(DETONATE
 (params (<tnt> <gangster> <strongbox>))
 (preconds (and (explosive <tnt>)
		(holding <tnt> <gangster>)
		(sealed <strongbox>)
		(near <strongbox> <gangster>)))
 (effects ((add (unlocked <strongbox>))
	   (del (sealed <strongbox>))
	   (del (holding <tnt> <gangster>)))))


; *** TAKEOVER ***
; Takeover has all robbers, except for the driver, enter the bank.

(TAKEOVER
 (params ())
 (preconds (forall (<gangster>) (outside <gangster>) (inside <gangster>)))
 (effects ((add (robbery-ended)) (add (robbery-in-progress)))))


; *** ENTER-BANK ***
; Enter-bank has a criminal or lawman enter the bank.

(ENTER-BANK
 (params (<person>))
 (preconds (outside <person>))
 (effects ((del (outside <person>))
	   (add (near entrance <person>))
	   (add (inside <person>))
	   (if (and (all-clear) 
		    (lawman <person>)) (del (all-clear))))))


; *** CLOSE-IN ***
; Close-In brings all the lawman from a distance to the bank.
(CLOSE-IN
 (params ())
 (preconds (and (robbery-in-progress)
	        (forall (<cop>) (away <cop>) (outside <cop>))))
 (effects ((add (surrounded)))))

; *** ADVANCE ***
; Advance has a lawman move towards the bank.
(ADVANCE
 (params (<person>))
 (preconds (away <person>))
 (effects ((del (away <person>))
	   (add (outside <person>)))))


; *** GETAWAY ***
; Getaway puts all possible robbers in the car puts the pedal to the metal.

;(GETAWAY
; (params ())
; (preconds (and (on-the-lam)
;              (forall (<gangster>) (outside <gangster>) (in-car <gangster>))))
; (effects ((add (scot-free)))))

; *** PILE-IN ***
; Pile-In has a gangster get into the getaway car.

;(PILE-IN
; (params (<gangster>))
; (preconds (and (criminal <gangster>)
;	        (outside <gangster>)))
; (effects ((del (outside <gangster>))
;	   (add (in-car <gangster>)))))


; *** FLEE ***
; Flee has all criminals exit the bank immediately.

(FLEE
 (params ())
 (preconds (and (or (robbery-ended) 
		    (panic-stricken))
	       (all-clear)
	       (forall (<gangster>) (inside <gangster>) (in-car <gangster>))))
 (effects ((add (on-the-lam)))))


; *** EXIT-BANK ***
; Exit-Bank has a criminal or lawman leave the bank.
(EXIT-BANK
 (params (<person>))
 (preconds (and (all-clear)
	        (inside <person>)))
 (effects ((add (outside <person>))
	   (if (busy <person>) (del (busy <person>)))
	   (del (inside <person>))
	   (del (near <*old-nears> <person>))
	   (del (near <person> <*old-nears>)))))


; *** MOVE ***
; Move has a robber change positions in the bank.

(MOVE
 (params (<gangster> <new-position>))
 (preconds  (and (criminal <gangster>)
	         (inside <gangster>)
	         (~(busy <gangster>))
		 (~(near <new-position> <gangster>))))
 (effects ((del (near <*old-nears> <gangster>))
	   (del (near <gangster> <*old-nears>))
	   (add (near <gangster> <new-position>))
	   (add (near <new-position> <gangster>)))))


; *** TRANSITIVE-LOCATION ***
; An inactive check to see if two things are, by transitive law, near
;  each other.

(TRANSITIVE-LOCATION
 (params (<loc1> <loc2> <loc3>))
 (preconds (and (near <loc1> <loc2>)
	        (near <loc2> <loc3>)
	        (inside <loc1>)
	        (inside <loc2>)
	        (inside <loc3>)
	        (isnt-both (money-location <loc1>) (money-location <loc2>))
	        (~ (is-equal <loc1> <loc3>))))
 (effects ((add (near <loc1> <loc3>))
	   (add (near <loc3> <loc1>)))))


; *** MOVE-CIVILIAN ***
; Move-Civilian has a robber force a civilian to change positions in the bank.

(MOVE-CIVILIAN
 (params (<gangster> <employee> <new-position>))
 (preconds (and (criminal <gangster>)
		(civilian <employee>)
		(weapon <firearm>)
		(holding <firearm> <gangster>)
	        (~ (is-equal <employee> <new-position>))
		(~ (is-equal <gangster> <new-position>))))
 (effects ((del (near <employee> <*old-nears>))
	   (del (near <*old-nears> <employee>))
           (add (near <new-position> <employee>)))))

))

; ************************************************
;             INFERENCE RULES
; ************************************************

(setq *INFERENCE-RULES* '(

(INFER-OBJECT
 (params (<ob>))
 (preconds
  (or (tool <ob>) 
      (small-weapon <ob>) 
      (large-weapon <ob>) 
      (container <ob>)
      (explosive <ob>))) 
 (effects ((add (object <ob>)))))

(INFER-LOCATION
 (params (<place>))
 (preconds (money-location <place>))
 (effects ((add (location <place>)))))	  

(INFER-OUTSIDE
 (params (<person>))
 (preconds (or (away <person>)
	       (in-car <person>)))
 (effects ((add (outside <person>)))))	  
 
(INFER-INSIDE
 (params (<person>))
 (preconds (and (or (location <place>)
		    (money-location <place>))
	        (near <place> <person>)))
 (effects ((add (inside <person>)))))

(INFER-WEAPON
 (params (<ob>))
 (preconds
  (or (small-weapon <ob>) 
      (large-weapon <ob>))) 
 (effects ((add (weapon <ob>)))))

	     
;(INFER-SAME-LOCATION
; (params (<a> <b> <c>))
; (preconds
;  (and (near <c> <a>)
;       (near <c> <b>)))
; (effects ((add (near <a> <b>)))))

;(INFER-SYMMETRIC-LOCATION
; (params (<a> <b>))
; (preconds (near <a> <b>))
; (effects ((add (near <b> <a>)))))

))




