#|
*******************************************************************************
Gate-World
 Dave's version of digital circuit design

*******************************************************************************|#


; Operators

(setq *INFERENCE-RULES* '(


))

(setq *OPERATORS* '(



(INFER-SWITCH
 (params (<swname> <case> <value>))
 (preconds
  (and 
   (SWITCH <swname>)
   (~ (exists (<value-for>) (RS <case> <swname> <value-for>)))
   
   ))
 (effects
  ((add (LS <case> <swname> <value>))
   (add (RS <case> <swname> <value>))
)))


(INFER-NOT-CONNECTED
 (params (<gatename> <input>))
 (preconds
  (~ (exists (<con-to>) (CONN <gatename> <input> <con-to>))))
 (effects
  ((add (CONN <gatename> <input> N))
)))


(CONNECT-TO-AND-H
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (AND-G <gate>)
   (CONN <gate> 1 N)
   (or (SWITCH <new1>)
       (AND-G <new1>)
       (OR-G <new1>)
       (INV-G <new1>))
   (not-equals <new1> <gate>)
   (RS <case> <new1> H)
   (CONN <gate> 2 N)
   (or (SWITCH <new2>)
       (AND-G <new2>)
       (OR-G <new2>)
       (INV-G <new2>))
   (not-equals <new2> <gate>)
   (RS <case> <new2> H)
))
 (effects
  ((del (CONN <gate> 1 N))
   (add (CONN <gate> 1 <new1>))
   (del (CONN <gate> 2 N))
   (add (CONN <gate> 2 <new2>))
   (add (RS <case> <gate> H))
)))

(CONNECT-TO-AND-L
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (AND-G <gate>)
   (CONN <gate> 1 N)
   (or (SWITCH <new1>)
       (AND-G <new1>)
       (OR-G <new1>)
       (INV-G <new1>))
   (not-equals <new1> <gate>)
   (CONN <gate> 2 N)
   (or (SWITCH <new2>)
       (AND-G <new2>)
       (OR-G <new2>)
       (INV-G <new2>))
   (not-equals <new2> <gate>)
   (or (RS <case> <new1> L)
       (RS <case> <new2> L))
)) 
(effects
  ((del (CONN <gate> 1 N))
   (add (CONN <gate> 1 <new1>))
   (del (CONN <gate> 2 N))
   (add (CONN <gate> 2 <new2>))
   (add (RS <case> <gate> L))
)))

(VERIFY-AND-L
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (AND-G <gate>)
   (CONN <gate> 1 <new1>)
   (not-equals <new1> N)
   (CONN <gate> 2 <new2>)
   (not-equals <new2> N)
   (or (RS <case> <new1> L)
       (RS <case> <new2> L))
))
 (effects
  ((add (RS <case> <gate> L))
)))

(VERIFY-AND-H
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (AND-G <gate>)
   (CONN <gate> 1 <new1>)
   (not-equals <new1> N)
   (CONN <gate> 2 <new2>)
   (not-equals <new2> N)
   (RS <case> <new1> H)
   (RS <case> <new2> H)
))
 (effects
  ((add (RS <case> <gate> H))
)))

(CONNECT-TO-OR-L
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (OR-G <gate>)
   (CONN <gate> 1 N)
   (or (SWITCH <new1>)
       (AND-G <new1>)
       (OR-G <new1>)
       (INV-G <new1>))
   (not-equals <new1> <gate>)
   (RS <case> <new1> L)
   (CONN <gate> 2 N)
   (or (SWITCH <new2>)
       (AND-G <new2>)
       (OR-G <new2>)
       (INV-G <new2>))
   (not-equals <new2> <gate>)
   (RS <case> <new2> L)
))
 (effects
  ((del (CONN <gate> 1 N))
   (add (CONN <gate> 1 <new1>))
   (del (CONN <gate> 2 N))
   (add (CONN <gate> 2 <new2>))
   (add (RS <case> <gate> L))
)))

(CONNECT-TO-OR-H
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (OR-G <gate>)
   (CONN <gate> 1 N)
   (or (SWITCH <new1>)
       (AND-G <new1>)
       (OR-G <new1>)
       (INV-G <new1>))
   (not-equals <new1> <gate>)
   (CONN <gate> 2 N)
   (or (SWITCH <new2>)
       (AND-G <new2>)
       (OR-G <new2>)
       (INV-G <new2>))
   (not-equals <new2> <gate>)
   (or (RS <case> <new1> H)
       (RS <case> <new2> H))
)) 
(effects
  ((del (CONN <gate> 1 N))
   (add (CONN <gate> 1 <new1>))
   (del (CONN <gate> 2 N))
   (add (CONN <gate> 2 <new2>))
   (add (RS <case> <gate> H))
)))

(VERIFY-OR-H
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (OR-G <gate>)
   (CONN <gate> 1 <new1>)
   (not-equals <new1> N)
   (CONN <gate> 2 <new2>)
   (not-equals <new2> N)
   (or (RS <case> <new1> H)
       (RS <case> <new2> H))
))
 (effects
  ((add (RS <case> <gate> H))
)))

(VERIFY-OR-L
 (params (<gate> <new1> <new2>))
 (preconds
  (and
   (OR-G <gate>)
   (CONN <gate> 1 <new1>)
   (not-equals <new1> N)
   (CONN <gate> 2 <new2>)
   (not-equals <new2> N)
   (RS <case> <new1> L)
   (RS <case> <new2> L)
))
 (effects
  ((add (RS <case> <gate> L))
)))

(VERIFY-PROBE
 (params (<pname> <new>))
 (preconds
  (and
   (PROBE <pname>)
   (CONN <pname> 1 <new>)
   (not-equals <new> N)
   (RS <case> <new> <value>)))
 (effects
  ((add (RS <case> <pname> <value>))
)))


(VERIFY-INV
 (params (<iname> <new>))
 (preconds
  (and
   (INV-G <iname>)
   (CONN <iname> 1 <new>)
   (not-equals <new> N)
   (invert-state <value> <inverted-value>)
   (RS <case> <new> <inverted-value>)))
 (effects
  ((add (RS <case> <iname> <value>))
)))


(CONNECT-TO-PROBE
 (params (<pname> <new>))
 (preconds
  (and
   (PROBE <pname>)
   (CONN <pname> 1 N)
   (or (SWITCH <new>)
       (AND-G <new>)
       (OR-G <new>)
       (INV-G <new>))
   (RS <case> <new> <value>)))
 (effects
  ((del (CONN <pname> 1 N))
   (add (CONN <pname> 1 <new>))
   (add (RS <case> <pname> <value>))
)))

(CONNECT-TO-INV
 (params (<iname> <new>))
 (preconds
  (and
   (INV-G <iname>)
   (CONN <iname> 1 N)
   (or (SWITCH <new>)
       (AND-G <new>)
       (OR-G <new>)
       (INV-G <new>))
   (invert-state <value> <inverted-value>)
   (RS <case> <new> <inverted-value>)))
 (effects
  ((del (CONN <iname> 1 N))
   (add (CONN <iname> 1 <new>))
   (add (RS <case> <iname> <value>))
)))


))


