M;; After MANY painful hours of debugging, I found it was totally
;; impossible for me to write search controls that worked.
;; here is some pseudocode of stuff I tried to do but failed in
;; all cases.  If they were actually implemented, however, they would
;; fail to work.  Such is the nature of prodigy.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; DONT PLANT BEFORE POSSIBLE:
;;
;; this sc-rule ensures that nothing is planted later than it is
;; possible for it to reach maturity.  It takes the time of harvest
;; and makes sure that it is at least the growth cycle time, meaning
;; we would have to plant it at time 1, or greater.  this limits
;; futile paths such as trying to plant something that takes 3 to grow
;; at time= 2.
;; 
	(DONT-PLANT-BEFORE-POSSIBLE
	 (lhs (and 
	       (current-node <node>)
	       (current-op <node> HARVEST)
	       (candidate-bindings <node> (<crop1> <x> <y> <time>))
	       (known <node> (growth <crop1> <growth>))
	       (known <node> (earlier <time> <growth>))))
	 (rhs (reject bindings (<crop1> <x> <y> <time>))))

(

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; DONT-PLANT-IF-THERES-SOMETHING-THERE
;; 
;; a lot of the time of the search is spent looking for something
;; in squares that things are already planted in.  This should limit
;; the search within these futile squares by rejecting the harvesting
;; of any square where the current-growth is not 0 (meaning nothing
;; has been planted or is growing there already)  I tried for over
;; 20 hours , unsuccessfully , to implement this search control rule.
;;

(DONT-PLANT-IF-THERES-SOMETHING-THERE
 (lhs (and
       (current-node <node>)
       (current-op <node> HARVEST)
       (candidate-bindings <node> (<crop1> <x> <y> <time>))
       (known <node> (current-growth <x> <y> <time> 0))))
                                                        
(rhs (reject bindings (<crop1> <x> <y> <time>))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; PRUNE-WATER-SEARCH
;;
;; One of the problems with this domain is that in order to achieve
;; a good growth of a square, you have to have good water at that
;; square. (usually)  Since one of the preconditions for the
;; operation that makes good water (WATER) in a square is 
;; has-water, it tends to spend a lot of time looking for ways
;; to achieve this, repetitively.  This operator says "if 
;; the current amount of water isn't in the state currently, 
;; don't try to subgoal on it.

(PRUNE-WATER-SEARCH
 (lhs 
  (and
   (current-node <node>)
   (current-op   <node> WATER)    ;; if the current op is water , and
   (candidate-op <node> WATER)))  ;; the node we're considering is water
 (rhs (reject op WATER)))         ;; then don't subgoal on the second water

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; PRUNE-FERT-SEARCH
;;
;; The arguments for this are somewhat similar to that of prune-water-search
;; Since we spend a lot of time trying to figure out whether we can plant
;; or not, we don't constantly want to be subgoaling on the operator's
;; precondition which is the same operator.  This should prune that
;; from happening as much.


(PRUNE-FERT-SEARCH
 (lhs 
  (and
   (current-node <node>)
   (current-op   <node> FERTILIZE)    ;; if the current op is fertilize , and
   (candidate-op <node> FERTILIZE)))  ;; the node we're considering is fertiliz
 (rhs (reject op FERTILIZE)))         ;; then don't subgoal on the second water

 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; CANT-ACHIEVE-ZERO-STATE
;;
;; Some amount of time is spent trying to backchain from the harvest
;; process to the planting process, realizing that you can't grow something
;; from a "zero" state (unplanted) to a "one" state (just planted)  
;; this rule should avoid trying to achieve the 0 state.

(CANT-ACHIEVE-ZERO-STATE
 (LHS
  (and (current-node <node>)
       (current-goal <node> (CURRENT-GROWTH <crop1> <x> <y> <time> 0))))
 (RHS (reject node <node>)))


       
       