(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES*                   ; Standard rule
      '((SELECT-FIRST-GOAL
	 (lhs (and (current-node <node>)
	       (not-top-level-node <node>)
	       (primary-candidate-goal <node> <goal>)))
	 (rhs (select goal <goal>)))
	))

(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)

(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES*
      '(


	;; Don't bother mounting an entity on a site that doesn't
	;; support one or more of the entity's required peripherals.
	;; This rule is only one which seems to have an great effect.

	(REJECT-SITE-WITH-NO-PERIPH-SUPPORT
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> mount-site)
	       (candidate-bindings <n> (<entity> <site>))
	       (known <n> (exists (<periph>) (is-periph <periph>)
			   (and
			    (drives-periph <entity> <periph>)
			    (~ (supports-periph <site> <periph>)))))))
	 (rhs (reject bindings (<entity> <site>))))



	;; Sanity check.

	(REJECT-SHARED-SITE-WHEN-BOTH-CANT-FIT
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> mem-connect)
	       (candidate-bindings <n> (<entity1> <req1> <entity2> <req2>))
	       (known <n> (and
			   (is-entity <entity1> <req1>)
			   (is-entity <entity2> <req2>)
			   (diff <entity1> <entity2>)))
	       (candidate-bindings <n> (<site> <max>))
	       (known <n> (and
			   (is-dist-site <site> <max>)
			   (new-work-load <req1> <req2> <combined>)
			   (above <combined> <max>)))))
	 (rhs (reject bindings (<site> <max>))))

	))

(setq *SCR-NODE-PREFERENCE-RULES* 
      '(
	
	))
(setq *SCR-GOAL-PREFERENCE-RULES* nil)

(setq *SCR-OP-PREFERENCE-RULES* 
      '(

	;; The idea is that inside the msg-path inference rule,
	;; two entities will have been chosen (by init state hack)
	;; such that they exchange msgs at high frequencies.
	;; Thus, we always try to share memory first, connect
	;; by network link second.

	(MAKE-TALKERS-SHARE-MEM
	 (priority 0)
	 (lhs (and
	       (current-node <n>)
	       (current-goal <n> (msg-path <e1> <e2>))
	       (candidate-op <n> net-connect)
	       (candidate-op <n> mem-connect)))
	 (rhs (prefer operator mem-connect net-connect)))


	))

(setq *SCR-BINDINGS-PREFERENCE-RULES*
      '(
	
	))







