;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; PRODIGY domain: distrib-software-config
;;;
;;; This problem spec exemplifies a large-scale
;;; configuration where entities have all possible needs.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(load-goal '(configured))


(load-start-state '(
		    ;; The static predicates - used as generators.
		    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		    ;;;; Declare the problem's software constituents.
		    ;;;; The number represents load requirements.
		    ;;;; PRODIGY forall cycles though bindings in
		    ;;;; alphabetic order, thus, i order entities'
		    ;;;; names in decreasing order of message passing
		    ;;;; frequency (in + out).

		    (is-entity participant1 4)      ;
		    (is-entity participant2 4)      ;
		    (is-entity participant3 4)      ;
		    (is-entity participant4 6)      ;
		    (is-entity participant5 6)      ;

		    (is-entity transducer1 3)       ;
		    (is-entity transducer2 3)       ;
		    (is-entity transducer3 2)       ;
		    (is-entity transducer4 2)       ;
		    (is-entity transducer5 2)       ;

		    (is-entity renderer1 8)         ;
		    (is-entity renderer2 8)         ;
		    (is-entity renderer3 8)         ;
		    (is-entity renderer4 10)        ;
		    (is-entity renderer5 10)        ;

		    (is-entity terrain1 3)          ;

		    (is-entity ferns1 4)            ;
		    (is-entity ferns2 5)            ;
		    (is-entity ferns3 6)            ;

		    (is-entity sprite1 3)           ;
		    (is-entity sprite2 10)          ;
		    (is-entity sprite3 15)          ;
		    

		    ;;;;
		    ;;;; Represent paths of inter-entity communication.

		    (is-sense visible)
		    (is-sense boundary)
		    (is-sense cause)

		    ;; The number represents message frequency.

		    (has-out-sense participant1 visible 8)
		    (has-out-sense participant2 visible 8)
		    (has-out-sense participant3 visible 8)
		    (has-out-sense participant4 visible 10)
		    (has-out-sense participant5 visible 10)

		    (has-out-sense participant3 boundary 3)
		    (has-out-sense participant4 boundary 3)
		    (has-out-sense participant5 boundary 4)

		    (has-in-sense participant1 cause)
		    (has-in-sense participant2 cause)
		    (has-in-sense participant3 cause)
		    (has-in-sense participant4 cause)
		    (has-in-sense participant5 cause)

		    (has-in-sense participant1 boundary)
		    (has-in-sense participant4 boundary)

		    (has-out-sense transducer1 cause 8)
		    (has-out-sense transducer2 cause 8)
		    (has-out-sense transducer3 cause 3)
		    (has-out-sense transducer4 cause 3)
		    (has-out-sense transducer5 cause 6)

		    (has-in-sense renderer1 visible)
		    (has-in-sense renderer2 visible)
		    (has-in-sense renderer3 visible)
		    (has-in-sense renderer4 visible)
		    (has-in-sense renderer5 visible)

		    (has-out-sense terrain1 visible 2)
		    (has-out-sense terrain1 boundary 10)
		    (has-in-sense terrain1 boundary)

		    (has-out-sense fern1 visible 8)
		    (has-out-sense fern2 visible 8)
		    (has-out-sense fern3 visible 7)

		    (has-out-sense sprite1 visible 2)
		    (has-out-sense sprite2 visible 5)
		    (has-out-sense sprite3 visible 10)

		    (has-in-sense sprite2 boundary)
		    (has-in-sense sprite3 boundary)


		    ;;;; Declare the problem's computer constituents.
		    ;;;; The number represents load capability.

		    (is-dist-site thumper 50)
		    (is-dist-site brooklyn 50)
		    (is-dist-site brillig 10)
		    (is-dist-site slithy 40)
		    (is-dist-site callay 20)
		    (is-dist-site bandersnatch 30)
		    (is-dist-site vorpal 20)
		    (is-dist-site frabjous 35)
		    

		    ;;;; Declare the problem's external device constituents.
		    ;;;; Further linkage constraints.

		    (is-periph eyephone1)
		    (is-periph eyephone2)
		    (is-periph eyephone3)
		    (is-periph eyephone4)

		    (is-periph polhemus1)
		    (is-periph polhemus2)
		    (is-periph polhemus3)

		    (is-periph dataglove1)
		    (is-periph dataglove2)
		    (is-periph wand1)
		    (is-periph wand2)
		    (is-periph spaceboard1)

		    (drives-periph renderer1 eyephone1)
		    (drives-periph renderer1 polhemus1)

		    (drives-periph renderer2 eyephone2)
		    (drives-periph renderer2 polhemus2)

		    (drives-periph renderer3 eyephone3)
		    (drives-periph renderer3 polhemus3)

		    (drives-periph renderer4 eyephone4)

		    (drives-periph transducer1 dataglove1)
		    (drives-periph transducer2 dataglove2)
		    (drives-periph transducer3 wand1)
		    (drives-periph transducer4 wand2)
		    (drives-periph transducer5 spaceboard1)

		    
		    (supports-periph thumper eyephone1)
		    (supports-periph thumper eyephone4)
		    (supports-periph thumper polhemus1)

		    (supports-periph brooklyn eyephone2)
		    (supports-periph brooklyn eyephone3)
		    (supports-periph brooklyn polhemus2)
		    (supports-periph brooklyn polhemus3)

		    (supports-periph brillig dataglove1)
		    (supports-periph vorpal dataglove1)
		    (supports-periph slithy dataglove1)
		    (supports-periph callay dataglove1)

		    (supports-periph brillig dataglove2)
		    (supports-periph brooklyn dataglove2)
		    (supports-periph bandersnatch dataglove2)
		    (supports-periph frabjous dataglove2)

		    (supports-periph brillig polhemus1)
		    (supports-periph slithy dataglove1)
		    (supports-periph slithy polhemus1)

		    (supports-periph callay wand1)
		    (supports-periph brillig wand1)
		    (supports-periph vorpal wand1)

		    (supports-periph bandersnatch wand2)
		    (supports-periph frabjous wand2)
		    (supports-periph vorpal wand2)

		    (supports-periph thumper spaceboard1)
		    (supports-periph callay spaceboard1)
		    (supports-periph slithy spaceboard1)

		    ;; The non-static predicates - represent dynamic state.
		    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		    ;;
		    ;; Initialize state variables (maintained during solving).
		    ;;

		    (dist-site-load brillig 0)
		    (dist-site-load slithy 0)
		    (dist-site-load thumper 0)
		    (dist-site-load vorpal 0)
		    (dist-site-load callay 0)
		    (dist-site-load bandersnatch 0)
		    (dist-site-load brooklyn 0)
		    (dist-site-load frabjous 0)

		    ))


