;;;
;;; diff
;;;
;;; Used specifically for the sware-config prodigy domain
;;; to prevent reflexive operations.

(defun diff (obj1 obj2)
  (cond
    ((or (is-variable obj1) (is-variable obj2))
     'no-match-attempted)
    (t (not (equal obj1 obj2)))
    )
  )




;;;
;;; new-work-load
;;;
;;; performs addition of loads - generator for <new-load>

(defun new-work-load (old-load add-load new-load)
  (cond
    ((or (is-variable old-load) (is-variable add-load))
     'no-match-attempted)
    ((is-variable new-load)
     (binding-list new-load (list (+ old-load add-load))))
    (t
     (= new-load (+ old-load add-load))))
  )


;;;
;;; below
;;;
;;; performs less than for comparing work-loads

(defun below (cand-load max-load)
  (cond
    ((or (is-variable max-load) (is-variable cand-load))
     'no-match-attempted)
    (t
     (<= cand-load max-load)))
  )

(add-meta-fn 'below)


;;;
;;; above
;;;
;;; performs greater than for comparing work-loads

(defun above (cand-load max-load)
  (cond
    ((or (is-variable max-load) (is-variable cand-load))
     'no-match-attempted)
    (t
     (> cand-load max-load)))
  )

(add-meta-fn 'above)



;  BINDING-LIST returns a binding list for a single variable, only
;  snarfed from schedworld domain

(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))

(defun mult-binding-list (vars val-lists)
    (and vars
	 (g-loop (init ret-val nil vals (car val-lists) var (car vars)
		     rst-bindings (mult-binding-list (cdr vars) 
				      (cdr val-lists)))
	       (while vals)
	       (do (cond (rst-bindings
			     (setq ret-val 
				   (append
					  (g-map (b in rst-bindings)
						(save (cons (list var 
								  (car
								      vals)) b)))
					  ret-val)))
			 (t (push (list (list var (car vals))) ret-val))))
	       (next vals (cdr vals))
	       (result ret-val))))

