#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



;;;
;;; Geoffrey P. Coco
;;;
;;; The "distrib-software-config" domain
;;;
;;; CSE 473   Spring 1991
;;; University of Washington
;;;
;;; The DSC (distrib-software-config) is designed to optimally map a
;;; set of distributed software objects and their respective resource
;;; requirements onto a set of distributed hardware resources.
;;;





;;;;;;;;;;;;;;;;;
;;; Operators ;;;
;;;;;;;;;;;;;;;;;


(setq *OPERATORS* '(



;;;
;;; attach-periph
;;;
;;; Make symbolic link between a hardware peripheral and a
;;; distributed hardware node (eg. a workstation).

(ATTACH-PERIPH
 (params (<periph> <site>))
 (preconds (and
	    (supports-periph <site> <periph>)    ; Generates both fields.


	    ;; Sanity check, cannot be a subgoal.

	    (~ (exists (<site-other> <max>) (is-dist-site <site-other> <max>)
		(periph-attached <periph> <site-other>))))
  )
 (effects ((add (periph-attached <periph> <site>)))
  )
 )



;;;
;;; mount-site
;;;
;;; Associate a software object (entity) with a
;;; distributed hardware node (site).


(MOUNT-SITE
 (params (<entity> <site>))
 (preconds (and
	    (is-entity <entity> <require>)
	    (is-dist-site <site> <max-load>)


	    ;; Sanity check, cannot be a subgoal.

	    (~ (exists (<site-other> <max-other>)
		(is-dist-site <site-other> <max>)
		(mounted <entity> <site-other>)))


	    ;; Generate current site load uniquely with non-static predicate.

	    ;; Predicate dist-site-load is used as a state variable
	    ;; to track current work-load of each distributed node.

	    ;; Thus, Prodigy is garanteed to find exactly one
	    ;; binding of <old-load> for any <site>, and
	    ;; so will never sub-goal on this precondition.

	    (dist-site-load <site> <old-load>)



	    ;; Use lisp function to generate new-load.

	    (new-work-load <old-load> <require> <new-load>)
	    (below <new-load> <max-load>))

  )
 (effects ((add (mounted <entity> <site>))

	   ;; Update site load in state.

	   (del (dist-site-load <site> <old-load>))
	   (add (dist-site-load <site> <new-load>)))
  )
 )



;;;
;;; net-connect
;;;
;;; Symbolically link two entities which are destined
;;; live on different sites.  Accomplishes message passing.

(NET-CONNECT
 (params (<entity1> <entity2>))
 (preconds (and
	    (is-entity <entity1> <req1>)
	    (is-entity <entity2> <req2>)
	    (diff <entity1> <entity2>)

	    (exists (<site1>) (is-dist-site <site1> <max1>)
		    (and (mounted <entity1> <site1>)
			 (exists (<site2>) (is-dist-site <site2> <max2>)
				 (and (diff <site1> <site2>)
				      (mounted <entity2> <site2>)))))
	   ))
 (effects ((add (msg-path <entity1> <entity2>))
	   ))
 )


;;;
;;; mem-connect
;;;
;;; Symbolically link two entities which are destined
;;; live on the same site.  Accomplishes message passing.

(MEM-CONNECT
 (params (<entity1> <entity2>))
 (preconds (and
	    (is-entity <entity1> <req1>)
	    (is-entity <entity2> <req2>)
	    (diff <entity1> <entity2>)

	    (exists (<site>) (is-dist-site <site> <max>)
		    (and (mounted <entity1> <site>)
			 (mounted <entity2> <site>)))
	    ))
 (effects ((add (msg-path <entity1> <entity2>))
	   ))
 )


)) ; Operators





;;;;;;;;;;;;;;;;;;;;;;;
;;; INFERENCE RULES ;;;
;;;;;;;;;;;;;;;;;;;;;;;

(setq *INFERENCE-RULES* '(

;;;
;;; configure
;;;
;;; Describes the goal state for all problems.

(INFER-CONFIGURE
 (params nil)
 (preconds (forall (<entity1> <req1>) (is-entity <entity1> <req1>)
	    (and
	     
	     ;; Make sure each entity is message-connected to the
	     ;; other entities it requires for full functionality.
	     ;; This means a shared-memory link when entities are
	     ;; mounted on same dist-site, or network link when
	     ;; entities are mounted on distinct dist-sites.
	     
	     (msg-completed <entity1> <req1>)
	     
	     
	     
	     ;; Make sure each entity is linked to the periphs
	     ;; it requires for full functionality.
	     ;; This is a matter of the entity being mounted on
	     ;; the dist-site that the periph is attached to.
	     
	     (periph-completed <entity1> <req1>)))

  )
 (effects ((add (configured)))
  )
 )


 
;;;
;;; msg-complete
;;;
;;; Remove some clutter from infer-configured.
;;; Setup abstraction in order to prefer entity bindings.

(INFER-MSG-COMPLETE
 (params (<entity1> <req1>))
 (preconds (and
	    (is-entity <entity1> <req1>)    ; sanity check.
	    (or

	     ;;
	     ;; Check for trivial case - no outgoing messages.

	     (~ (exists (<sense>) (is-sense <sense>)
		(has-out-sense <entity> <sense> <freq>)))

	     
	     ;;
	     ;; Check connections with each entity.
	     
	     (forall (<entity2> <req2>) (is-entity <entity2> <req2>)
	      (or
	       
	       
	       ;;
	       ;; Avoid stupid wastes of valuable nodes.
	       
	       (~ (diff <entity1> <entity2>))
	       
	       
	       ;;
	       ;; Check for no message between entities, save nodes.
	       
	       (~ (exists (<sense1>) (is-sense <sense1>)
			  (and
			   (has-out-sense <entity1> <sense1> <freq1>)
			   (has-in-sense <entity2> <sense1>))))
	       
	       
	       ;;
	       ;; Subgoal to connect entities somehow
	       
	       (and
		(exists (<sense2>) (is-sense <sense2>)
			(and
			 (has-out-sense <entity1> <sense2> <freq2>)
			 (has-in-sense <entity2> <sense2>)))
		
		(msg-path <entity1> <entity2>))))))
  )
 (effects ((add (msg-completed <entity1> <req1>)))
  )
 )



;;;
;;; periph-complete
;;;
;;; Remove some clutter from infer-configure.
;;; Setup abstraction in order to prefer entity bindings.
  
(INFER-PERIPH-COMPLETE
 (params (<entity1> <req1>))
 (preconds (and
	    (is-entity <entity1> <req1>)    ; sanity check.


	    ;;
	    ;; Make sure entity has access to all periphs it needs.

	    (forall (<periph1>) (is-periph <periph1>)
	     (or


	      ;;
	      ;; Trvial case, entity doesn't need this periph.

	      (~ (drives-periph <entity1> <periph1>))
	      

	      ;;
	      ;; Entity does need this periph, sub-goal to attach it.

	      (and (drives-periph <entity1> <periph1>)
		   (entity-periph-link <entity1> <periph1>)))))

  )
 (effects ((add (periph-completed <entity1> <req1>)))
  )
 )
  




;;;
;;; entity-periph-link
;;;
;;; Determine whether a software object can access a peripheral
;;; by virtue of their associations with a distributed node.

(INFER-ENTITY-PERIPH-LINK
 (params (<entity> <periph>))
 (preconds (and
	    (drives-periph <entity> <periph>)      ; generate both fields.
	    (supports-periph <site> <periph>)      ; generate mediary site.

	    (mounted <entity> <site>)              ; is the setup complete.
	    (periph-attached <periph> <site>))
  )
 (effects ((add (entity-periph-link <entity> <periph>)))
  )
 )


)) ; Inference Rules













