;;
;; TESTING PROBLEM FILES:
;;    golden        : contains master schedule and ultimate plan
;;                        TRY AT OWN RISK!
;;*   suicide       : test simple suicide class in same quarter situation
;;*   time-conflict : test time conflicts in same quarter
;;*   prereq        : test if prerequisites are subgoaled and scheduled
;;*   innercore     : simple test to shedule innercore classes
;;*   quarter-full  : tests overloading / spill over of quarters.
;;
;;    *denotes good test case(s) available and ready to roll.

(setq *OPERATORS* '(


;;
;; ADD-INNERCORE-CLASS
;;   Has been improved by rearranging preconditions better.  Updating
;;   of credit counts (subgoaling) and quarter info is at the BOTTOM
;;   of the preconditions so that the static preconditions can be run
;;   prior to possible subgoaling on credits.
;;
;;   There are a few preconditions handled here that have been implemented
;;   as SCRs but are not used as a result of the "FATAL" problem with 
;;   this domain described in README.  The sections of interest are
;;   resolving suicide classes and prerequisite scheduling.  The name
;;   of the SCR to be used is listed in the codes comments.  If and
;;   when a solution to "FATAL" is found, they can be implemented to
;;   further cut the search.

(ADD-INNERCORE-CLASS
 (PARAMS (<class> <quarter> <year>))
 (PRECONDS
  (AND

   ;; Grab a candidate quarter that is NOT full!
   ;;   ie. there is limit to the number of classes to be taken
   ;;       in a quarter defined by predicate Quarter-info.
   (Quarter-not-full <quarter> <year>)

   ;; Grab course information
   (Class-core    <class> INNERCORE)

   ;; Make sure no suicidal classes are already scheduled in same quarter.
   ;;   Note that the tuesday and thursday section bindings are identical.
   ;;   The SCR that implements this for future use is:
   ;;     REJECT-SCHEDULING-CLASS-IN-SAME-QUARTER-WITH-SUICIDE
   (FORALL
    (<suicide-class>)
    (Class-no-take-with <class> <suicide-class>)
    (~ (Scheduled <suicide-class> <quarter> <year>
		  <ss-m-sect>  M  <ss-m-start>  <ss-m-end>
		  <ss-t-sect>  T  <ss-t-start>  <ss-t-end>
		  <ss-w-sect>  W  <ss-w-start>  <ss-w-end>
		  <ss-t-sect>  TH <ss-th-start> <ss-th-end>
		  <ss-f-sect>  F  <ss-f-start>  <ss-f-end>)))
   
   ;; Make sure that the candidate class does not have a time conflict with
   ;;   ALL classes currently scheduled in the same quarter / year
   (AND

    ;; Pick an available schedule, note that the section number for Tuesday
    ;;   and Thursday MUST be the same.
    (Class-time <class> <quarter> <m-section>  M  <m-start>  <m-end>)
    (Class-time <class> <quarter> <t-section>  T  <t-start>  <t-end>)
    (Class-time <class> <quarter> <w-section>  W  <w-start>  <w-end>)
    (Class-time <class> <quarter> <t-section> TH  <th-start> <th-end>)
    (Class-time <class> <quarter> <f-section>  F  <f-start>  <f-end>)
   
    ;; Grab ALL other classes currently scheduled in the quarter / year
    (FORALL 
     (<other-class>
      <s-m-sect>  <s-m-start>  <s-m-end>
      <s-t-sect>  <s-t-start>  <s-t-end>
      <s-w-sect>  <s-w-start>  <s-w-end>
                  <s-th-start> <s-th-end>
      <s-f-sect>  <s-f-start>  <s-f-end>)
     
     (Scheduled <other-class> <quarter> <year>
		<s-m-sect>  M  <s-m-start>  <s-m-end>
		<s-t-sect>  T  <s-t-start>  <s-t-end>
		<s-w-sect>  W  <s-w-start>  <s-w-end>
		<s-t-sect>  TH <s-th-start> <s-th-end>
		<s-f-sect>  F  <s-f-start>  <s-f-end>)

     ;; Make sure there is NO time conflicts with these classes
     (AND
      (No-time-conflict <s-m-start>  <s-m-end>  <m-start>  <m-end>)
      (No-time-conflict <s-t-start>  <s-t-end>  <t-start>  <t-end>)
      (No-time-conflict <s-w-start>  <s-w-end>  <w-start>  <w-end>)
      (No-time-conflict <s-t-start>  <s-th-end> <th-start> <th-end>)
      (No-time-conflict <s-f-start>  <s-f-end>  <f-start>  <f-end>))))

   ;; Make sure that EVERY prerequisite has been scheduled AND that
   ;;   they are scheduled in earlier quarters
   ;;   The SCR that implements this for future use is:
   ;;     REJECT-SCHEDULING-CLASS-WHOSE-PREREQS-NOT-SCHEDULED
   (FORALL
    (<prereq-class>)
    (Class-prereq <class> <prereq-class>)
    (AND
     (Scheduled-class <prereq-class>)
     (Scheduled <prereq-class>  <prereq-quarter> <prereq-year>
		<prereq-m-sect>  M  <prereq-m-start>  <prereq-m-end>
		<prereq-t-sect>  T  <prereq-t-start>  <prereq-t-end>
		<prereq-w-sect>  W  <prereq-w-start>  <prereq-w-end>
		<prereq-t-sect>  TH <prereq-th-start> <prereq-th-end>
		<prereq-f-sect>  F  <prereq-f-start>  <prereq-f-end>)
     (Quarter-less-than <prereq-quarter> <prereq-year>
                        <quarter>        <year>)))

   ;; Time to update credit totals
   (Class-credits <class> <credits>)

   ;; To simplify, used fixed class credits of 5 until we get sucker
   ;;   pruned down. Search TOO big now to concider variable credits.
   ;;   This non-static generator is REQUIRED so that it can backtrack
   ;;   to generate other possible bindings for credit-count.
   (Generate-credits  <credit-count> <new-credit-count> 5)
   (innercore-credits <credit-count>)

   ;; Time to update number of courses taken in the quarter
   (Quarter-info     <quarter> <year> <max-in-quarter> <quarter-count>)
   (Increment        <quarter-count>  <new-quarter-count>)
    ))
  (EFFECTS 
   ((ADD (Scheduled <class> <quarter> <year> 
	  <m-section>  M  <m-start>  <m-end>
	  <t-section>  T  <t-start>  <t-end>
	  <w-section>  W  <w-start>  <w-end>
	  <t-section> TH <th-start>  <th-end>
	  <f-section>  F  <f-start>  <f-end>))
    (ADD (Scheduled-class <class>))

    ;; Update the quarter information and remove Quarter-not-full if 
    ;;   quarter is NOW full having added the class
    (DEL (Quarter-info <quarter> <year> <max-in-quarter> <quarter-count>))
    (ADD (Quarter-info <quarter> <year> <max-in-quarter> <new-quarter-count>))
    (IF  (Quarter-full <new-quarter-count> <max-in-quarter>)
	 (DEL (Quarter-not-full <quarter> <year>)))

    ;; Update the number of innercore credits scheduled
    (DEL (innercore-credits <credit-count>))
    (ADD (innercore-credits <new-credit-count>)) )))

(ADD-OUTERCORE-CLASS
 (PARAMS (<class> <quarter> <year>))
 (PRECONDS
  (AND
   (Quarter-not-full <quarter> <year>)

   (Class-core    <class> OUTERCORE)

   (FORALL
    (<suicide-class>)
    (Class-no-take-with <class> <suicide-class>)
    (~ (Scheduled <suicide-class> <quarter> <year>
		  <ss-m-sect>  M  <ss-m-start>  <ss-m-end>
		  <ss-t-sect>  T  <ss-t-start>  <ss-t-end>
		  <ss-w-sect>  W  <ss-w-start>  <ss-w-end>
		  <ss-t-sect>  TH <ss-th-start> <ss-th-end>
		  <ss-f-sect>  F  <ss-f-start>  <ss-f-end>)))
   
   (AND
    (Class-time <class> <quarter> <m-section>  M  <m-start>  <m-end>)
    (Class-time <class> <quarter> <t-section>  T  <t-start>  <t-end>)
    (Class-time <class> <quarter> <w-section>  W  <w-start>  <w-end>)
    (Class-time <class> <quarter> <t-section> TH  <th-start> <th-end>)
    (Class-time <class> <quarter> <f-section>  F  <f-start>  <f-end>)

    (FORALL 
     (<other-class>
      <s-m-sect>  <s-m-start>  <s-m-end>
      <s-t-sect>  <s-t-start>  <s-t-end>
      <s-w-sect>  <s-w-start>  <s-w-end>
                  <s-th-start> <s-th-end>
      <s-f-sect>  <s-f-start>  <s-f-end>)
     
     (Scheduled <other-class> <quarter> <year>
		<s-m-sect>  M  <s-m-start>  <s-m-end>
		<s-t-sect>  T  <s-t-start>  <s-t-end>
		<s-w-sect>  W  <s-w-start>  <s-w-end>
		<s-t-sect>  TH <s-th-start> <s-th-end>
		<s-f-sect>  F  <s-f-start>  <s-f-end>)
     (AND
      (No-time-conflict <s-m-start>  <s-m-end>  <m-start>  <m-end>)
      (No-time-conflict <s-t-start>  <s-t-end>  <t-start>  <t-end>)
      (No-time-conflict <s-w-start>  <s-w-end>  <w-start>  <w-end>)
      (No-time-conflict <s-t-start>  <s-th-end> <th-start> <th-end>)
      (No-time-conflict <s-f-start>  <s-f-end>  <f-start>  <f-end>))))

   (FORALL
    (<prereq-class>)
    (Class-prereq <class> <prereq-class>)
    (AND
     (Scheduled-class <prereq-class>)
     (Scheduled <prereq-class>  <prereq-quarter> <prereq-year>
		<prereq-m-sect>  M  <prereq-m-start>  <prereq-m-end>
		<prereq-t-sect>  T  <prereq-t-start>  <prereq-t-end>
		<prereq-w-sect>  W  <prereq-w-start>  <prereq-w-end>
		<prereq-t-sect>  TH <prereq-th-start> <prereq-th-end>
		<prereq-f-sect>  F  <prereq-f-start>  <prereq-f-end>)
     (Quarter-less-than <prereq-quarter> <prereq-year>
                        <quarter>        <year>)))

   (Class-credits <class> <credits>)
   (Generate-credits  <credit-count> <new-credit-count> 5)
   (outercore-credits <credit-count>)

   (Quarter-info     <quarter> <year> <max-in-quarter> <quarter-count>)
   (Increment        <quarter-count>  <new-quarter-count>)
    ))
  (EFFECTS 
   ((ADD (Scheduled <class> <quarter> <year> 
	  <m-section>  M  <m-start>  <m-end>
	  <t-section>  T  <t-start>  <t-end>
	  <w-section>  W  <w-start>  <w-end>
	  <t-section> TH <th-start>  <th-end>
	  <f-section>  F  <f-start>  <f-end>))
    (ADD (Scheduled-class <class>))

    (DEL (Quarter-info <quarter> <year> <max-in-quarter> <quarter-count>))
    (ADD (Quarter-info <quarter> <year> <max-in-quarter> <new-quarter-count>))
    (IF  (Quarter-full <new-quarter-count> <max-in-quarter>)
	 (DEL (Quarter-not-full <quarter> <year>)))

    (DEL (outercore-credits <credit-count>))
    (ADD (outercore-credits <new-credit-count>)) )))

(ADD-ELECTIVECORE-CLASS
 (PARAMS (<class> <quarter> <year>))
 (PRECONDS
  (AND
   (Quarter-not-full <quarter> <year>)

   (Class-core    <class> ELECTIVECORE)

   (FORALL
    (<suicide-class>)
    (Class-no-take-with <class> <suicide-class>)
    (~ (Scheduled <suicide-class> <quarter> <year>
		  <ss-m-sect>  M  <ss-m-start>  <ss-m-end>
		  <ss-t-sect>  T  <ss-t-start>  <ss-t-end>
		  <ss-w-sect>  W  <ss-w-start>  <ss-w-end>
		  <ss-t-sect>  TH <ss-th-start> <ss-th-end>
		  <ss-f-sect>  F  <ss-f-start>  <ss-f-end>)))
   
   (AND
    (Class-time <class> <quarter> <m-section>  M  <m-start>  <m-end>)
    (Class-time <class> <quarter> <t-section>  T  <t-start>  <t-end>)
    (Class-time <class> <quarter> <w-section>  W  <w-start>  <w-end>)
    (Class-time <class> <quarter> <t-section> TH  <th-start> <th-end>)
    (Class-time <class> <quarter> <f-section>  F  <f-start>  <f-end>)
   
    (FORALL 
     (<other-class>
      <s-m-sect>  <s-m-start>  <s-m-end>
      <s-t-sect>  <s-t-start>  <s-t-end>
      <s-w-sect>  <s-w-start>  <s-w-end>
                  <s-th-start> <s-th-end>
      <s-f-sect>  <s-f-start>  <s-f-end>)
     
     (Scheduled <other-class> <quarter> <year>
		<s-m-sect>  M  <s-m-start>  <s-m-end>
		<s-t-sect>  T  <s-t-start>  <s-t-end>
		<s-w-sect>  W  <s-w-start>  <s-w-end>
		<s-t-sect>  TH <s-th-start> <s-th-end>
		<s-f-sect>  F  <s-f-start>  <s-f-end>)
     (AND
      (No-time-conflict <s-m-start>  <s-m-end>  <m-start>  <m-end>)
      (No-time-conflict <s-t-start>  <s-t-end>  <t-start>  <t-end>)
      (No-time-conflict <s-w-start>  <s-w-end>  <w-start>  <w-end>)
      (No-time-conflict <s-t-start>  <s-th-end> <th-start> <th-end>)
      (No-time-conflict <s-f-start>  <s-f-end>  <f-start>  <f-end>))))

   (FORALL
    (<prereq-class>)
    (Class-prereq <class> <prereq-class>)
    (AND
     (Scheduled-class <prereq-class>)
     (Scheduled <prereq-class>  <prereq-quarter> <prereq-year>
		<prereq-m-sect>  M  <prereq-m-start>  <prereq-m-end>
		<prereq-t-sect>  T  <prereq-t-start>  <prereq-t-end>
		<prereq-w-sect>  W  <prereq-w-start>  <prereq-w-end>
		<prereq-t-sect>  TH <prereq-th-start> <prereq-th-end>
		<prereq-f-sect>  F  <prereq-f-start>  <prereq-f-end>)
     (Quarter-less-than <prereq-quarter> <prereq-year>
                        <quarter>        <year>)))

   (Class-credits <class> <credits>)
   (Generate-credits  <credit-count> <new-credit-count> 5)
   (electivecore-credits <credit-count>)

   (Quarter-info     <quarter> <year> <max-in-quarter> <quarter-count>)
   (Increment        <quarter-count>  <new-quarter-count>)
    ))
  (EFFECTS 
   ((ADD (Scheduled <class> <quarter> <year> 
	  <m-section>  M  <m-start>  <m-end>
	  <t-section>  T  <t-start>  <t-end>
	  <w-section>  W  <w-start>  <w-end>
	  <t-section> TH <th-start>  <th-end>
	  <f-section>  F  <f-start>  <f-end>))
    (ADD (Scheduled-class <class>))

    (DEL (Quarter-info <quarter> <year> <max-in-quarter> <quarter-count>))
    (ADD (Quarter-info <quarter> <year> <max-in-quarter> <new-quarter-count>))
    (IF  (Quarter-full <new-quarter-count> <max-in-quarter>)
	 (DEL (Quarter-not-full <quarter> <year>)))

    (DEL (electivecore-credits <credit-count>))
    (ADD (electivecore-credits <new-credit-count>)) )))


;;
;; ADD-INNERCORE-COMPLETED:
;;   Allows us to add InnerCoreCompleted to the state AND enables us
;;   to subgoal on the number of credits required.
;;
;;   We are currently set up to handle fixed credit increments so that
;;   credit additions match exactly with the goal, never exceeding it.
;;   eg. this case NOT handled but can easily be implemented swapping
;;       commented code once search is pruned down effectivly.
;;     (innercore-credits  18)
;;     (innercore-required 20)
;;     take a class for 4 credits for total of 22
;;
;;   Again, we do this to cut down the search until other aspects
;;   of the search are pruned to reasonable levels.

(ADD-INNERCORE-COMPLETED
 (preconds
  (and
   (innercore-required <required>)

   ;;Variable credits
;   (Core-completed <count> <required>)
;   (innercore-credits <count>)

   ;;Fixed credits
   (innercore-credits <required>)))
 (effects
  ((add (InnerCoreCompleted)))))

(ADD-OUTERCORE-COMPLETED
 (preconds
  (and
   (outercore-required <required>)
;   (Core-completed <count> <required>)
;   (outercore-credits <count>)
   (outercore-credits <required>)))
 (effects
  ((add (OuterCoreCompleted)))))

(ADD-ELECTIVECORE-COMPLETED
 (preconds
  (and
   (electivecore-required <required>)
;   (Core-completed <count> <required>)
;   (electivecore-credits <count>)
   (electivecore-credits <required>)))
 (effects
  ((add (ElectiveCoreCompleted)))))

))


(setq *INFERENCE-RULES* '(

;;
;; INFER-SCHEDULE-COMPLETE:
;;   Allows our top level goal to be added to the state.
;;   We currently have Outer and Elective core completed
;;   requirements commented out to reduce the search.
;;

(INFER-SCHEDULE-COMPLETE
 (preconds
  (InnerCoreCompleted))
;  (OuterCoreCompleted)
;  (ElectiveCoreCompleted))
 (effects
  ((add (ScheduleComplete)))))

))








