(setq *OPERATORS* '(

;;;
;;; TAKE
;;;
;;; Takes a course if the course has not already been taken, the maximum number
;;; of credits in a quarter will not be exceeded, and it is offered.
;;;
;;; This function does use a non-static generators: havetaken
;;; Before I can apply the operator, I need to know if I have already taken
;;; the course, and this may change from one state to the next.
;;;

(TAKE
 (params (<course> <quarter> <year> <credits>))
 (preconds (and 
	        (forall (<q> <y>) (offered <course> <q> <y> <c>)
		 (~ (time-taken <course> <q> <y> <c>)))
	        (offered <course> <quarter> <year> <credits>)
		(attending <quarter> <year>)
	        (creditlimit <quarter> <year> <max-credits>)
		(minus <max-credits> <credits> <new-max-credits>)
		(geqzero <new-max-credits>)
	        (forall (<prereq>) (prerequisite <prereq> <course>)
		 (and (offered <prereq> 
			       <prereq-quarter>
			       <prereq-year>
			       <prereq-credits>)
		  (earlier <prereq-quarter> <prereq-year> <quarter> <year>)
		  (time-taken <prereq>
			      <prereq-quarter>
			      <prereq-year>
			      <prereq-credits>)))
	        (forall (<prereq-c>) (conc-prereq <prereq-c> <course>)
		 (and (offered <prereq-c> 
			       <prereq-c-quarter>
			       <prereq-c-year>
			       <prereq-c-credits>)
		  (conc-or-earlier <prereq-c-quarter> <prereq-c-year>
				   <quarter> <year>)
		  (time-taken <prereq-c>
			      <prereq-c-quarter>
			      <prereq-c-year>
			      <prereq-c-credits>)))
	    ))
 (effects ((del (creditlimit <quarter> <year> <max-credits>))
	   (add (creditlimit <quarter> <year> <new-max-credits>))
	   (add (time-taken <course> <quarter> <year> <credits>)))))

;;;
;;; TAKE-COURSE-SET
;;;
;;; Used to achieve taken-courses.  Must have (taken-course <num> <set>)
;;; in the start state.
;;;

(TAKE-COURSE-SET
 (params (<course>))
 (preconds (and
	        (legal-member <course> <set>)
	        (~ (used-course <course> <set>))
	        (time-taken <course> <quarter> <year> <credits>)
	        (minus <new-num> 1 <old-num>)
	        (taken-courses <old-num> <set>)))
 (effects (
	   (add (used-course <course> <set>))
	   (del (taken-courses <old-num> <set>))
	   (add (taken-courses <new-num> <set>))
	   )))

;;;
;;; TAKE-CREDIT-SET
;;;
;;; Used to achieve taken-credits.  Must have (taken-credits <num> <set>)
;;; and (init-credits <num> <set>) in the start state.
;;;

(TAKE-CREDIT-SET
 (params (<course>))
 (preconds (and
	        (legal-member <course> <set>)
	        (~ (used-credit <course> <set>))
	        (time-taken <course> <quarter> <year> <credits>)
	        (minus <new-num> <credits> <old-num>)
	        (init-credits <init-num> <set>)
	        (maximum <init-num> <old-num> <use-num>)
	        (taken-credits <use-num> <set>)))
 (effects (
	   (add (used-credit <course> <set>))
	   (del (taken-credits <use-num> <set>))
	   (add (taken-credits <new-num> <set>)))))
))


(setq *INFERENCE-RULES* '(

 (INFER-HAVETAKEN
  (params (<course>))
  (preconds (time-taken <course> <quarter> <year> <credits>))
  (effects ((add (havetaken <course>)))))

))



