;; ****************************************************************************
;;
;;            CONTROL RULES
;;
;; ****************************************************************************


(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* '(

    (SELECT-FIRST-GOAL
    ;;
    ;; default control rule
    ;;
    (lhs (and (current-node <node>)
	      (not-top-level-node <node>)
              (primary-candidate-goal <node> <goal>)))
    (rhs (select goal <goal>)))
))

(setq *SCR-OP-SELECT-RULES* '(

    (SEASON-FOOD-WITH-SPICE
    ;;
    ;; If <obj> is known to be food, then select operator
    ;; SEASON-WITH.
    ;;
    (lhs (and (current-node <node>)
              (current-goal <node> (~ (add-spice <sps> <obj>)))
              (known <node> (object <obj>))
              (candidate-op <node> SEASON-WITH)))
    (rhs (select operator SEASON-WITH)))

    (ADD-SEASONING-TO-UTENSIL
    ;; 
    ;; If <obj> is known to be one of the utensils, then select
    ;; operator ADD-SEASONING.
    ;;
    (lhs (and (current-node <node>)
              (current-goal <node> (~ (add-spice <sps> <obj>)))
              (known <node> (tools <obj> <opr>))
              (candidate-op <node> ADD-SEASONING-TO)))
    (rhs (select operator ADD-SEASONING-TO)))
))
    
              
(setq *SCR-BINDINGS-SELECT-RULES* nil)

(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* '(

    (DONT-SUBGOAL-ON-SCHEDULE
    ;;
    ;; This rules is to avoid the case in which the initial
    ;; state fails to have (last-scheduled <obj> <time>)
    ;; for all the objects, tools, and stoves, but it still
    ;; returns the path, which is totally wrong.
    ;;
    (lhs (and (current-node <node>)
              (current-goal <node> (last-scheduled <obj> <time>))))
    (rhs (reject goal (last-scheduled <obj> <time>))))
              
))
(setq *SCR-OP-REJECT-RULES* nil)

(setq *SCR-BINDINGS-REJECT-RULES* '(
;;
;; The following control rules are similar to those which are
;; in better-sc-rules.lisp in SCHEDWORLD.
;;   An operator that fail at timeA will not succeed if they are
;; tried at any later time, timeB, in the same order.
;;
    (AVOID-UNNECESSARY-BACKTRACK-FOR-ADD
    ;;
    ;; If both CUTTING and WASHING were idle at <time-1> and 
    ;; object was doing nothing, but ADD operator failed, then
    ;; the operator will fail at <time>, so reject the binding
    ;; which will bind time to <time>.
    ;;
    (lhs (and (current-node <node>)
              (current-op <node> ADD)
              (current-goal <node>  (idle <opr> <time>))
              (candidate-bindings <node> (<obj> <tool> <time>))
              (previous-slot <time> <pre-time>)
              (known <node>
              (and  (last-scheduled <obj> <time1>)
                    (less-than <time1> <pre-time>)))
              (~ (known <node> (last-scheduled <obj> <pre-time>)))
              (~ (known <node> (scheduled CUTTING <pre-time>)))
              (~ (known <node> (scheduled WASHING <pre-time>)))))
    (rhs (reject bindings (<obj> <tool> <time>))))

    (AVOID-UNNECESSARY-BACKTRACK-FOR-WASH
    ;;
    ;; If ADDING, CUTTING, and WASHING were idle at <time-1> and
    ;; the object was doing nothing, but WASH operator failed, then
    ;; the operator will also fail at <time>, so reject the binding
    ;; which will bind time to <time>.
    ;;
    (lhs (and (current-node <node>)
              (current-op <node> <opr>)
              (current-goal <node> (idle <opr> <time>))
              (or (is-equal <opr> WASH-INGREDIENT)
                  (is-equal <opr> WASH-UTENSIL))
              (candidate-bindings <node> (<obj> <time>))
              (previous-slot <time> <pre-time>)
              (known <node>
              (and (last-scheduled <obj> <time1>)
                   (less-than <time1> <pre-time>)))
              (~ (known <node> (last-scheduled <obj> <pre-time>)))
              (~ (known <node> (scheduled CUTTING  <pre-time>)))
              (~ (known <node> (scheduled WASHING <pre-time>)))))
     (rhs (reject bindings (<obj> <time>))))


     (AVOID-UNNECESSARY-BACKTRACK-FOR-CUT
     ;;
     ;; If ADDING, WASHING, and CUTTING were idle at <time-1> and
     ;; the object was doing nothing, but CUT operator failed,
     ;; then the operator will also fail at <time>, so reject the
     ;; binding which will bind time to <time>.
     ;;
     (lhs (and (current-node <node>)
               (current-op <node> CUT)
               (current-goal <node> (idle <opr> <time>))
               (candidate-bindings <node> (<obj> <how-to> <time>))
               (previous-slot <time> <pre-time>)
               (known <node>
               (and (last-scheduled <obj> <time1>)
                    (less-than <time1> <pre-time>)))
               (~ (known <node> (last-scheduled <obj> <pre-time>)))
               (~ (known <node> (scheduled WASHING <pre-time>)))
               (~ (known <node> (scheduled CUTTING <pre-time>)))))
     (rhs (reject bindings (<obj> <how-to> <time>))))


     (AVOID-UNNECESSARY-BACKTRACK-FOR-SEASONING
     ;;
     ;; If the object was doing nothing at <time-1>, but SEASON-
     ;; WITH operator failed, then the operator will also fail at
     ;; <time>, so reject the binding which will bind time to
     ;; <time>.
     ;;
     (lhs (and (current-node <node>)
               (current-goal <node> <goal>)
               (current-op <node> SEASON-WITH)
               (candidate-bindings <node> (<obj> <sps> <time>))
               (previous-slot <time> <pre-time>)
               (known <node>
               (and (last-scheduled <obj> <time1>)
                    (less-than <time1> <pre-time>)))
               (~ (known <node> (last-scheduled <obj> <pre-time>)))))
     (rhs (reject bindings (<obj> <sps> <time>))))

     (AVOID-UNNECESSARY-BACKTRACK-FOR-SERVING
     ;;
     ;; If the tool used was doing nothing at <time-1>, but
     ;; SERVE-DISH-FROM-TO operator failed, then the operator will 
     ;; also fail at <time>, so reject the binding which will bind
     ;; time to <time>.
     ;;
     (lhs (and (current-node <node>)
               (current-goal <node> <goal>)
               (current-op <node> SERVE-DISH-FROM-TO)
               (candidate-bindings <node> (<tool> <plate> <time>))
               (previous-slot <time> <pre-time>)
               (known <node>
               (and (last-scheduled <tool> <time1>)
                    (less-than <time1> <pre-time>)))
               (~ (known <node> (last-scheduled <tool> <pre-time>)))))
     (rhs (reject bindings (<tool> <plate> <time>))))



   ;; ******************************************************* ;;

   (USE-OVEN-ONLY-FOR-BAKE-OR-BROIL
   ;;
   ;; if the operation is other than baking or broiling, use 
   ;; stove instead of oven.
   ;;
   (lhs (and (current-node <node>)
             (current-op <node> FINISH)
             (candidate-bindings <node>
                 (<opr> <stove> <time>))
             (is-equal <stove> oven)
             (not-equal bake <opr>)
             (not-equal broil <opr>)))
   (rhs (reject  bindings (<opr> <stove> <time>))))


))


(setq *SCR-NODE-PREFERENCE-RULES* nil)

(setq *SCR-GOAL-PREFERENCE-RULES* '(

    (DO-OTHER-OP-BEFORE-FRY
    ;;
    ;; If there are operators to finish besides fry,
    ;; do them first where it can. 
    ;; It will save some time.
    ;;
    (priority 0)
    (lhs (and (current-node <node>)
              (candidate-goal <node> (finished fry <obj1>))
              (candidate-goal <node> (finished <op> <obj2>))
              (not-equal <obj1> <obj2>)
              (not-equal <op> fry)))
    (rhs (prefer goal (finished <op> <obj2>)
                      (finished fry <obj1>))))
))


(setq *SCR-OP-PREFERENCE-RULES* 	nil)

(setq *SCR-BINDINGS-PREFERENCE-RULES* '(


    (USE-AVAILABLE-STOVE
    ;;
    ;; If stove1 is used but stove2 is availabe, then use stove2
    ;; instead of waiting for stove1 to be available.
    ;;
    (priority 0)
    (lhs (and (current-node <node>)
              (current-op <node> FINISH)
              (candidate-bindings <node>
                 (<opr> <stove1> <time1> ))
              (candidate-bindings <node> 
                 (<opr> <stove2> <time2>))
              (not-equal <stove1> <stove2>)
              (known <node>
                 (and (last-scheduled <stove1> <pre-time1>)
                      (last-scheduled <stove2> <pre-time2>)
                      (less-than <pre-time1> <pre-time2>)))))
    (rhs (prefer bindings 
              (<opr>  <stove1> <time1> )
              (<opr>  <stove2> <time2> ))))

   (USE-OVEN-FOR-BAKE-OR-BROIL
    ;;
    ;; to bake or broil food, it's better to use oven than other
    ;; stoves.
    ;; 
    (priority 1)
    (lhs (and (current-node <node>)
              (current-op <node> FINISH)
              (candidate-bindings <node>
                   (<opr> oven <time1>))
              (candidate-bindings <node>
                   (<opr> <stove2> <time2>))
              (not-equal oven <stove2>)
              (or (is-equal <opr> bake)
                  (is-equal <opr> broil))))
    (rhs (prefer bindings
             (<opr> oven <time1>)
             (<opr> <stove2> <time2>))))

    

 ))







