(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
;;; standard control rule
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))

(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES*
;;; since there is no way to create out-crops, there's no point in
;;; subgoaling on their existence. some operators require the
;;; existence of an out-crop in a certain region in their pre-
;;; conditions but unless it was in the start state, forget it.
      '((DONT-SUBGOAL-OUTCROP
          (lhs (and (current-node <node>)
                    (current-goal <node> (out-crop <x> <y>))))
          (rhs (reject goal (out-crop <x> <y>))))
       ))

(setq *SCR-OP-REJECT-RULES*
;;; these four operators prevent movement out of the legal
;;; coordinate system.  previously, the climber would make a goal
;;; like (at -1 5) which is impossible but it took a good deal of search
;;; to ascertain this. specifically, these rules say, if you're trying
;;; to get to a position on the edge of the grid, don't try to get
;;; there from off the grid.
      '((Y-MINIMUM
          (lhs (and (current-node <node>)
                    (current-goal <node> (at <x> 0))))
          (rhs (reject operator move-up)))
        (X-MINIMUM
          (lhs (and (current-node <node>)
                    (current-goal <node> (at 0 <y>))))
          (rhs (reject operator move-right)))
        (Y-MAXIMUM
          (lhs (and (current-node <node>)
                    (current-goal <node> (at <x> *Y-LIMIT*))))
          (rhs (reject operator move-down)))
        (X-MAXIMUM
          (lhs (and (current-node <node>)
                    (current-goal <node> (at *X-LIMIT* <y>))))
          (rhs (reject operator move-left)))
       ))

(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* '(
;;; these four control rules offer guidance to the climber in
;;; the direction he should move toward his goal.  if the
;;; current position is below (has smaller y-coordinate) the
;;; MOVE-UP operator will be preferred over others. similarly
;;; the PREFER-DOWN rule works when the climber is above the
;;; goal position. if he is at the same y-coordinate, the
;;; PREFER-LEFT and -RIGHT rules kick in and direct him
;;; further
   (PREFER-UP
      (priority 1)
      (lhs (and (current-node <node>)
                (current-goal <node> (at <x> <y>))
                (known <node> (and 
                   (at <at-x> <at-y>)
                   (greater-than <y> <at-y>)))))
      (rhs (prefer operator MOVE-UP <op2>)))

   (PREFER-DOWN
      (priority 1)
      (lhs (and (current-node <node>)
                (current-goal <node> (at <x> <y>))
                (known <node> (and 
                   (at <at-x> <at-y>)
                   (less-than <y> <at-y>)))))
      (rhs (prefer operator MOVE-DOWN <op2>)))

;;; note priority 2.
;;; this rule kicks in when goal <y> = at <y>
   (PREFER-RIGHT
      (priority 2)
      (lhs (and (current-node <node>)
                (current-goal <node> (at <x> <y>))
                (known <node> (and
                   (at <at-x> <at-y>)
                   (greater-than <x> <at-x>)))))
      (rhs (prefer operator MOVE-RIGHT <op2>)))

   (PREFER-LEFT
      (priority 2)
      (lhs (and (current-node <node>)
                (current-goal <node> (at <x> <y>))
                (known <node> (and
                   (at <at-x> <at-y>)
                   (less-than <x> <at-x>)))))
      (rhs (prefer operator MOVE-LEFT <op2>)))
   ))

(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)

