(setf *X-LIMIT* 20)
(setf *Y-LIMIT* 20)

;;; recusively form a binding list of the variable x to
;;; all the integers from beg to end
(defun number-list (x beg end &optional (accum nil))
  (if (> beg end)
      accum
      (number-list x (+ beg 1) end
        (cons (list (list x beg)) accum))))

;;; range checker on x-axis. x is bound to all integers
;;; from 0 to *X-LIMIT*
(defun in-rangex (x)
  (if (is-variable x)
      (number-list x 0 *X-LIMIT*)
      (and (<= x *X-LIMIT*) (<= 0 x))))

;;; range checker on y-axis. y is bound to all integers
;;; from 0 to *Y-LIMIT*
(defun in-rangey (y)
  (if (is-variable y)
      (number-list y 0 *Y-LIMIT*)
      (and (<= y *Y-LIMIT*) (<= 0 y))))

;;; depending on which (if any) is a variable, either
;;; a or b is bound to an integer such that a - n = b
(defun n-less (a b n)
  (cond ((and
    (is-variable a)
    (is-variable b))
    'no-match-attempted)
    ((is-variable a)
     (list (list (list a (- b n)))))
    ((is-variable b)
     (list (list (list b (+ a n)))))
    (t (= a (- b n)))))

;;; depending on which (if any) is a variable, either
;;; a or b is bound to a list of integers such that
;;; a <= b <= a+n
(defun within-n (a b n)
  (cond ((and
    (is-variable a)
    (is-variable b))
    'no-match-attempted)
    ((is-variable a)
     (number-list a (- b n) b))
    ((is-variable b)
     (number-list b a (+ a n)))
    (t (and
      (<= b (+ a n))
      (>= b a)))))

(defun greater-than (x y) (> x y))
(defun less-than (x y) (< x y))

