(setf *OPERATORS* '(

;;; the four "place" operators are quite similar. what
;;; applies to left-foot applies to them all.
;;; the idea is to find an out-crop in the 3-wide, 4-tall
;;; grid below and left of the body (described by "at").
;;; since exactly one instance of at exists at any time,
;;; the non-static generator is not a problem.  once <at-x>
;;; and <at-y> are bound, <x> and <y> receive binding-lists
;;; to the coordinates in the region stated above. if an
;;; out-crop exists in the region, the foot is placed there.
;;; the only difference in the other limbs is, the predicate
;;; name, and the region where the limb may be placed.  for
;;; hands it is a 3x3 region above and to the right and left
;;; of the body respectively.  foot regions are 3-wide,
;;; 4-tall, below the body.
(PLACE-LEFT-FOOT
  (params (<x> <y>))
  (preconds
    (and
      (at <at-x> <at-y>) ;non-static generator!
      (within-n <x> <at-x> 3) ;binds <x> to left of "at"
      (within-n <y> <at-y> 4) ;binds <y> below "at"
      (out-crop <x> <y>)
    ))
  (effects (
    (add (left-foot-on))
    (add (left-foot-at <x> <y>)))))

;;; see PLACE-LEFT-FOOT
(PLACE-RIGHT-FOOT
  (params (<x> <y>))
  (preconds
    (and
      (at <at-x> <at-y>) ;non-static generator!
      (within-n <at-x> <x> 3) ;binds <x> to right of "at"
      (within-n <y> <at-y> 4) ;binds <y> below "at"
      (out-crop <x> <y>)
    ))
  (effects (
    (add (right-foot-on))
    (add (right-foot-at <x> <y>)))))

;;; see PLACE-LEFT-FOOT
(PLACE-LEFT-HAND
  (params (<x> <y>))
  (preconds
    (and
      (at <at-x> <at-y>) ;non-static generator!
      (within-n <x> <at-x> 3) ;binds <x> to left of "at"
      (within-n <at-y> <y> 3) ;binds <y> above "at"
      (out-crop <x> <y>)
    ))
  (effects (
    (add (left-hand-on))
    (add (left-hand-at <x> <y>)))))

;;; see PLACE-LEFT-FOOT
(PLACE-RIGHT-HAND
  (params (<x> <y>))
  (preconds
    (and
      (at <at-x> <at-y>) ;non-static generator!
      (within-n <at-x> <x> 3) ;binds <x> to right of "at"
      (within-n <at-y> <y> 3) ;binds <y> above "at"
      (out-crop <x> <y>)
    ))
  (effects (
    (add (right-hand-on))
    (add (right-hand-at <x> <y>)))))

(LIFT-LEFT-FOOT
  (params (<lf-x> <lf-y>))
  (preconds
    (and
      (left-foot-on)
      (right-foot-on)
      (or
        (left-hand-on)
        (right-hand-on))
    ))
  (effects (
    (del (left-foot-on))
    (del (left-foot-at <lf-x> <lf-y>)))))

;;; see comments for LIFT-LEFT-FOOT
(LIFT-RIGHT-FOOT
  (params (<rf-x> <rf-y>))
  (preconds
    (and
      (right-foot-on)
      (left-foot-on)
      (or
        (left-hand-on)
        (right-hand-on))
    ))
  (effects (
    (del (right-foot-on))
    (del (right-foot-at <rf-x> <rf-y>)))))

;;; see comments for LIFT-LEFT-FOOT
(LIFT-LEFT-HAND
  (params (<lh-x> <lh-y>))
  (preconds
    (and
      (left-hand-on)
      (right-hand-on)
      (or
        (left-foot-on)
        (right-foot-on))
    ))
  (effects (
    (del (left-hand-on))
    (del (left-hand-at <lh-x> <lh-y>)))))

;;; see comments for LIFT-LEFT-FOOT
(LIFT-RIGHT-HAND
  (params (<rh-x> <rh-y>))
  (preconds
    (and
      (right-hand-on)
      (left-hand-on)
      (or
        (left-foot-on)
        (right-foot-on))
    ))
  (effects (
    (del (right-hand-on))
    (del (right-hand-at <rh-x> <rh-y>)))))

;;; these four operators are tricky but similar.
;;; the effect of UP is to add 1 to the y-coordinate of the
;;; "at" predicate. Prodigy binds <y+1> and <x> in trying
;;; to sub-goal so <y> must be generated. <y> is bound to a
;;; single number, that being <y+1> - 1. <y-4> is similar.
;;; the "forall" lines are to guarantee that no limb will be
;;; stretched beyond its legal region in the y-direction. for
;;; instance, if a hand's y-coordinate is <y> it is already
;;; at the bottom of its region; if "at" were moved up the
;;; hand would be illegally placed.
(MOVE-UP
  (params (<x> <y> <y+1>))
  (preconds
    (and
      (in-rangex <x>) ;generate <x>
      (in-rangey <y+1>) ;generate <y+1>
      (n-less <y> <y+1> 1) ;generate/bind <y>
      (n-less <y-4> <y> 4) ;bind <y-4>
      ;; see if there is any x-coordinate such that the
      ;; left hand is at (<any-x>,<y>) where <y> is the
      ;; body's current y-coordinate
      (forall (<any-x1>) (in-rangex <any-x1>)
        (~ (left-hand-at <any-x1> <y>)))
      (forall (<any-x2>) (in-rangex <any-x2>)
        (~ (right-hand-at <any-x2> <y>)))
      (forall (<any-x3>) (in-rangex <any-x3>)
        (~ (left-foot-at <any-x3> <y-4>)))
      (forall (<any-x4>) (in-rangex <any-x4>)
        (~ (right-foot-at <any-x4> <y-4>)))
      (at <x> <y>) ;sub-goal on this
      ))
  (effects (
     (add (at <x> <y+1>))
     (del (at <x> <y>))
     )))

;;; see comments for MOVE-UP
;;; note that this time it is the x-coordinate that changes
(MOVE-RIGHT
  (params (<x> <x+1> <y>))
  (preconds
    (and
      (in-rangey <y>) ;generate <y>
      (in-rangex <x+1>) ;generate <x+1>
      (n-less <x> <x+1> 1) ;generate/bind <x>
      (n-less <x-3> <x> 3) ;bind <x-3>
      (forall (<any-y1>) (in-rangey <any-y1>)
        (~ (left-hand-at <x-3> <any-y1>)))
      (forall (<any-y2>) (in-rangey <any-y2>)
        (~ (right-hand-at <x> <any-y2>)))
      (forall (<any-y3>) (in-rangey <any-y3>)
        (~ (left-foot-at <x-3> <any-y3>)))
      (forall (<any-y4>) (in-rangey <any-y4>)
        (~ (right-foot-at <x> <any-y4>)))
      (at <x> <y>) ;sub-goal on this
      ))
  (effects (
     (add (at <x+1> <y>))
     (del (at <x> <y>))
     )))

;;; see comments for MOVE-UP
(MOVE-DOWN
  (params (<x> <y> <y-1>))
  (preconds
    (and
      (in-rangex <x>) ;generate <x>
      (in-rangey <y-1>) ;generate <y-1>
      (n-less <y-1> <y> 1) ;generate/bind <y>
      (n-less <y> <y+3> 3) ;bind <y+3>
      (forall (<any-x1>) (in-rangex <any-x1>)
        (~ (left-hand-at <any-x1> <y+3>)))
      (forall (<any-x2>) (in-rangex <any-x2>)
        (~ (right-hand-at <any-x2> <y+3>)))
      (forall (<any-x3>) (in-rangex <any-x3>)
        (~ (left-foot-at <any-x3> <y>)))
      (forall (<any-x4>) (in-rangex <any-x4>)
        (~ (right-foot-at <any-x4> <y>)))
      (at <x> <y>) ;sub-goal on this
      ))
  (effects (
     (add (at <x> <y-1>))
     (del (at <x> <y>))
     )))

;;; see comments for MOVE-RIGHT
(MOVE-LEFT
  (params (<x> <x-1> <y>))
  (preconds
    (and
      (in-rangey <y>) ;generate <y>
      (in-rangex <x-1>) ;generate <x-1>
      (n-less <x-1> <x> 1) ;generate/bind <x>
      (n-less <x> <x+3> 3) ;bind <x+3>
      (forall (<any-y1>) (in-rangey <any-y1>)
        (~ (left-hand-at <x> <any-y1>)))
      (forall (<any-y2>) (in-rangey <any-y2>)
        (~ (right-hand-at <x+3> <any-y2>)))
      (forall (<any-y3>) (in-rangey <any-y3>)
        (~ (left-foot-at <x> <any-y3>)))
      (forall (<any-y4>) (in-rangey <any-y4>)
        (~ (right-foot-at <x+3> <any-y4>)))
      (at <x> <y>) ;sub-goal on this
      ))
  (effects (
     (add (at <x-1> <y>))
     (del (at <x> <y>))
     )))

))

(setf *INFERENCE-RULES* '(
;; there should probably be some but i couldn't think
;; of any. can you?
        ))
