

(proclaim '(special *START-STATE* *END-TIME*))

(eval-when (load compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map"))


; LESS-THAN 

(defun less-than (a b)
    (cond ((is-variable a) 'no-match-attempted)
	  ((is-variable b) 'no-match-attempted)
	  (t (< a b))))

(defun times-before (last-tme)
    (g-loop (init tme 1 ret-val nil)
	  (while (not (> tme last-tme)))
	  (do (push tme ret-val))
	  (next tme (+ 1 tme))
	  (result ret-val)))

(defun times-after (last-tme)
    (g-loop (init tme (+ 1 last-tme) ret-val nil)
	  (while (not (> tme *END-TIME*)))
	  (do (push tme ret-val))
	  (next tme (+ 1 tme))
	  (result ret-val)))

(defun before (tme last-tme)
    (cond ((and (is-variable tme) 
		(is-variable last-tme))
	   (error "before"))
	  ((is-variable tme)
	   (binding-list tme (times-before last-tme)))
	  ((is-variable last-tme)
	   (binding-list last-tme (times-after tme)))
	  ((> last-tme tme))))
	  

(defun previous-slot (tme prev-time)
   "This function only returns the time immediately previous"
   (cond ((and (is-variable tme)
	       (is-variable prev-time)) 'no-match-attempted)
	 ((is-variable tme)
	  (if (/= prev-time *end-time*)
	      (list (list (list tme (1+ prev-time))))))
	 ((is-variable prev-time)
	  (list (list (list prev-time (1- tme)))))
   )
)

(add-meta-fn 'previous-slot)

(defun less-than (x y)
  (cond ((is-variable x) 'no-match-attempted)
        ((is-variable y) 'no-match-attempted)
	((< x y) t)))

(defun later (tme prev-tme)
    (cond ((and (is-variable tme) 
		(is-variable prev-tme))
	   'no-match-attempted)
	  ((is-variable tme)
	   (binding-list tme (times-after prev-tme)))
	  ((is-variable prev-tme)
	   (binding-list prev-tme (times-before tme)))
	  ((> tme prev-tme))))

(defun is-time (tme)
    (cond ((is-variable tme) (binding-list tme (times-before *END-TIME*)))
          (t)))

;  BINDING-LIST returns a binding list for a single variable, only
;
(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))

(defun mult-binding-list (vars val-lists)
    (and vars
	 (g-loop (init ret-val nil vals (car val-lists) var (car vars)
		     rst-bindings (mult-binding-list (cdr vars) 
				      (cdr val-lists)))
	       (while vals)
	       (do (cond (rst-bindings
			     (setq ret-val 
				   (append
					  (g-map (b in rst-bindings)
						(save (cons (list var 
								  (car
								      vals)) b)))
					  ret-val)))
			 (t (push (list (list var (car vals))) ret-val))))
	       (next vals (cdr vals))
	       (result ret-val))))



